/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.DiffEntryUtils;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.LoadAverage;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class LoadAverageDiff
implements Difference {
    static final LoadAverageDiff readerInstance = new LoadAverageDiff(new double[0], new double[0]);
    static final String[] subColumnTitles = new String[]{DiffEntryUtils.OLD_VALUE_COLUMN_SUBTITEL, DiffEntryUtils.NEW_VALUE_COLUMN_SUBTITEL};
    static final Class<?>[] subColumnTypes = new Class[]{LoadAverage.class, LoadAverage.class};
    private LoadAverage oldLoad;
    private LoadAverage newLoad;

    public LoadAverageDiff(double[] oldLoad, double[] newLoad) {
        this.oldLoad = new LoadAverage(oldLoad);
        this.newLoad = new LoadAverage(newLoad);
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        return new LoadAverageDiff(LoadAverageDiff.readLoad(reader), LoadAverageDiff.readLoad(reader));
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        this.writeLoad(this.oldLoad.getLoadData(), writer);
        this.writeLoad(this.newLoad.getLoadData(), writer);
    }

    @Override
    public ProviderEntry getSubColumnEntry(int subColId) {
        if (subColId == 0) {
            return this.getOldValue();
        }
        if (subColId == 1) {
            return this.getNewValue();
        }
        throw new IllegalArgumentException("subColId (" + subColId + ") must be in range 0..1");
    }

    @Override
    public Class<? extends ProviderEntry>[] getSubColumnTypes() {
        return subColumnTypes;
    }

    @Override
    public String[] getSubColumnTitles() {
        return subColumnTitles;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        if (other == this) {
            return 0;
        }
        LoadAverageDiff otherEntry = (LoadAverageDiff)other;
        int result = this.oldLoad.compareTo(otherEntry.oldLoad, null);
        if (result != 0) {
            return result;
        }
        return this.newLoad.compareTo(otherEntry.newLoad, null);
    }

    @Override
    public boolean isNull() {
        return this.oldLoad.compareTo(this.newLoad, null) == 0;
    }

    @Override
    public int getNrOfStandardSubColumns() {
        return 2;
    }

    @Override
    public ProviderEntry getNewValue() {
        return this.newLoad;
    }

    @Override
    public ProviderEntry getOldValue() {
        return this.oldLoad;
    }

    private static double[] readLoad(ResourceReader reader) throws IOException {
        int length = reader.readInt32();
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = reader.readDouble();
        }
        return result;
    }

    private void writeLoad(double[] loadData, ResourceWriter writer) throws IOException {
        int length = loadData != null ? loadData.length : 0;
        writer.writeInt32(length);
        for (int i = 0; i < length; ++i) {
            writer.writeDouble(loadData[i]);
        }
    }
}

