/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsageDiff;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;

public class MemoryUsage
extends BaseQuantity<MemoryUsage> {
    public static MemoryUsage PROTOTYPE = new MemoryUsage();

    @Override
    protected MemoryUsage create() {
        return new MemoryUsage();
    }

    protected MemoryUsage() {
    }

    public MemoryUsage(long used, long max, long committed) {
        this.set(used, max, Math.min(committed, max));
        assert (committed == -1L || used <= committed);
    }

    protected MemoryUsage(long used, long max, long committed, boolean allowNegative) {
        this.set(used, max, Math.min(committed, max));
        assert (allowNegative || committed == -1L || used <= committed);
    }

    public long getUsedBytes() {
        return this.getQuantity();
    }

    public long getMaximumBytes() {
        return this.getTotalQuantity();
    }

    public long getCommittedBytes() {
        return this.getDisplayedQuantity();
    }

    public boolean hasUsedPercentage() {
        return this.hasPercentage();
    }

    public boolean hasCommittedPercentage() {
        return this.hasDisplayedPercentage();
    }

    public double getUsedPercentage() {
        return this.getPercentage();
    }

    public double getCommittedPercentage() {
        return this.getDisplayedPercentage();
    }

    @Override
    public Difference getDifference(ProviderEntry newEntry, ProviderEntry oldEntry) {
        MemoryUsage newUsage = newEntry != null ? (MemoryUsage)newEntry : new MemoryUsage();
        MemoryUsage oldUsage = oldEntry != null ? (MemoryUsage)oldEntry : new MemoryUsage();
        return new MemoryUsageDiff(newUsage, oldUsage);
    }

    @Override
    public ProviderEntry getAccumulation(ProviderEntry[] entries) {
        long resultValue = 0L;
        for (ProviderEntry entry : entries) {
            resultValue += ((MemoryUsage)entry).getQuantity();
        }
        return this.create(resultValue);
    }
}

