/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;

public class MemoryUsageBeforeAndAfter
implements Quantity {
    private long before;
    private long after;
    private long max;

    public MemoryUsageBeforeAndAfter(long before, long after, long max) {
        this.before = before;
        this.after = after;
        this.max = max;
    }

    public long getBefore() {
        return this.before;
    }

    public long getAfter() {
        return this.after;
    }

    public long getMax() {
        return this.max;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        MemoryUsageBeforeAndAfter otherUsage = (MemoryUsageBeforeAndAfter)other;
        long diffQuantity = this.getQuantity() - otherUsage.getQuantity();
        if (diffQuantity != 0L) {
            return diffQuantity < 0L ? -1 : 1;
        }
        return this.before < otherUsage.before ? -1 : (this.before > otherUsage.before ? 1 : 0);
    }

    @Override
    public long getQuantity() {
        return this.after - this.before;
    }
}

