/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.entries.DiffEntryUtils;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsage;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class MemoryUsageDiff
extends MemoryUsage {
    static final MemoryUsageDiff readerInstance = new MemoryUsageDiff(new MemoryUsage(), new MemoryUsage());
    static final String[] subColumnTitles = new String[]{DiffEntryUtils.DIFFERENCE_COLUMN_SUBTITEL, DiffEntryUtils.OLD_VALUE_COLUMN_SUBTITEL, DiffEntryUtils.NEW_VALUE_COLUMN_SUBTITEL};
    static final Class<?>[] subColumnTypes = new Class[]{MemoryUsageDiff.class, MemoryUsage.class, MemoryUsage.class};
    private MemoryUsage newUsage;
    private MemoryUsage oldUsage;

    MemoryUsageDiff(MemoryUsage newUsage, MemoryUsage oldUsage) {
        super(newUsage.getUsedBytes() - oldUsage.getUsedBytes(), Math.max(newUsage.getMaximumBytes(), oldUsage.getMaximumBytes()), newUsage.getCommittedBytes() >= 0L && oldUsage.getCommittedBytes() >= 0L ? newUsage.getCommittedBytes() - oldUsage.getCommittedBytes() : 0L, true);
        this.newUsage = newUsage;
        this.oldUsage = oldUsage;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        long used1 = reader.readInt64();
        long committed1 = reader.readInt64();
        long max1 = reader.readInt64();
        long used2 = reader.readInt64();
        long committed2 = reader.readInt64();
        long max2 = reader.readInt64();
        return new MemoryUsageDiff(new MemoryUsage(used1, max1, committed1), new MemoryUsage(used2, max2, committed2));
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.newUsage.getUsedBytes());
        writer.writeInt64(this.newUsage.getCommittedBytes());
        writer.writeInt64(this.newUsage.getMaximumBytes());
        writer.writeInt64(this.oldUsage.getUsedBytes());
        writer.writeInt64(this.oldUsage.getCommittedBytes());
        writer.writeInt64(this.oldUsage.getMaximumBytes());
    }

    @Override
    public ProviderEntry getSubColumnEntry(int subColId) {
        if (subColId == 0) {
            return this;
        }
        if (subColId == 1) {
            return this.oldUsage;
        }
        if (subColId == 2) {
            return this.newUsage;
        }
        throw new IllegalArgumentException("subColId must be in range 0..2");
    }

    @Override
    public Class<? extends ProviderEntry>[] getSubColumnTypes() {
        return subColumnTypes;
    }

    @Override
    public boolean isNull() {
        return this.getUsedBytes() == 0L && (this.getCommittedBytes() == -1L || this.getCommittedBytes() == 0L);
    }

    @Override
    public MemoryUsage getNewValue() {
        return this.newUsage;
    }

    @Override
    public MemoryUsage getOldValue() {
        return this.oldUsage;
    }
}

