/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.MonitorObject;
import com.sap.jvm.profiling.core.type.MonitorObjectUsage;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class MonitorObjectEntry
implements UniqueEntry,
PersistableProviderEntry {
    private final MonitorObject monitorObject;
    private final MonitorObjectUsage monitorUsage;

    public MonitorObjectEntry(MonitorObject monitorObject, MonitorObjectUsage monitorUsage) {
        this.monitorObject = monitorObject;
        this.monitorUsage = monitorUsage;
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        return this.compareTo(other, null);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        MonitorObjectEntry otherEntry = (MonitorObjectEntry)other;
        return this.monitorObject.compareTo(otherEntry.getMonitorObject());
    }

    public MonitorObject getMonitorObject() {
        return this.monitorObject;
    }

    public MonitorObjectUsage getMonitorUsage() {
        return this.monitorUsage;
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return this;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        MonitorObject readMonitorObject = MonitorObject.read((ResourceReader)reader);
        MonitorObjectUsage readMonitorUsage = MonitorObjectUsage.getMonitorUsage((int)reader.readInt8());
        return new MonitorObjectEntry(readMonitorObject, readMonitorUsage);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        this.monitorObject.write(writer);
        writer.writeInt8(this.monitorUsage.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MonitorObjectEntry) {
            return this.monitorObject == ((MonitorObjectEntry)obj).monitorObject;
        }
        return false;
    }

    public int hashCode() {
        return this.monitorObject.hashCode();
    }
}

