/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalArrayLengthPers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;

public class NormalArrayLength
implements UniqueEntry,
Quantity {
    private final Integer arrayLength;

    public NormalArrayLength(Integer arrayLength) {
        this.arrayLength = arrayLength;
    }

    public NormalArrayLength(long arrayLength) {
        this.arrayLength = (int)arrayLength;
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        return this.compareTo(other, null);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalArrayLength otherLength = (NormalArrayLength)other;
        return this.arrayLength.compareTo(otherLength.arrayLength);
    }

    public Integer getLength() {
        return this.arrayLength;
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new NormalArrayLengthPers(this.arrayLength);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NormalArrayLength) {
            NormalArrayLength other = (NormalArrayLength)obj;
            return this.arrayLength.equals(other.arrayLength);
        }
        return false;
    }

    public int hashCode() {
        return this.arrayLength.hashCode();
    }

    @Override
    public long getQuantity() {
        return this.arrayLength.intValue();
    }
}

