/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassLoaderPers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public final class NormalClassLoader
implements UniqueEntry {
    private final ClassLoaderObject classLoader;

    public NormalClassLoader(ClassLoaderObject classLoader) {
        assert (classLoader != null);
        this.classLoader = classLoader;
    }

    public ClassLoaderObject getClassLoader() {
        return this.classLoader;
    }

    public String asString() {
        return this.classLoader.getDisplayName();
    }

    public String getShortURLs() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.classLoader.getNrOfURLs(); ++i) {
            String url;
            if (i != 0) {
                result.append(", ");
            }
            try {
                url = URLDecoder.decode(this.classLoader.getURLString(i), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                url = this.classLoader.getURLString(i);
            }
            int lastPart = url.lastIndexOf(47);
            if (lastPart == url.length() - 1) {
                lastPart = url.substring(0, lastPart).lastIndexOf(47);
            }
            if (lastPart != -1) {
                result.append(url.substring(lastPart + 1));
                continue;
            }
            result.append(url);
        }
        return result.toString();
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalClassLoader otherLoader = (NormalClassLoader)other;
        int result = this.classLoader.compareToIgnoreCase(otherLoader.classLoader);
        if (result != 0) {
            return result;
        }
        return this.classLoader.compareByIndex(otherLoader.classLoader);
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        NormalClassLoader otherLoader = (NormalClassLoader)other;
        return this.classLoader.compareByIndex(otherLoader.classLoader);
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new NormalClassLoaderPers(this.classLoader);
    }
}

