/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassPers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class NormalClassLoaderPers
implements PersistableProviderEntry,
UniqueEntry {
    static final NormalClassLoaderPers readerInstance = new NormalClassLoaderPers();
    private long id;
    private boolean isBootstrapClassLoader;
    private boolean isNoStack;
    private boolean isInlinedAway;
    private UTF8String name;
    private NormalClassPers classObject;
    private int nrOfURLs;
    private String[] urls;
    private int hashCodeCache = -1;
    private String shortURLsCache;

    private NormalClassLoaderPers() {
        this.id = 0L;
        this.isBootstrapClassLoader = false;
        this.isNoStack = false;
        this.isInlinedAway = false;
        this.name = null;
        this.classObject = null;
        this.nrOfURLs = 0;
        this.urls = new String[0];
    }

    public NormalClassLoaderPers(ClassLoaderObject classLoaderObject) {
        this.id = classLoaderObject.getId();
        this.isBootstrapClassLoader = classLoaderObject.isBootstrapClassLoader();
        this.isNoStack = classLoaderObject.isNoStack();
        this.isInlinedAway = classLoaderObject.isInlinedAway();
        this.name = UTF8Creator.create((String)classLoaderObject.getName());
        ClassObject classObj = classLoaderObject.getClassObject();
        if (classObj != null) {
            this.classObject = new NormalClassPers(classObj);
        } else {
            assert (this.isBootstrapClassLoader || this.isNoStack || this.isInlinedAway);
            this.classObject = null;
        }
        this.nrOfURLs = classLoaderObject.getNrOfURLs();
        this.urls = new String[this.nrOfURLs];
        for (int i = 0; i < this.nrOfURLs; ++i) {
            this.urls[i] = classLoaderObject.getURLString(i);
        }
    }

    public long getId() {
        return this.id;
    }

    public boolean isBootstrapClassLoader() {
        return this.isBootstrapClassLoader;
    }

    public boolean isNoStack() {
        return this.isNoStack;
    }

    public boolean isInlinedAway() {
        return this.isInlinedAway;
    }

    public String getName() {
        return this.name.toString();
    }

    public NormalClassPers getClassObject() {
        return this.classObject;
    }

    public int getNrOfURLs() {
        return this.nrOfURLs;
    }

    public String getURLString(int index) {
        return this.urls[index];
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        NormalClassLoaderPers instance = new NormalClassLoaderPers();
        instance.id = reader.readInt64();
        instance.isBootstrapClassLoader = reader.readBoolean();
        instance.isNoStack = reader.readBoolean();
        instance.isInlinedAway = reader.readBoolean();
        instance.name = reader.readInternedUTF();
        if (!(this.isBootstrapClassLoader || this.isNoStack || this.isInlinedAway)) {
            instance.classObject = NormalClassPers.readerInstance.read(reader);
        }
        instance.nrOfURLs = reader.readInt32();
        instance.urls = new String[instance.nrOfURLs];
        for (int i = 0; i < instance.nrOfURLs; ++i) {
            instance.urls[i] = reader.readString();
        }
        return instance;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.id);
        writer.writeBoolean(this.isBootstrapClassLoader);
        writer.writeBoolean(this.isNoStack);
        writer.writeBoolean(this.isInlinedAway);
        writer.writeUTF(this.name);
        if (!(this.isBootstrapClassLoader || this.isNoStack || this.isInlinedAway)) {
            this.classObject.write(writer);
        }
        writer.writeInt32(this.nrOfURLs);
        for (int i = 0; i < this.nrOfURLs; ++i) {
            writer.writeString(this.urls[i]);
        }
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        if (this == other) {
            return 0;
        }
        NormalClassLoaderPers otherLoader = (NormalClassLoaderPers)other;
        return this.getDisplayName().compareToIgnoreCase(otherLoader.getDisplayName());
    }

    public String getDisplayName() {
        if (this.isBootstrapClassLoader()) {
            return "<bootstrap>";
        }
        if (this.isNoStack()) {
            return "<no stack>";
        }
        if (!this.name.isEmpty()) {
            return this.getName();
        }
        StringBuilder result = new StringBuilder(this.getClassObject().getFullName());
        result.append(this.getShortURLs());
        return result.toString();
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        return this.compareTo(other, null);
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return this;
    }

    public boolean equals(Object obj) {
        return this.compareTo((ProviderEntry)obj, null) == 0;
    }

    public int hashCode() {
        if (this.hashCodeCache == -1) {
            this.hashCodeCache = this.getDisplayName().hashCode();
        }
        return this.hashCodeCache;
    }

    public String getShortURLs() {
        if (this.shortURLsCache == null) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.nrOfURLs; ++i) {
                String url;
                if (i != 0) {
                    result.append(", ");
                }
                try {
                    url = URLDecoder.decode(this.urls[i], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    url = this.urls[i];
                }
                int lastPart = url.lastIndexOf(47);
                if (lastPart == url.length() - 1) {
                    lastPart = url.substring(0, lastPart).lastIndexOf(47);
                }
                if (lastPart != -1) {
                    result.append(url.substring(lastPart + 1));
                    continue;
                }
                result.append(url);
            }
            this.shortURLsCache = result.toString();
        }
        return this.shortURLsCache;
    }
}

