/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class NormalClassPers
implements PersistableProviderEntry,
UniqueEntry {
    static final NormalClassPers readerInstance = new NormalClassPers();
    private boolean isNoStack;
    private boolean isInlinedAway;
    private UTF8String packageName;
    private UTF8String name;

    private NormalClassPers() {
        this.isNoStack = false;
        this.isInlinedAway = false;
        this.packageName = null;
        this.name = null;
    }

    public NormalClassPers(ClassObject classObject) {
        this.isNoStack = classObject.isNoStack();
        this.isInlinedAway = classObject.isInlinedAway();
        this.packageName = UTF8Creator.create((String)classObject.getPackageName());
        this.name = UTF8Creator.create((String)classObject.getName());
    }

    public boolean isNoStack() {
        return this.isNoStack;
    }

    public boolean isInlinedAway() {
        return this.isInlinedAway;
    }

    public String getPackageName() {
        return this.packageName.toString();
    }

    public String getName() {
        return this.name.toString();
    }

    public String getFullName() {
        StringBuffer result = new StringBuffer(this.getPackageName());
        if (result.length() > 0) {
            result.append('.');
        }
        result.append(this.getName());
        return result.toString();
    }

    @Override
    public NormalClassPers read(ResourceReader reader) throws IOException {
        NormalClassPers instance = new NormalClassPers();
        instance.isNoStack = reader.readBoolean();
        instance.isInlinedAway = reader.readBoolean();
        instance.packageName = reader.readInternedUTF();
        instance.name = reader.readInternedUTF();
        return instance;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeBoolean(this.isNoStack);
        writer.writeBoolean(this.isInlinedAway);
        writer.writeUTF(this.packageName);
        writer.writeUTF(this.name);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        if (this == other) {
            return 0;
        }
        NormalClassPers otherClass = (NormalClassPers)other;
        if (this.packageName.length() == 0 || otherClass.packageName.length() == 0) {
            return this.getFullName().compareToIgnoreCase(otherClass.getFullName());
        }
        int result = this.packageName.compareToIgnoreCase(otherClass.packageName);
        if (result != 0) {
            return result;
        }
        return this.name.compareToIgnoreCase(otherClass.name);
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        return this.compareTo(other, null);
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return this;
    }

    public boolean equals(Object obj) {
        return this.compareTo((ProviderEntry)obj, null) == 0;
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        if (this.packageName.length() == 0) {
            hc = hc * hashMultiplier + this.getFullName().hashCode();
        } else {
            hc = hc * hashMultiplier + this.packageName.hashCode();
            hc = hc * hashMultiplier + this.name.hashCode();
        }
        return hc;
    }
}

