/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.ArrayClassObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class NormalClassType
implements PersistableProviderEntry {
    static final NormalClassType readerInstance = new NormalClassType((ClassType)null);
    private final ClassType type;

    public NormalClassType(ClassType type) {
        this.type = type;
    }

    public NormalClassType(ClassObject clazz) {
        this.type = ClassType.determineClassType(clazz);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalClassType otherType = (NormalClassType)other;
        return this.type.compareTo(otherType.type);
    }

    public ClassType getType() {
        return this.type;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        return new NormalClassType(ClassType.values()[reader.readInt32()]);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.getType().ordinal());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NormalClassType) {
            NormalClassType other = (NormalClassType)obj;
            return this.type == other.type;
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public static enum ClassType {
        CLASS_ARRAY,
        CLASS,
        INTERFACE_ARRAY,
        INTERFACE,
        PRIMITIVE_ARRAY,
        PRIMITIVE,
        INTERNAL_ARRAY,
        INTERNAL,
        UNDEFINED,
        ENUM,
        ENUM_ARRAY;


        public static ClassType determineClassType(ClassObject clazz) {
            if (clazz.isPrimitive()) {
                return PRIMITIVE;
            }
            if (clazz.getArrayDimension() == 0) {
                if (clazz.isInternalClass()) {
                    return INTERNAL;
                }
                NonArrayClassObject asClass = (NonArrayClassObject)clazz;
                if (asClass.isInterface()) {
                    return INTERFACE;
                }
                if (asClass.isEnum()) {
                    return ENUM;
                }
                return CLASS;
            }
            ClassObject base_clazz = ((ArrayClassObject)clazz).getBaseClass();
            if (base_clazz.isPrimitive()) {
                return PRIMITIVE_ARRAY;
            }
            if (base_clazz.isInternalClass()) {
                return INTERNAL_ARRAY;
            }
            NonArrayClassObject asClass = (NonArrayClassObject)base_clazz;
            if (asClass.isInterface()) {
                return INTERFACE_ARRAY;
            }
            if (asClass.isEnum()) {
                return ENUM_ARRAY;
            }
            return CLASS_ARRAY;
        }
    }
}

