/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.util.io.FileUtils;
import java.io.IOException;

public final class NormalFileName
implements PersistableProviderEntry,
UniqueEntry {
    static final NormalFileName readerInstance = new NormalFileName(UTF8Creator.create((String)""));
    private final UTF8String name;
    private final String pathName;
    private final String fileName;

    public NormalFileName(UTF8String name) {
        assert (name != null);
        this.name = name;
        this.pathName = FileUtils.getFullPath((String)name.toString());
        this.fileName = FileUtils.getName((String)name.toString());
    }

    public UTF8String getName() {
        return this.name;
    }

    public String getDisplayFileName() {
        if (this.name.length() == 0) {
            return I18n._s((String)"<unknown file>");
        }
        return this.name.toString();
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        String str2;
        NormalFileName otherFile = (NormalFileName)other;
        String str1 = this.getDisplayFileName();
        int result = str1.compareToIgnoreCase(str2 = otherFile.getDisplayFileName());
        if (result == 0) {
            result = str1.compareTo(str2);
        }
        return result;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        return new NormalFileName(reader.readInternedUTF());
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeUTF(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NormalFileName)) {
            return false;
        }
        return this.compareToUnique((NormalFileName)obj) == 0;
    }

    public int hashCode() {
        return this.getDisplayFileName().hashCode();
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        NormalFileName otherFile = (NormalFileName)other;
        return this.name.compareTo((Object)otherFile.name);
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return this;
    }
}

