/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class NormalFilterEntityPers
implements PersistableProviderEntry {
    static final NormalFilterEntityPers readerInstance = new NormalFilterEntityPers((UTF8String)null);
    private UTF8String filterName = null;

    public NormalFilterEntityPers(String filterName) {
        if (filterName != null) {
            this.filterName = UTF8Creator.create((String)filterName);
        }
    }

    public NormalFilterEntityPers(UTF8String filterName) {
        this.filterName = filterName;
    }

    public String getFilterName() {
        if (this.filterName == null) {
            return null;
        }
        return this.filterName.toString();
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        boolean hasFilterName = reader.readBoolean();
        return new NormalFilterEntityPers(hasFilterName ? reader.readInternedUTF() : null);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeBoolean(this.filterName != null);
        if (this.filterName != null) {
            writer.writeUTF(this.filterName);
        }
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalFilterEntityPers otherEntity = (NormalFilterEntityPers)other;
        if (this.filterName == null) {
            if (otherEntity.filterName == null) {
                return 0;
            }
            return 1;
        }
        if (otherEntity.filterName == null) {
            return -1;
        }
        return this.filterName.compareToIgnoreCase(otherEntity.filterName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.compareTo((NormalFilterEntityPers)obj, null) == 0;
    }

    public int hashCode() {
        if (this.filterName == null) {
            return 17;
        }
        return this.filterName.hashCode();
    }
}

