/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalFilterEntryPers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.snapshot.filter.ProfilingFilterStoreEntry;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntity;

public final class NormalFilterEntry
implements UniqueEntry {
    private final ProfilingFilterStoreEntry entry;
    private final CombinedEntity entity;

    public NormalFilterEntry(ProfilingFilterStoreEntry entry) {
        this.entry = entry;
        this.entity = null;
    }

    public NormalFilterEntry(ProfilingFilterStoreEntry entry, CombinedEntity entity) {
        this.entry = entry;
        this.entity = entity;
    }

    public ProfilingFilterStoreEntry getEntry() {
        return this.entry;
    }

    public CombinedEntity getEntity() {
        return this.entity;
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        int otherDepth;
        NormalFilterEntry otherFilter = (NormalFilterEntry)other;
        int thisDepth = this.entry.getDepth();
        if (thisDepth < (otherDepth = otherFilter.entry.getDepth())) {
            return -1;
        }
        if (thisDepth > otherDepth) {
            return 1;
        }
        ProfilingFilterStoreEntry thisEntry = this.entry;
        ProfilingFilterStoreEntry otherEntry = otherFilter.entry;
        while (thisEntry != null) {
            int result = thisEntry.getName().compareTo(otherEntry.getName());
            if (result != 0) {
                return result;
            }
            thisEntry = thisEntry.getParent();
            otherEntry = otherEntry.getParent();
        }
        return 0;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalFilterEntry otherEntry = (NormalFilterEntry)other;
        return this.entry.getName().compareToIgnoreCase(otherEntry.entry.getName());
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new NormalFilterEntryPers(this.getEntry());
    }
}

