/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.ProfilingFilterStoreEntry;
import java.io.IOException;

public class NormalFilterEntryPers
implements PersistableProviderEntry {
    static final NormalFilterEntryPers readerInstance = new NormalFilterEntryPers();
    private UTF8String entryName = null;
    private boolean isDirectory = false;
    private boolean isClassFilter = false;

    private NormalFilterEntryPers() {
    }

    public NormalFilterEntryPers(ProfilingFilterStoreEntry entry) {
        this();
        if (entry != null) {
            this.entryName = UTF8Creator.create((String)entry.getName());
            this.isDirectory = entry.isDirectory();
            this.isClassFilter = entry.isClassFilter();
        }
    }

    public String getEntryName() {
        return this.entryName.toString();
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isClassFilter() {
        return this.isClassFilter;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        NormalFilterEntryPers result = new NormalFilterEntryPers();
        boolean hasEntryName = reader.readBoolean();
        if (hasEntryName) {
            result.entryName = reader.readInternedUTF();
        }
        result.isDirectory = reader.readBoolean();
        result.isClassFilter = reader.readBoolean();
        return result;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeBoolean(this.entryName != null);
        if (this.entryName != null) {
            writer.writeUTF(this.entryName);
        }
        writer.writeBoolean(this.isDirectory);
        writer.writeBoolean(this.isClassFilter);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalFilterEntryPers otherEntity = (NormalFilterEntryPers)other;
        if (this.entryName == null) {
            if (otherEntity.entryName == null) {
                return 0;
            }
            return 1;
        }
        if (otherEntity.entryName == null) {
            return -1;
        }
        return this.entryName.compareToIgnoreCase(otherEntity.entryName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.getEntryName().equals(((NormalFilterEntryPers)obj).getEntryName()) && this.isClassFilter() == ((NormalFilterEntryPers)obj).isClassFilter() && this.isDirectory() == ((NormalFilterEntryPers)obj).isDirectory();
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.entryName.hashCode();
        hc = hc * hashMultiplier + (this.isClassFilter ? 1 : 0);
        hc = hc * hashMultiplier + (this.isDirectory ? 2 : 0);
        return hc;
    }
}

