/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodPers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;

public class NormalMethodAndReceiver
implements UniqueEntry {
    private final MethodObject method;
    private final ClassObject receiver;

    public NormalMethodAndReceiver(MethodObject method, ClassObject receiver) {
        this.method = method;
        this.receiver = receiver;
    }

    public MethodObject getMethod() {
        return this.method;
    }

    public ClassObject getReceiver() {
        return this.receiver;
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        NormalMethodAndReceiver otherMethod = (NormalMethodAndReceiver)other;
        int result = this.receiver.compareByIndex(otherMethod.receiver);
        if (result != 0) {
            return result;
        }
        return this.method.compareByIndex(otherMethod.method);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalMethodAndReceiver otherMethod = (NormalMethodAndReceiver)other;
        int result = this.receiver.compareToIgnoreCase(otherMethod.receiver);
        if (result != 0) {
            return result;
        }
        result = this.receiver.compareByIndex(otherMethod.receiver);
        if (result != 0) {
            return result;
        }
        result = this.method.getSignatureUTF().compareToIgnoreCase(otherMethod.method.getSignatureUTF());
        if (result != 0) {
            return result;
        }
        result = this.method.getSignatureUTF().compareTo((Object)otherMethod.method.getSignatureUTF());
        if (result != 0) {
            return result;
        }
        result = this.method.getReturnTypeUTF().compareToIgnoreCase(otherMethod.method.getReturnTypeUTF());
        if (result != 0) {
            return result;
        }
        return this.method.getReturnTypeUTF().compareTo((Object)otherMethod.method.getReturnTypeUTF());
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new NormalMethodPers(this.method, this.receiver);
    }
}

