/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ModifiableKeyEntry;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class NormalMethodPers
implements ModifiableKeyEntry,
UniqueEntry {
    static final NormalMethodPers readerInstance = new NormalMethodPers();
    private static final int PUBLIC_INDEX = 1;
    private static final int PROTECTED_INDEX = 2;
    private static final int PRIVATE_INDEX = 4;
    private static final int PACKAGE_PRIVATE_INDEX = 8;
    private static final int UNKNOWN_TYPE_INDEX = 16;
    private static final int STATIC_INDEX = 32;
    private static final int FINAL_INDEX = 64;
    private static final int NATIVE_INDEX = 128;
    private boolean isNoStack;
    private boolean isInlinedAway;
    private UTF8String packageName;
    private UTF8String className;
    private UTF8String name;
    private UTF8String signature;
    private UTF8String returnType;
    private int typeIndex;
    String label = null;

    NormalMethodPers() {
        this.isNoStack = true;
        this.isInlinedAway = false;
        this.packageName = null;
        this.className = null;
        this.name = null;
        this.signature = null;
        this.returnType = null;
        this.typeIndex = 16;
    }

    NormalMethodPers(MethodObject methodObject) {
        this(methodObject, (ClassObject)methodObject.getMethodClass());
    }

    NormalMethodPers(MethodObject methodObject, ClassObject receiverClass) {
        this.isNoStack = methodObject.isNoStack();
        this.isInlinedAway = methodObject.isInlinedAway();
        this.packageName = receiverClass.getPackageNameUTF();
        this.className = receiverClass.getNameUTF();
        this.name = methodObject.getNameUTF();
        this.signature = methodObject.getSignatureUTF();
        this.returnType = methodObject.getReturnTypeUTF();
        if (methodObject.isPublic()) {
            this.typeIndex = 1;
        } else if (methodObject.isProtected()) {
            this.typeIndex = 2;
        } else if (methodObject.isPrivate()) {
            this.typeIndex = 4;
        } else {
            ProfilingSession session = methodObject.getSession();
            ProfilingCapabilities capabilities = session.getCapabilities();
            if (session.getSystemInfo() == null && capabilities.hasAdditionalMethodAttributes()) {
                assert (methodObject.isPackagePrivate());
                this.typeIndex = 8;
            } else {
                this.typeIndex = 16;
            }
        }
        if (methodObject.isStatic()) {
            this.typeIndex |= 0x20;
        }
        if (methodObject.isFinal() || methodObject.getMethodClass().isFinal()) {
            this.typeIndex |= 0x40;
        }
        if (methodObject.isNative()) {
            this.typeIndex |= 0x80;
        }
    }

    public boolean isPublic() {
        return (this.typeIndex & 1) != 0;
    }

    public boolean isProtected() {
        return (this.typeIndex & 2) != 0;
    }

    public boolean isPrivate() {
        return (this.typeIndex & 4) != 0;
    }

    public boolean isPackagePrivate() {
        return (this.typeIndex & 8) != 0;
    }

    public boolean isUnknownType() {
        return (this.typeIndex & 0x10) != 0;
    }

    public boolean isStatic() {
        return (this.typeIndex & 0x20) != 0;
    }

    public boolean isFinal() {
        return (this.typeIndex & 0x40) != 0;
    }

    public boolean isNative() {
        return (this.typeIndex & 0x80) != 0;
    }

    public boolean isNoStack() {
        return this.isNoStack;
    }

    public boolean isInlinedAway() {
        return this.isInlinedAway;
    }

    public String getPackageName() {
        return this.packageName.toString();
    }

    public String getClassName() {
        return this.className.toString();
    }

    public String getName() {
        return this.name.toString();
    }

    public String getFullName() {
        StringBuffer result = new StringBuffer();
        result.append(this.getPackageName());
        if (result.length() > 0) {
            result.append('.');
        }
        result.append(this.getClassName());
        result.append('.');
        result.append(this.getName());
        result.append('(');
        result.append(this.getSignature());
        result.append(')');
        result.append(this.getReturnType());
        if (this.label != null) {
            result.append(" ").append(this.label);
        }
        return result.toString();
    }

    public String getSignature() {
        return this.signature.toString();
    }

    public String getReturnType() {
        return this.returnType.toString();
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        NormalMethodPers instance = new NormalMethodPers();
        instance.isNoStack = reader.readBoolean();
        instance.isInlinedAway = reader.readBoolean();
        instance.packageName = reader.readInternedUTF();
        instance.className = reader.readInternedUTF();
        instance.name = reader.readInternedUTF();
        instance.signature = reader.readInternedUTF();
        instance.returnType = reader.readInternedUTF();
        instance.typeIndex = reader.readInt32();
        boolean hasLabel = reader.readBoolean();
        if (hasLabel) {
            instance.label = reader.readString();
        }
        return instance;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeBoolean(this.isNoStack);
        writer.writeBoolean(this.isInlinedAway);
        writer.writeUTF(this.packageName);
        writer.writeUTF(this.className);
        writer.writeUTF(this.name);
        writer.writeUTF(this.signature);
        writer.writeUTF(this.returnType);
        writer.writeInt32(this.typeIndex);
        writer.writeBoolean(this.label != null);
        if (this.label != null) {
            writer.writeString(this.label);
        }
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        if (this == other) {
            return 0;
        }
        NormalMethodPers otherMethod = (NormalMethodPers)other;
        return this.getFullName().compareToIgnoreCase(otherMethod.getFullName());
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        return this.compareTo(other, null);
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NormalMethodPers) {
            NormalMethodPers other = (NormalMethodPers)obj;
            boolean labelsMatch = this.label == other.label || this.label != null && this.label.equals(other.label);
            return this.packageName.equals(other.packageName) && this.className.equals(other.className) && this.name.equals(other.name) && this.signature.equals(other.signature) && this.returnType.equals(other.returnType) && labelsMatch;
        }
        return false;
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.packageName.hashCode();
        hc = hc * hashMultiplier + this.className.hashCode();
        hc = hc * hashMultiplier + this.name.hashCode();
        hc = hc * hashMultiplier + this.signature.hashCode();
        hc = hc * hashMultiplier + this.returnType.hashCode();
        if (this.label != null) {
            hc = hc * hashMultiplier + this.label.hashCode();
        }
        return hc;
    }

    @Override
    public NormalMethodPers getModifiedEntry(String newLabel) {
        NormalMethodPers modified = new NormalMethodPers();
        modified.isNoStack = this.isNoStack;
        modified.isInlinedAway = this.isInlinedAway;
        modified.packageName = this.packageName;
        modified.className = this.className;
        modified.name = this.name;
        modified.signature = this.signature;
        modified.returnType = this.returnType;
        modified.typeIndex = this.typeIndex;
        modified.label = newLabel;
        return modified;
    }

    @Override
    public String getModificationLabel() {
        return this.label;
    }
}

