/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.net.event.IpAddressUtil;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalNetworkAddressPers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;

public class NormalNetworkAddress
implements UniqueEntry {
    private final IpAddress address;
    private final boolean isLocal;

    public NormalNetworkAddress(IpAddress address, boolean isLocal) {
        this.address = address;
        this.isLocal = isLocal;
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        return this.compareTo(other, null);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalNetworkAddress otherAddress = (NormalNetworkAddress)other;
        return IpAddressUtil.compare((IpAddress)this.address, (IpAddress)otherAddress.address);
    }

    public IpAddress getAddress() {
        return this.address;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new NormalNetworkAddressPers(this.address, this.isLocal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.address.equals(((NormalNetworkAddress)obj).getAddress()) && this.isLocal == ((NormalNetworkAddress)obj).isLocal();
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.address.hashCode();
        hc = hc * hashMultiplier + (this.isLocal ? 1 : 0);
        return hc;
    }
}

