/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackagePers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;

public class NormalPackage
implements UniqueEntry {
    protected final PackageName name;

    public NormalPackage(PackageName name) {
        this.name = name;
    }

    public PackageName getPackage() {
        return this.name;
    }

    public static String getDisplayName(PackageName packageName) {
        String result = NormalPackage.getSpecialDisplayName(packageName);
        if (result != null) {
            return result;
        }
        return packageName.getName().toString();
    }

    public static String getSpecialDisplayName(PackageName packageName) {
        if (packageName.isDefaultPackage()) {
            return I18n._s((String)"<default package>");
        }
        if (packageName.isRootPackage()) {
            return I18n._ss((String)"Display name for the synthetic root package", (String)"<root>");
        }
        if (packageName.isInlinedAway()) {
            return I18n._s((String)"<inlined away>");
        }
        if (packageName.isNoStack()) {
            return I18n._s((String)"<no stack>");
        }
        return null;
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        PackageName otherName = ((NormalPackage)other).name;
        return this.name.compareTo(otherName);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalPackage otherPackage = (NormalPackage)other;
        return NormalPackage.getDisplayName(this.name).compareToIgnoreCase(NormalPackage.getDisplayName(otherPackage.name));
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new NormalPackagePers(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.name.equals(((NormalPackage)obj).name);
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.name.hashCode();
        return hc;
    }
}

