/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackage;
import com.sap.jvm.profiling.presentation.typed.entries.NormalPackagePartPers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;

public class NormalPackagePart
implements UniqueEntry {
    protected final PackageName name;
    private final boolean isLeafPackage;

    public NormalPackagePart(PackageName name, boolean isLeafPackage) {
        this.name = name;
        this.isLeafPackage = isLeafPackage;
    }

    public PackageName getPackage() {
        return this.name;
    }

    public UTF8String getFullPackageName() {
        return this.name.getName();
    }

    public boolean isLeafPackage() {
        return this.isLeafPackage;
    }

    public String getPartPackageName() {
        String result = this.name.getName().toString();
        if (this.isLeafPackage && this.name.includesSubPackages()) {
            return result.substring(result.lastIndexOf(46) + 1);
        }
        if (this.name.includesSubPackages()) {
            return result.substring(result.lastIndexOf(46) + 1) + ".*";
        }
        return I18n._s((String)"<this pkg only>");
    }

    public String getDisplayName() {
        String result = NormalPackage.getSpecialDisplayName(this.name);
        if (result != null) {
            return result;
        }
        return this.getPartPackageName();
    }

    public String getLongDisplayName() {
        String result = NormalPackage.getSpecialDisplayName(this.name);
        if (result != null) {
            return result;
        }
        if (!this.isLeafPackage && this.name.includesSubPackages()) {
            return this.getFullPackageName() + ".*";
        }
        return this.getFullPackageName().toString();
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        PackageName otherName = ((NormalPackagePart)other).name;
        return this.name.compareTo(otherName);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalPackagePart otherPackage = (NormalPackagePart)other;
        return this.getDisplayName().compareToIgnoreCase(otherPackage.getDisplayName());
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new NormalPackagePartPers(this.name, this.isLeafPackage);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.name.equals(((NormalPackagePart)obj).name) && this.isLeafPackage == ((NormalPackagePart)obj).isLeafPackage;
    }

    public int hashCode() {
        int hc = 17;
        int hashMultiplier = 59;
        hc = hc * hashMultiplier + this.name.hashCode();
        hc = hc * hashMultiplier + (this.isLeafPackage ? 1 : 0);
        return hc;
    }
}

