/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.method.parameters.ClassParameter;
import com.sap.jvm.profiling.method.parameters.FloatTypeParameter;
import com.sap.jvm.profiling.method.parameters.IntegerTypeParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.StringParameter;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValuePers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.util.misc.UTF8Util;

public class NormalParameterValue
implements UniqueEntry {
    private final Parameter value;

    public NormalParameterValue(Parameter value) {
        this.value = value;
    }

    public Parameter getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        if (this.value.isErrorType()) {
            switch (this.value.getType()) {
                case CLASS_CAST_EXCEPTION: {
                    return I18n._s((String)"<class cast exception>");
                }
                case ENABLE_FAILED: {
                    return I18n._s((String)"<enabling failed>");
                }
                case EXCEPTION_DURING_CALL: {
                    return I18n._s((String)"<exception in call>");
                }
                case INDEX_OUT_OF_BOUNDS: {
                    return I18n._s((String)"<index out of bounds>");
                }
                case NULL: {
                    return I18n._s((String)"null");
                }
                case NULL_INVOCATION_DURING_CALL: {
                    return I18n._s((String)"<null in modifier>");
                }
                case UNKNOWN: {
                    return I18n._s((String)"<unknown>");
                }
            }
        }
        return this.value.toString();
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        int tag2;
        NormalParameterValue otherValue = (NormalParameterValue)other;
        int tag1 = this.value.getType().getTag();
        if (tag1 < (tag2 = otherValue.value.getType().getTag())) {
            return -1;
        }
        if (tag1 > tag2) {
            return 1;
        }
        return this.compareTo(otherValue, null);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        String str2;
        String str1;
        int result;
        Parameter otherValue = ((NormalParameterValue)other).value;
        if (this.value instanceof StringParameter) {
            if (otherValue instanceof StringParameter) {
                byte[] bytes1 = ((StringParameter)this.value).getUTF();
                byte[] bytes2 = ((StringParameter)otherValue).getUTF();
                return UTF8Util.compareForCaseInsenstiveOrder((byte[])bytes1, (byte[])bytes2);
            }
        } else if (this.value instanceof IntegerTypeParameter) {
            if (otherValue instanceof IntegerTypeParameter) {
                long value2;
                long value1 = ((IntegerTypeParameter)this.value).asLong();
                if (value1 < (value2 = ((IntegerTypeParameter)otherValue).asLong())) {
                    return -1;
                }
                if (value1 > value2) {
                    return 1;
                }
                return 0;
            }
            if (otherValue instanceof FloatTypeParameter) {
                double value2;
                long value1 = ((IntegerTypeParameter)this.value).asLong();
                if ((double)value1 < (value2 = ((FloatTypeParameter)otherValue).asDouble())) {
                    return -1;
                }
                if ((double)value1 > value2) {
                    return 1;
                }
                return 0;
            }
        } else if (this.value instanceof FloatTypeParameter) {
            if (otherValue instanceof IntegerTypeParameter) {
                long value2;
                double value1 = ((FloatTypeParameter)this.value).asDouble();
                if (value1 < (double)(value2 = ((IntegerTypeParameter)otherValue).asLong())) {
                    return -1;
                }
                if (value1 > (double)value2) {
                    return 1;
                }
                return 0;
            }
            if (otherValue instanceof FloatTypeParameter) {
                double value2;
                double value1 = ((FloatTypeParameter)this.value).asDouble();
                if (value1 < (value2 = ((FloatTypeParameter)otherValue).asDouble())) {
                    return -1;
                }
                if (value1 > value2) {
                    return 1;
                }
                return 0;
            }
        } else if (this.value instanceof ClassParameter) {
            if (otherValue instanceof ClassParameter) {
                ClassObject clazz2;
                ClassObject clazz1 = ((ClassParameter)this.value).getValue();
                int result2 = clazz1.compareToIgnoreCase(clazz2 = ((ClassParameter)otherValue).getValue());
                if (result2 == 0) {
                    return clazz1.compareTo(clazz2);
                }
                return result2;
            }
        } else if (this.value instanceof MethodParameter && otherValue instanceof MethodParameter) {
            ClassObject clazz2;
            ClassObject clazz1 = ((MethodParameter)this.value).getReceiverClass();
            int result3 = clazz1.compareToIgnoreCase(clazz2 = ((MethodParameter)otherValue).getReceiverClass());
            if (result3 == 0) {
                result3 = clazz1.compareTo(clazz2);
            }
            if (result3 != 0) {
                return result3;
            }
            MethodObject method1 = ((MethodParameter)this.value).getMethod();
            MethodObject method2 = ((MethodParameter)otherValue).getMethod();
            result3 = method1.getSignatureUTF().compareForCaseInsenstiveOrder(method2.getSignatureUTF());
            if (result3 == 0) {
                result3 = method1.getReturnTypeUTF().compareForCaseInsenstiveOrder(method2.getReturnTypeUTF());
            }
            return result3;
        }
        if ((result = (str1 = this.value.toString()).compareToIgnoreCase(str2 = otherValue.toString())) == 0) {
            return str1.compareTo(str2);
        }
        return result;
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new NormalParameterValuePers(this.value);
    }
}

