/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.method.parameters.ClassParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalClassPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalMethodPers;
import com.sap.jvm.profiling.presentation.typed.entries.NormalParameterValue;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class NormalParameterValuePers
implements PersistableProviderEntry {
    static final NormalParameterValuePers readerInstance = new NormalParameterValuePers((Parameter)null);
    private final Object value;

    public NormalParameterValuePers(Parameter value) {
        if (value instanceof ClassParameter) {
            ClassObject classObject = ((ClassParameter)value).getValue();
            this.value = new NormalClassPers(classObject);
        } else if (value instanceof MethodParameter) {
            MethodObject method = ((MethodParameter)value).getMethod();
            ClassObject receiverClass = ((MethodParameter)value).getReceiverClass();
            this.value = new NormalMethodPers(method, receiverClass);
        } else {
            this.value = value;
        }
    }

    public NormalParameterValuePers(PersistableProviderEntry pers) {
        this.value = pers;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        byte tag = reader.readInt8();
        if (tag != -1) {
            return new NormalParameterValuePers(Parameter.read((ResourceReader)reader));
        }
        tag = reader.readInt8();
        if (tag == ParameterType.CLASS.getTag()) {
            return new NormalParameterValuePers(NormalClassPers.readerInstance.read(reader));
        }
        assert (tag == ParameterType.METHOD.getTag());
        return new NormalParameterValuePers(NormalMethodPers.readerInstance.read(reader));
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        if (this.value instanceof NormalClassPers) {
            writer.writeInt8(-1);
            writer.writeInt8(ParameterType.CLASS.getTag());
            ((NormalClassPers)this.value).write(writer);
        } else if (this.value instanceof NormalMethodPers) {
            writer.writeInt8(-1);
            writer.writeInt8(ParameterType.METHOD.getTag());
            ((NormalMethodPers)this.value).write(writer);
        } else {
            ((Parameter)this.value).write(writer);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NormalParameterValuePers) {
            NormalParameterValuePers other = (NormalParameterValuePers)obj;
            return this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        String str2;
        String str1;
        int result;
        Object otherValue = ((NormalParameterValuePers)other).value;
        if (this.value instanceof Parameter) {
            if (otherValue instanceof Parameter) {
                return new NormalParameterValue((Parameter)this.value).compareTo(new NormalParameterValue((Parameter)otherValue), context);
            }
        } else if (this.value instanceof NormalClassPers) {
            if (otherValue instanceof NormalClassPers) {
                return ((NormalClassPers)this.value).compareTo((NormalClassPers)otherValue, context);
            }
        } else if (this.value instanceof NormalMethodPers && otherValue instanceof NormalMethodPers) {
            return ((NormalMethodPers)this.value).compareTo((NormalMethodPers)otherValue, context);
        }
        if ((result = (str1 = this.value.toString()).compareToIgnoreCase(str2 = otherValue.toString())) == 0) {
            return str1.compareTo(str2);
        }
        return result;
    }

    public Object getValue() {
        return this.value;
    }
}

