/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.NormalThreadAnnotationPers;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ThreadAnnotationContext;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;

public class NormalThreadAnnotation
implements UniqueEntry {
    private final String value;
    private ThreadAnnotationContext context;

    public NormalThreadAnnotation(String value, ThreadAnnotationContext context) {
        this.value = value;
        this.context = context;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public String getDisplayAnnotationValue() {
        if (this.getValue().length() == 0) {
            return this.context.getDefaultNoValueText();
        }
        return this.value;
    }

    public ThreadAnnotationContext getContext() {
        return this.context;
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        NormalThreadAnnotation otherAnnotation = (NormalThreadAnnotation)other;
        return this.getValue().compareTo(otherAnnotation.getValue());
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext dummyContext) {
        NormalThreadAnnotation otherAnnotation = (NormalThreadAnnotation)other;
        return this.getDisplayAnnotationValue().compareToIgnoreCase(otherAnnotation.getDisplayAnnotationValue());
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return new NormalThreadAnnotationPers(this.value, this.context);
    }
}

