/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class NormalThreadDumpLink
implements PersistableProviderEntry {
    private String text;
    private int dumpIndex;

    public NormalThreadDumpLink(String text, int dumpIndex) {
        this.text = text;
        this.dumpIndex = dumpIndex;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalThreadDumpLink otherLink = (NormalThreadDumpLink)other;
        return otherLink.dumpIndex > this.dumpIndex ? -1 : (otherLink.dumpIndex == this.dumpIndex ? 0 : 1);
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        return new NormalThreadDumpLink(reader.readString(), reader.readInt32());
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeString(this.getText());
        writer.writeInt32(this.getDumpIndex());
    }

    public String getText() {
        return this.text;
    }

    public int getDumpIndex() {
        return this.dumpIndex;
    }
}

