/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ModifiableKeyEntry;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class NormalThreadName
implements ModifiableKeyEntry {
    static final NormalThreadName readerInstance = new NormalThreadName(UTF8Creator.create((String)""));
    private final UTF8String name;
    private final String missingMessage;
    private boolean bold;
    String label = null;

    public NormalThreadName(UTF8String name) {
        this(name, false);
    }

    public NormalThreadName(UTF8String name, boolean bold) {
        this(name, I18n._s((String)"<unknown thread>"));
        this.bold = bold;
    }

    public NormalThreadName(UTF8String name, String missingMessage) {
        this.name = name;
        this.missingMessage = missingMessage;
    }

    public UTF8String getName() {
        return this.name;
    }

    public boolean isBold() {
        return this.bold;
    }

    public String getDisplayThreadName() {
        if (this.name == null || this.name.length() == 0) {
            return this.missingMessage;
        }
        return this.name.toString();
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        NormalThreadName otherThread = (NormalThreadName)other;
        int result = this.getDisplayThreadName().compareToIgnoreCase(otherThread.getDisplayThreadName());
        if (result == 0) {
            if (this.label == otherThread.label) {
                return 0;
            }
            if (this.label != null) {
                if (otherThread.label == null) {
                    return 1;
                }
                return this.label.compareTo(otherThread.label);
            }
        }
        return result;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        NormalThreadName result;
        boolean haveName = reader.readBoolean();
        if (haveName) {
            UTF8String readName = reader.readInternedUTF();
            result = new NormalThreadName(readName);
        } else {
            String readMissingMsg = reader.readString();
            result = new NormalThreadName(null, readMissingMsg);
        }
        boolean hasLabel = reader.readBoolean();
        if (hasLabel) {
            result.label = reader.readString();
        }
        return result;
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        boolean haveName = this.name != null && this.name.length() > 0;
        writer.writeBoolean(haveName);
        if (haveName) {
            writer.writeUTF(this.name);
        } else {
            writer.writeString(this.missingMessage);
        }
        writer.writeBoolean(this.label != null);
        if (this.label != null) {
            writer.writeString(this.label);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NormalThreadName)) {
            return false;
        }
        return this.compareTo((NormalThreadName)obj, null) == 0;
    }

    public int hashCode() {
        int hc = this.getDisplayThreadName().hashCode();
        if (this.label != null) {
            hc = hc * 53 + this.label.hashCode();
        }
        return hc;
    }

    @Override
    public NormalThreadName getModifiedEntry(String newLabel) {
        NormalThreadName modified = new NormalThreadName(this.name, this.missingMessage);
        modified.label = newLabel;
        return modified;
    }

    @Override
    public String getModificationLabel() {
        return this.label;
    }
}

