/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;

public class Progress
implements Quantity {
    private long value;
    private long maxValue;

    public Progress(long value, long maxValue) {
        assert (value <= maxValue);
        this.value = value;
        this.maxValue = maxValue;
    }

    public long getValue() {
        return this.value;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public double getProgress() {
        return (double)this.value / (double)this.maxValue;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        double otherProgress;
        Progress otherUsage = (Progress)other;
        long diffQuantity = this.getQuantity() - otherUsage.getQuantity();
        if (diffQuantity != 0L) {
            return diffQuantity < 0L ? -1 : 1;
        }
        double progress = this.getProgress();
        return progress < (otherProgress = otherUsage.getProgress()) ? -1 : (progress > otherProgress ? 1 : 0);
    }

    @Override
    public long getQuantity() {
        return this.value;
    }
}

