/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;

public final class StackFrameEntry
implements ProviderEntry {
    private final MethodLocation methodLocation;
    private final boolean sortable;

    public StackFrameEntry(MethodLocation methodLocation, boolean sortable) {
        this.methodLocation = methodLocation;
        this.sortable = sortable;
    }

    public MethodLocation getMethodLocation() {
        return this.methodLocation;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        MethodObject otherMethod;
        if (!this.sortable) {
            return 0;
        }
        StackFrameEntry otherFrame = (StackFrameEntry)other;
        MethodObject method = this.methodLocation.getMethod();
        int result = method.compareToIgnoreCase(otherMethod = otherFrame.methodLocation.getMethod());
        if (result != 0) {
            return result;
        }
        return method.compareByIndex(otherMethod);
    }
}

