/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.i18n.I18n;

public final class ThreadAnnotationContext {
    private final int slot;
    private final String key;
    private final String description;
    private String defaultNoValueText;
    private String columnDescription;
    private String tooltip;
    private String tooltipForCombinedItemsSingular;
    private String tooltipForCombinedItemsPlural;
    private String otherChildrenSingular;
    private String otherChildrenPlural;
    private String skippedChildrenSingular;
    private String skippedChildrenPlural;
    private String combinedItemsSingular;
    private String combinedItemsPlural;
    private String activeEntityText;
    private String performedByText;
    private String affectingAnotherText;

    public ThreadAnnotationContext(int slot, String key, String description) {
        this.slot = slot;
        this.key = key;
        this.description = description;
        this.createTexts();
    }

    public ThreadAnnotationContext(String key, String description) {
        this.key = key;
        this.description = description;
        this.slot = "user".equals(key) ? 0 : ("application".equals(key) ? 3 : ("session".equals(key) ? 1 : ("request".equals(key) ? 2 : ("tenant".equals(key) ? 5 : -1))));
        this.createTexts();
    }

    public int getSlot() {
        return this.slot;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    private void createTexts() {
        switch (this.slot) {
            case 0: {
                this.columnDescription = I18n._ss((String)"ThreadAnnotation|User|CoulumnDescr", (String)"User");
                this.defaultNoValueText = I18n._ss((String)"ThreadAnnotation|User|noValue", (String)"<no user>");
                this.tooltip = I18n._ss((String)"ThreadAnnotation|User|Tooltip", (String)"The user name");
                this.tooltipForCombinedItemsSingular = I18n._ss((String)"ThreadAnnotation|User|TooltipCombined|Singular", (String)"{0} user");
                this.tooltipForCombinedItemsPlural = I18n._ss((String)"ThreadAnnotation|User|TooltipCombined|Plural", (String)"{0} users");
                this.skippedChildrenSingular = I18n._ss((String)"ThreadAnnotation|User|SkippedChildren|Singular", (String)"{0} skipped user");
                this.skippedChildrenPlural = I18n._ss((String)"ThreadAnnotation|User|SkippedChildren|Plural", (String)"{0} skipped users");
                this.otherChildrenSingular = I18n._ss((String)"ThreadAnnotation|User|OtherChildren|Singular", (String)"{0} other user");
                this.otherChildrenPlural = I18n._ss((String)"ThreadAnnotation|User|OtherChildren|Plural", (String)"{0} other users");
                this.combinedItemsSingular = I18n._ss((String)"ThreadAnnotation|User|Combined|Singular", (String)"{0} user");
                this.combinedItemsPlural = I18n._ss((String)"ThreadAnnotation|User|Combined|Plural", (String)"{0} users");
                this.activeEntityText = I18n._ss((String)"Entity, ex: total time {0} was running", (String)"this user");
                this.performedByText = I18n._ss((String)"ThreadAnnotation|PerformedBy, ex: performed by {0}", (String)"this user");
                this.affectingAnotherText = I18n._ss((String)"ThreadAnnotation|AffectingAnother, ex: affecting {0}", (String)"another user");
                break;
            }
            case 1: {
                this.columnDescription = I18n._ss((String)"ThreadAnnotation|Session|CoulumnDescr", (String)"Session");
                this.defaultNoValueText = I18n._ss((String)"ThreadAnnotation|Session|noValue", (String)"<no session>");
                this.tooltip = I18n._ss((String)"ThreadAnnotation|Session|Tooltip", (String)"The session identifier");
                this.tooltipForCombinedItemsSingular = I18n._ss((String)"ThreadAnnotation|Session|TooltipCombined|Singular", (String)"{0} session");
                this.tooltipForCombinedItemsPlural = I18n._ss((String)"ThreadAnnotation|Session|TooltipCombined|Plural", (String)"{0} sessions");
                this.skippedChildrenSingular = I18n._ss((String)"ThreadAnnotation|Session|SkippedChildren|Singular", (String)"{0} skipped session");
                this.skippedChildrenPlural = I18n._ss((String)"ThreadAnnotation|Session|SkippedChildren|Plural", (String)"{0} skipped sessions");
                this.otherChildrenSingular = I18n._ss((String)"ThreadAnnotation|Session|OtherChildren|Singular", (String)"{0} other session");
                this.otherChildrenPlural = I18n._ss((String)"ThreadAnnotation|Session|OtherChildren|Plural", (String)"{0} other sessions");
                this.combinedItemsSingular = I18n._ss((String)"ThreadAnnotation|Session|Combined|Singular", (String)"{0} session");
                this.combinedItemsPlural = I18n._ss((String)"ThreadAnnotation|Session|Combined|Plural", (String)"{0} sessions");
                this.activeEntityText = I18n._ss((String)"Entity, ex: total time {0} was running", (String)"this session");
                this.performedByText = I18n._ss((String)"ThreadAnnotation|PerformedBy, ex: performed by {0}", (String)"this session");
                this.affectingAnotherText = I18n._ss((String)"ThreadAnnotation|AffectingAnother, ex: affecting {0}", (String)"another session");
                break;
            }
            case 2: {
                this.columnDescription = I18n._ss((String)"ThreadAnnotation|Request|CoulumnDescr", (String)"Request");
                this.defaultNoValueText = I18n._ss((String)"ThreadAnnotation|Request|noValue", (String)"<no request>");
                this.tooltip = I18n._ss((String)"ThreadAnnotation|Request|Tooltip", (String)"The request identifier");
                this.tooltipForCombinedItemsSingular = I18n._ss((String)"ThreadAnnotation|Request|TooltipCombined|Singular", (String)"{0} request");
                this.tooltipForCombinedItemsPlural = I18n._ss((String)"ThreadAnnotation|Request|TooltipCombined|Plural", (String)"{0} requests");
                this.skippedChildrenSingular = I18n._ss((String)"ThreadAnnotation|Request|SkippedChildren|Singular", (String)"{0} skipped request");
                this.skippedChildrenPlural = I18n._ss((String)"ThreadAnnotation|Request|SkippedChildren|Plural", (String)"{0} skipped requests");
                this.otherChildrenSingular = I18n._ss((String)"ThreadAnnotation|Request|OtherChildren|Singular", (String)"{0} other request");
                this.otherChildrenPlural = I18n._ss((String)"ThreadAnnotation|Request|OtherChildren|Plural", (String)"{0} other requests");
                this.combinedItemsSingular = I18n._ss((String)"ThreadAnnotation|Request|Combined|Singular", (String)"{0} request");
                this.combinedItemsPlural = I18n._ss((String)"ThreadAnnotation|Request|Combined|Plural", (String)"{0} requests");
                this.activeEntityText = I18n._ss((String)"Entity, ex: total time {0} was running", (String)"this request");
                this.performedByText = I18n._ss((String)"ThreadAnnotation|PerformedBy, ex: performed by {0}", (String)"this request");
                this.affectingAnotherText = I18n._ss((String)"ThreadAnnotation|AffectingAnother, ex: affecting {0}", (String)"another request");
                break;
            }
            case 3: {
                this.columnDescription = I18n._ss((String)"ThreadAnnotation|Application|CoulumnDescr", (String)"Application");
                this.defaultNoValueText = I18n._ss((String)"ThreadAnnotation|Application|noValue", (String)"<no application>");
                this.tooltip = I18n._ss((String)"ThreadAnnotation|Application|Tooltip", (String)"The application name");
                this.tooltipForCombinedItemsSingular = I18n._ss((String)"ThreadAnnotation|Application|TooltipCombined|Singular", (String)"{0} application");
                this.tooltipForCombinedItemsPlural = I18n._ss((String)"ThreadAnnotation|Application|TooltipCombined|Plural", (String)"{0} applications");
                this.skippedChildrenSingular = I18n._ss((String)"ThreadAnnotation|Application|SkippedChildren|Singular", (String)"{0} skipped application");
                this.skippedChildrenPlural = I18n._ss((String)"ThreadAnnotation|Application|SkippedChildren|Plural", (String)"{0} skipped applications");
                this.otherChildrenSingular = I18n._ss((String)"ThreadAnnotation|Application|OtherChildren|Singular", (String)"{0} other application");
                this.otherChildrenPlural = I18n._ss((String)"ThreadAnnotation|Application|OtherChildren|Plural", (String)"{0} other applications");
                this.combinedItemsSingular = I18n._ss((String)"ThreadAnnotation|Application|Combined|Singular", (String)"{0} application");
                this.combinedItemsPlural = I18n._ss((String)"ThreadAnnotation|Application|Combined|Plural", (String)"{0} applications");
                this.activeEntityText = I18n._ss((String)"Entity, ex: total time {0} was running", (String)"this application");
                this.performedByText = I18n._ss((String)"ThreadAnnotation|PerformedBy, ex: performed by {0}", (String)"this application");
                this.affectingAnotherText = I18n._ss((String)"ThreadAnnotation|AffectingAnother, ex: affecting {0}", (String)"another application");
                break;
            }
            case 5: {
                this.columnDescription = I18n._ss((String)"ThreadAnnotation|Tenant|CoulumnDescr", (String)"Tenant");
                this.defaultNoValueText = I18n._ss((String)"ThreadAnnotation|Tenant|noValue", (String)"<no tenant>");
                this.tooltip = I18n._ss((String)"ThreadAnnotation|Tenant|Tooltip", (String)"The tenant name");
                this.tooltipForCombinedItemsSingular = I18n._ss((String)"ThreadAnnotation|Tenant|TooltipCombined|Singular", (String)"{0} tenant");
                this.tooltipForCombinedItemsPlural = I18n._ss((String)"ThreadAnnotation|Tenant|TooltipCombined|Plural", (String)"{0} tenants");
                this.skippedChildrenSingular = I18n._ss((String)"ThreadAnnotation|Tenant|SkippedChildren|Singular", (String)"{0} skipped tenant");
                this.skippedChildrenPlural = I18n._ss((String)"ThreadAnnotation|Tenant|SkippedChildren|Plural", (String)"{0} skipped tenants");
                this.otherChildrenSingular = I18n._ss((String)"ThreadAnnotation|Tenant|OtherChildren|Singular", (String)"{0} other tenant");
                this.otherChildrenPlural = I18n._ss((String)"ThreadAnnotation|Tenant|OtherChildren|Plural", (String)"{0} other tenants");
                this.combinedItemsSingular = I18n._ss((String)"ThreadAnnotation|Tenant|Combined|Singular", (String)"{0} tenant");
                this.combinedItemsPlural = I18n._ss((String)"ThreadAnnotation|Tenant|Combined|Plural", (String)"{0} tenants");
                this.activeEntityText = I18n._ss((String)"Entity, ex: total time {0} was running", (String)"this tenant");
                this.performedByText = I18n._ss((String)"ThreadAnnotation|PerformedBy, ex: performed by {0}", (String)"this tenant");
                this.affectingAnotherText = I18n._ss((String)"ThreadAnnotation|AffectingAnother, ex: affecting {0}", (String)"another tenant");
                break;
            }
            default: {
                this.columnDescription = this.key;
                this.defaultNoValueText = I18n._ss((String)"ThreadAnnotation|OtherAnnotation|noValue", (String)"<no {0}>", (Object[])new Object[]{this.key});
                this.tooltip = I18n._ss((String)"ThreadAnnotation|OtherAnnotation|Tooltip", (String)"The {0} annotation", (Object[])new Object[]{this.key});
                this.skippedChildrenSingular = I18n._ss((String)"ThreadAnnotation|OtherAnnotation|SkippedChildren|Singular", (String)"{0,number} skipped");
                this.skippedChildrenPlural = I18n._ss((String)"ThreadAnnotation|OtherAnnotation|SkippedChildren|Plural", (String)"{0,number} skipped");
                this.otherChildrenSingular = I18n._ss((String)"ThreadAnnotation|OtherAnnotation|OtherChildren|Singular", (String)"{0,number} other");
                this.otherChildrenPlural = I18n._ss((String)"ThreadAnnotation|OtherAnnotation|OtherChildren|Plural", (String)"{0,number} others");
                this.combinedItemsSingular = "{0} " + this.key;
                this.combinedItemsPlural = "{0} " + this.key;
                this.tooltipForCombinedItemsSingular = "{0} " + this.key;
                this.tooltipForCombinedItemsPlural = "{0} " + this.key;
                this.activeEntityText = I18n._ss((String)"Entity, ex: total time {0} was running", (String)"this Thread with {0}-annotation", (Object[])new Object[]{this.key});
                this.performedByText = I18n._ss((String)"ThreadAnnotation|PerformedBy, ex: performed by {0}", (String)"this thread with {0}-annotation", (Object[])new Object[]{this.key});
                this.affectingAnotherText = I18n._ss((String)"ThreadAnnotation|AffectingAnother, ex: affecting {0}", (String)"another thread with {0}-annotation", (Object[])new Object[]{this.key});
            }
        }
    }

    public String getDefaultNoValueText() {
        return this.defaultNoValueText;
    }

    public String getColumnDescription() {
        return this.columnDescription;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public String getToolTipForCombinedItems(int n) {
        return I18n.formatText_n((String)this.tooltipForCombinedItemsSingular, (String)this.tooltipForCombinedItemsPlural, (int)n, (Object[])new Object[]{n});
    }

    public String getOtherChildrenText(int n) {
        return I18n.formatText_n((String)this.otherChildrenSingular, (String)this.otherChildrenPlural, (int)n, (Object[])new Object[]{n});
    }

    public String getSkippedChildrenText(int n) {
        return I18n.formatText_n((String)this.skippedChildrenSingular, (String)this.skippedChildrenPlural, (int)n, (Object[])new Object[]{n});
    }

    public String getCombinedItemsText(int n) {
        return I18n.formatText_n((String)this.combinedItemsSingular, (String)this.combinedItemsPlural, (int)n, (Object[])new Object[]{n});
    }

    public String getActiveEntityText() {
        return this.activeEntityText;
    }

    public String getPerformedByText() {
        return this.performedByText;
    }

    public String getAffectingAnotherText() {
        return this.affectingAnotherText;
    }

    public String getToolTip(String value) {
        switch (this.slot) {
            case 0: {
                return value == null || value.length() == 0 ? I18n._s((String)"No user information available.") : I18n._s((String)"User '{0}'", (Object[])new Object[]{value});
            }
            case 3: {
                return value == null || value.length() == 0 ? I18n._s((String)"No application information available.") : I18n._s((String)"Application '{0}'", (Object[])new Object[]{value});
            }
            case 1: {
                return value == null || value.length() == 0 ? I18n._s((String)"No session information available.") : I18n._s((String)"Session '{0}'", (Object[])new Object[]{value});
            }
            case 2: {
                return value == null || value.length() == 0 ? I18n._s((String)"No request information available.") : I18n._s((String)"Request '{0}'", (Object[])new Object[]{value});
            }
            case 5: {
                return value == null || value.length() == 0 ? I18n._s((String)"No tenant information available.") : I18n._s((String)"Tenant '{0}'", (Object[])new Object[]{value});
            }
        }
        return value == null || value.length() == 0 ? I18n._ss((String)"ThreadAnnotation|OtherAnnotation|InfoAboutAnnotation", (String)"No {0} information available.", (Object[])new Object[]{this.key}) : this.key + " '" + value + "'";
    }
}

