/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class ThreadDumpThreadStates
implements PersistableProviderEntry {
    private long threadStateRunning;
    private long threadStateWaiting;
    private long threadStateSleeping;
    private long threadStateBlocked;
    private long threadStateIO;
    private int maxNumThreads;

    public ThreadDumpThreadStates(long threadStateRunning, long threadStateWaiting, long threadStateSleeping, long threadStateBlocked, long threadStateIO, int maxNumThreads) {
        this.threadStateRunning = threadStateRunning;
        this.threadStateWaiting = threadStateWaiting;
        this.threadStateSleeping = threadStateSleeping;
        this.threadStateBlocked = threadStateBlocked;
        this.threadStateIO = threadStateIO;
        this.maxNumThreads = maxNumThreads;
    }

    public long getThreadsCount() {
        return this.threadStateBlocked + this.threadStateIO + this.threadStateRunning + this.threadStateSleeping + this.threadStateWaiting;
    }

    public long getThreadStateRunning() {
        return this.threadStateRunning;
    }

    public long getThreadStateWaiting() {
        return this.threadStateWaiting;
    }

    public long getThreadStateSleeping() {
        return this.threadStateSleeping;
    }

    public long getThreadStateBlocked() {
        return this.threadStateBlocked;
    }

    public long getThreadStateIO() {
        return this.threadStateIO;
    }

    public int getMaxNumThreads() {
        return this.maxNumThreads;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        ThreadDumpThreadStates otherLink = (ThreadDumpThreadStates)other;
        long compare = this.threadStateRunning - otherLink.threadStateRunning;
        if (compare == 0L && (compare = this.threadStateSleeping - otherLink.threadStateSleeping) == 0L && (compare = this.threadStateIO - otherLink.threadStateIO) == 0L && (compare = this.threadStateBlocked - otherLink.threadStateBlocked) == 0L) {
            compare = this.threadStateWaiting - otherLink.threadStateWaiting;
        }
        if (compare != 0L) {
            return compare > 0L ? 1 : -1;
        }
        return 0;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        return new ThreadDumpThreadStates(reader.readInt64(), reader.readInt64(), reader.readInt64(), reader.readInt64(), reader.readInt64(), reader.readInt32());
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.threadStateRunning);
        writer.writeInt64(this.threadStateWaiting);
        writer.writeInt64(this.threadStateSleeping);
        writer.writeInt64(this.threadStateBlocked);
        writer.writeInt64(this.threadStateIO);
        writer.writeInt32(this.maxNumThreads);
    }
}

