/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.UniqueEntry;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.thread.ThreadStatus;
import java.io.IOException;

public class ThreadStatusEntry
implements UniqueEntry,
PersistableProviderEntry {
    public static final PersistableProviderEntry readerInstance = new ThreadStatusEntry(ThreadStatus.THREAD_STATUS_UNKNOWN);
    private final int threadStatus;

    public ThreadStatusEntry(ThreadStatus threadStatus) {
        this.threadStatus = threadStatus.getValue();
    }

    @Override
    public int compareToUnique(UniqueEntry other) {
        return this.compareTo(other, null);
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        ThreadStatusEntry otherType = (ThreadStatusEntry)other;
        return this.threadStatus - otherType.threadStatus;
    }

    public ThreadStatus getThreadState() {
        return ThreadStatus.getThreadState((int)this.threadStatus);
    }

    public String getDisplayText() {
        return ThreadStatus.getThreadState((int)this.threadStatus).getDisplayText();
    }

    public String getExportText() {
        return ThreadStatus.getThreadState((int)this.threadStatus).getExportText();
    }

    @Override
    public PersistableProviderEntry getPersistable() {
        return this;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        int threadStatusInt = reader.readInt32();
        ThreadStatus readThreadStatus = ThreadStatus.getThreadState((int)threadStatusInt);
        return new ThreadStatusEntry(readThreadStatus);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.threadStatus);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ThreadStatusEntry) {
            return this.threadStatus == ((ThreadStatusEntry)obj).threadStatus;
        }
        return false;
    }

    public int hashCode() {
        return this.threadStatus;
    }
}

