/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.snapshot.tbs.SimpleTimeDist;
import com.sap.jvm.profiling.snapshot.tbs.TimeDist;

public class TimeDistributionEntryBase
implements ProviderEntry {
    private final SimpleTimeDist distribution;

    public TimeDistributionEntryBase(TimeDist distribution) {
        this.distribution = new SimpleTimeDist(distribution);
    }

    protected TimeDist getDistribution() {
        return this.distribution;
    }

    public long getInterpreterTime() {
        return this.distribution.getInterpreterTime();
    }

    public double getInterpreterPercentage() {
        return 1.0 * (double)this.getInterpreterTime() / (double)this.getTotalTime();
    }

    public long getInlinedTime() {
        return this.distribution.getInlinedTime() + this.distribution.getInlinedTier1Time();
    }

    public double getInlinedPercentage() {
        return 1.0 * (double)this.getInlinedTime() / (double)this.getTotalTime();
    }

    public long getCompiledTime() {
        return this.distribution.getCompiledTime() + this.distribution.getCompiledTier1Time();
    }

    public double getCompiledPercentage() {
        return 1.0 * (double)this.getCompiledTime() / (double)this.getTotalTime();
    }

    public long getNativeInterpreterTime() {
        return this.distribution.getNativeInterpreterTime();
    }

    public double getNativeInterpreterPercentage() {
        return 1.0 * (double)this.getNativeInterpreterTime() / (double)this.getTotalTime();
    }

    public long getNativeInlinedTime() {
        return this.distribution.getNativeInlinedTime() + this.distribution.getNativeInlinedTier1Time();
    }

    public double getNativeInlinedPercentage() {
        return 1.0 * (double)this.getNativeInlinedTime() / (double)this.getTotalTime();
    }

    public long getNativeCompiledTime() {
        return this.distribution.getNativeCompiledTime() + this.distribution.getNativeCompiledTier1Time();
    }

    public double getNativeCompiledPercentage() {
        return 1.0 * (double)this.getNativeCompiledTime() / (double)this.getTotalTime();
    }

    public long getOtherTime() {
        return this.distribution.getOtherTime();
    }

    public long getTotalTime() {
        return this.distribution.getTotalTime();
    }

    public double getOtherPercentage() {
        return 1.0 * (double)this.getOtherTime() / (double)this.getTotalTime();
    }

    @Override
    public int compareTo(ProviderEntry otherEntry, EntryContext context) {
        SimpleTimeDist other = ((TimeDistributionEntryBase)otherEntry).distribution;
        return this.distribution.compareTo(other);
    }

    protected static TimeDist getDistribution(ProviderEntry entry) {
        if (entry == null) {
            return SimpleTimeDist.EMPTY;
        }
        return ((TimeDistributionEntryBase)entry).getDistribution();
    }

    public static TimeDist getSum(ProviderEntry[] entries) {
        TimeDist sum = SimpleTimeDist.EMPTY;
        for (int i = 0; i < entries.length; ++i) {
            TimeDistributionEntryBase entry = (TimeDistributionEntryBase)entries[i];
            sum = sum.getSum(entry.getDistribution());
        }
        return sum;
    }
}

