/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.Diffable;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Quantity;
import com.sap.jvm.profiling.presentation.typed.entries.TimestampDiff;

public final class Timestamp
implements Quantity,
Diffable {
    private long timestamp;
    private String missingMessage = "";

    public Timestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Timestamp(String missingMessage) {
        this.timestamp = 0L;
        this.missingMessage = missingMessage;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getQuantity() {
        return this.timestamp;
    }

    public String getMissingMessage() {
        return this.missingMessage;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        Timestamp otherTimestamp = (Timestamp)other;
        return this.timestamp < otherTimestamp.timestamp ? -1 : (this.timestamp > otherTimestamp.timestamp ? 1 : 0);
    }

    @Override
    public ProviderEntry getAccumulation(ProviderEntry[] entries) {
        long min = Long.MAX_VALUE;
        for (ProviderEntry entry : entries) {
            long ts = ((Timestamp)entry).getTimestamp();
            if (ts >= min) continue;
            min = ts;
        }
        return new Timestamp(min);
    }

    @Override
    public Difference getDifference(ProviderEntry newEntry, ProviderEntry oldEntry) {
        return new TimestampDiff((Timestamp)oldEntry, (Timestamp)newEntry);
    }
}

