/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.entries;

import com.sap.jvm.profiling.presentation.typed.EntryContext;
import com.sap.jvm.profiling.presentation.typed.entries.DiffEntryUtils;
import com.sap.jvm.profiling.presentation.typed.entries.Difference;
import com.sap.jvm.profiling.presentation.typed.entries.PersistableProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class TimestampDiff
implements Difference {
    static final TimestampDiff readerInstance = new TimestampDiff(new Timestamp(0L), new Timestamp(0L));
    static final String[] subColumnTitles = new String[]{DiffEntryUtils.OLD_VALUE_COLUMN_SUBTITEL, DiffEntryUtils.NEW_VALUE_COLUMN_SUBTITEL};
    static final Class<?>[] subColumnTypes = new Class[]{Timestamp.class, Timestamp.class};
    private Timestamp oldEntry;
    private Timestamp newEntry;

    public TimestampDiff(Timestamp oldEntry, Timestamp newEntry) {
        this.oldEntry = oldEntry == null ? new Timestamp(0L) : oldEntry;
        this.newEntry = newEntry == null ? new Timestamp(0L) : newEntry;
    }

    @Override
    public PersistableProviderEntry read(ResourceReader reader) throws IOException {
        return new TimestampDiff(new Timestamp(reader.readInt64()), new Timestamp(reader.readInt64()));
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.oldEntry.getTimestamp());
        writer.writeInt64(this.newEntry.getTimestamp());
    }

    @Override
    public ProviderEntry getSubColumnEntry(int subColId) {
        if (subColId == 0) {
            return this.oldEntry;
        }
        if (subColId == 1) {
            return this.newEntry;
        }
        throw new IllegalArgumentException("subColId (" + subColId + ") must be in range 0..1");
    }

    @Override
    public Class<? extends ProviderEntry>[] getSubColumnTypes() {
        return subColumnTypes;
    }

    @Override
    public String[] getSubColumnTitles() {
        return subColumnTitles;
    }

    @Override
    public int compareTo(ProviderEntry other, EntryContext context) {
        if (other == this) {
            return 0;
        }
        TimestampDiff otherEntry = (TimestampDiff)other;
        int result = this.oldEntry.compareTo(otherEntry.oldEntry, context);
        if (result != 0) {
            return result;
        }
        return this.newEntry.compareTo(otherEntry.oldEntry, context);
    }

    @Override
    public boolean isNull() {
        return this.oldEntry.compareTo(this.newEntry, null) == 0;
    }

    @Override
    public int getNrOfStandardSubColumns() {
        return 2;
    }

    @Override
    public ProviderEntry getNewValue() {
        return this.newEntry;
    }

    @Override
    public ProviderEntry getOldValue() {
        return this.oldEntry;
    }
}

