/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.memory.event.GcSkippedReason;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesProvider;
import com.sap.jvm.profiling.presentation.typed.entries.AmountByAge;
import com.sap.jvm.profiling.presentation.typed.entries.NormalString;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBuffers;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytesByAge;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfCleanedCards;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfFailedOverflowRefills;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfFailedStealOperations;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfGarbageOnlyHeapRegions;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfHeapRegions;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfIterations;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfNonCoalescableBlocks;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjects;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjectsByAge;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfSuccessfulOverflowRefills;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfSuccessfulStealOperations;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfYieldingStealOperations;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfYields;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.gc.Attribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcStatisticConverter;
import com.sap.jvm.profiling.presentation.typed.gc.MetaSpaceAwareString;
import com.sap.jvm.profiling.presentation.typed.gc.SessionAwareString;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.StatisticValueElement;
import com.sap.jvm.util.misc.SignatureHelper;
import com.sap.jvm.util.pair.ObjectPair;

public enum GcEventAttribute implements Attribute<ObjectPair<GcStatistic, Integer>>
{
    TIME_STAMP(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Start time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The start time of this GC event"), GcEventStatisticValueElement.TIME_STAMP, GcStatisticConverter.TimestampConverter, new Attribute[0]),
    EVENT_TYPE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Event type"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The type of the GC event"), GcEventStatisticValueElement.EVENT_TYPE, (GcStatisticConverter)new GcStatisticConverter.ConverterBase(NormalString.class){

        @Override
        public ProviderEntry getValue(long value) {
            GcEventType type = GcEventType.values()[(int)value];
            return new NormalString(type.getShortDescrDisplay(), type.getLongDescrDisplay());
        }
    }, 16392, new Attribute[0]),
    CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed during this GC event"), GcEventStatisticValueElement.CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the this GC event"), GcEventStatisticValueElement.DURATION, GcStatisticConverter.ElapsedTimeMaxConverter, new Attribute[0]),
    PAGE_FAULTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Page faults"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of page faults triggered during this GC event. A large\nnumber indicates, that the heap may be too large and paging occurred."), GcEventStatisticValueElement.PAGE_FAULTS, GcStatisticConverter.NrOfPageFaultsConverter, new Attribute[0]),
    MAJOR_PAGE_FAULTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Major page faults"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of major page faults triggered during this GC event. A large\nnumber indicates, that the heap may be too large and paging occurred."), GcEventStatisticValueElement.MAJOR_PAGE_FAULTS, GcStatisticConverter.NrOfMajorPageFaultsConverter, new Attribute[0]),
    MINOR_PAGE_FAULTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Minor page faults"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of minor page faults triggered during this GC event. A large\nnumber indicates, that the heap may be too large and paging occurred."), GcEventStatisticValueElement.MINOR_PAGE_FAULTS, GcStatisticConverter.NrOfMinorPageFaultsConverter, new Attribute[0]),
    FULL_GCS_SINCE_CONC_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Full GCs since last conc. GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of full GCs since last concurrent GC"), GcEventStatisticValueElement.FULL_GCS_SINCE_CONC_GC, GcStatisticConverter.NrOfGcsConverter, 14336, new Attribute[0]),
    FULL_GCS_BEFORE_COMPACTION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Full GCs before compaction"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of full GCs done before compaction"), GcEventStatisticValueElement.FULL_GCS_BEFORE_COMPACTION, GcStatisticConverter.NrOfGcsConverter, 14336, new Attribute[0]),
    IS_USER_REQUESTED(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Is user-requested"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Is the GC requested by the user?"), GcEventStatisticValueElement.IS_USER_REQUESTED, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    IS_INCREMENTAL_COLLECTION_WILL_FAIL(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Incremental collection will fail"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether the incremental collection will fail"), GcEventStatisticValueElement.IS_INCREMENTAL_COLLECTION_WILL_FAIL, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    IS_CLEAR_SOFTREFS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Clear soft references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether soft references are cleared"), GcEventStatisticValueElement.IS_CLEAR_SOFTREFS, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    AVERAGE_PROMOTED(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Average promoted"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The anticipated number of bytes to be promoted from the young\ngeneration into the old generation during the next GC"), GcEventStatisticValueElement.AVERAGE_PROMOTED, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    SKIPPED_REASON(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Skipped reason"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The reason for skipping a special GC"), GcEventStatisticValueElement.SKIPPED_REASON, (GcStatisticConverter)new GcStatisticConverter.ConverterBase(NormalString.class){

        @Override
        public ProviderEntry getValue(long value) {
            GcSkippedReason reason = GcSkippedReason.values()[(int)value];
            return new NormalString(reason.getShortDescription(), reason.getLongDescription());
        }
    }, 16392, new Attribute[0]),
    CAUSING_OBJECT_TYPE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Causing object type"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The object type of the (biggest) object that caused the promotion\nfailure to occur. Due to memory restrictions the name may be truncated."), GcEventStatisticValueElement.CAUSING_OBJECT_TYPE, (GcStatisticConverter)new GcStatisticConverter.EventConverterBase(NormalString.class){

        private String getFixedClassName(String className) {
            if (className.startsWith("[")) {
                return SignatureHelper.fromFieldDescriptor((String)className.replace('.', '/'));
            }
            return className;
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcStatistic gcStatistic, int eventId) {
            assert (element.getType() == 2);
            GcEventBase event = gcStatistic.getEvents()[eventId];
            return new NormalString(this.getFixedClassName(element.getStringValue(event)));
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcEventStatisticValue value, GcEventStatisticValue total) {
            assert (element.getType() == 2);
            return new NormalString(this.getFixedClassName((String)value.getElementValue(element)));
        }
    }, 16392, new Attribute[0]),
    CAUSING_OBJECT_SIZE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Causing object size"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The object size of the (biggest) object that caused the promotion failure to occur."), GcEventStatisticValueElement.CAUSING_OBJECT_SIZE, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    LARGEST_CONTIGUOUS_BLOCK_IN_OLD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Largest contiguous block in old"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"In case the old generation does not use compaction, the free\nmemory might get fragmented. This value indicates the largest\npossible (single) allocation in the old generation."), GcEventStatisticValueElement.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    FAILED_PROMOTIONS_COUNT(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Failed promotions (this GC)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects that could not be promoted to the old generation during this GC."), GcEventStatisticValueElement.FAILED_PROMOTIONS_COUNT, GcStatisticConverter.NrOfObjectsConverter, new Attribute[0]),
    PROMOTION_FAILURE_NR(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Promotion failures until now"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of promotion failures that occurred until now (including this event)."), GcEventStatisticValueElement.PROMOTION_FAILURE_NR, GcStatisticConverter.NrOfPromotionFailuresConverter, 10240, new Attribute[0]),
    FIRST_PROMOTION_FAILURE_TIMESTAMP(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"First promotion failure"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The time when the first promotion failure of this event happened."), GcEventStatisticValueElement.FIRST_PROMOTION_FAILURE_TIMESTAMP, GcStatisticConverter.TimestampConverter, new Attribute[0]),
    NR_OF_NON_ARRAY_CLASSES_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Nr. non-array classes loaded before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. non-array classes loaded before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of non-array classes in the SystemDictionary before unloading."), GcEventStatisticValueElement.NR_OF_NON_ARRAY_CLASSES_BEFORE, GcStatisticConverter.NrOfClassesConverter, new Attribute[0]),
    NR_OF_NON_ARRAY_CLASSES_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Nr. non-array classes loaded after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. non-array classes loaded after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of non-array classes in the SystemDictionary after unloading."), GcEventStatisticValueElement.NR_OF_NON_ARRAY_CLASSES_AFTER, GcStatisticConverter.NrOfClassesConverter, new Attribute[0]),
    NR_OF_UNLOADED_NON_ARRAY_CLASSES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Unloaded non-array classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of non-array classes that were unloaded from the SystemDictionary during this event"), GcEventStatisticValueElement.NR_OF_UNLOADED_NON_ARRAY_CLASSES, GcStatisticConverter.NrOfUnloadedClassesConverter, new Attribute[0]),
    NR_OF_ARRAY_CLASSES_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Nr. array classes loaded before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. array classes loaded before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of array classes in the SystemDictionary before unloading."), GcEventStatisticValueElement.NR_OF_ARRAY_CLASSES_BEFORE, GcStatisticConverter.NrOfClassesConverter, new Attribute[0]),
    NR_OF_ARRAY_CLASSES_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Nr. array classes loaded after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. array classes loaded after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of array classes in the SystemDictionary after unloading."), GcEventStatisticValueElement.NR_OF_ARRAY_CLASSES_AFTER, GcStatisticConverter.NrOfClassesConverter, new Attribute[0]),
    NR_OF_UNLOADED_ARRAY_CLASSES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Unloaded array classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of array classes that were unloaded from the SystemDictionary during this event"), GcEventStatisticValueElement.NR_OF_UNLOADED_ARRAY_CLASSES, GcStatisticConverter.NrOfUnloadedClassesConverter, new Attribute[0]),
    METASPACE_USED_BEFORE_AND_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Used in Meta"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes used in meta space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the meta space"), GcEventStatisticValueElement.METASPACE_USED_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcEventStatisticValueElement.METASPACE_USED_BEFORE, (StatisticValueElement)GcEventStatisticValueElement.METASPACE_USED_AFTER, (StatisticValueElement)GcStatisticValueElement.MAX_PERM_GEN_SIZE), -1, new Attribute[0]),
    METASPACE_USED_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Meta before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes used in metaspace before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the meta space before unloading"), GcEventStatisticValueElement.METASPACE_USED_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE, (StatisticValueElement)GcEventStatisticValueElement.METASPACE_COMMITTED_BEFORE), 12288, new Attribute[0]),
    METASPACE_USED_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Meta after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes used in meta space after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the meta space after unloading"), GcEventStatisticValueElement.METASPACE_USED_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE, (StatisticValueElement)GcEventStatisticValueElement.METASPACE_COMMITTED_AFTER), 12288, new Attribute[0]),
    METASPACE_FREED(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Freed in Meta"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in meta space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were freed in the meta space during this GC event"), GcEventStatisticValueElement.BYTES_FREED_IN_METASPACE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE), 45060, new Attribute[0]),
    METASPACE_COMMITTED_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes committed in metaspace before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes committed in metaspace before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes committed in the meta space before unloading"), GcEventStatisticValueElement.METASPACE_COMMITTED_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE), 12288, new Attribute[0]),
    METASPACE_COMMITTED_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes committed in meta space after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes committed in meta space after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes committed in the meta space after unloading"), GcEventStatisticValueElement.METASPACE_COMMITTED_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE), 12288, new Attribute[0]),
    CLASS_SPACE_USED_BEFORE_AND_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Used in Class Space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes used in class meta space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the class meta space"), GcEventStatisticValueElement.CLASS_SPACE_USED_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcEventStatisticValueElement.CLASS_SPACE_USED_BEFORE, (StatisticValueElement)GcEventStatisticValueElement.CLASS_SPACE_USED_AFTER, (StatisticValueElement)GcStatisticValueElement.MAX_CLASS_SPACE_SIZE), -1, new Attribute[0]),
    CLASS_SPACE_USED_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Space before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes used in class space before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the class meta space before unloading"), GcEventStatisticValueElement.CLASS_SPACE_USED_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_CLASS_SPACE_SIZE, (StatisticValueElement)GcEventStatisticValueElement.CLASS_SPACE_COMMITTED_BEFORE), 12288, new Attribute[0]),
    CLASS_SPACE_USED_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Space after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes used in class meta space after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the class meta space after unloading"), GcEventStatisticValueElement.CLASS_SPACE_USED_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_CLASS_SPACE_SIZE, (StatisticValueElement)GcEventStatisticValueElement.CLASS_SPACE_COMMITTED_AFTER), 12288, new Attribute[0]),
    CLASS_SPACE_FREED(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Freed in Class Space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in class meta space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were freed in the class meta space during this GC event"), GcEventStatisticValueElement.BYTES_FREED_IN_CLASS_SPACE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_CLASS_SPACE_SIZE), 45060, new Attribute[0]),
    CLASS_SPACE_COMMITTED_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes committed in class class meta space before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes committed in class class meta space before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes committed in the class meta space before unloading"), GcEventStatisticValueElement.CLASS_SPACE_COMMITTED_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_CLASS_SPACE_SIZE), 12288, new Attribute[0]),
    CLASS_SPACE_COMMITTED_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Bytes committed in class meta space after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes committed in class meta space after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes committed in the class meta space after unloading"), GcEventStatisticValueElement.CLASS_SPACE_COMMITTED_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_CLASS_SPACE_SIZE), 12288, new Attribute[0]),
    SOFT_REFERENCE_MAX_LAST_USED_TIME(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Max. last used time of soft refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Max. last used time of soft references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum time between the last call to the get() method of a\nSoftReference and this event. When clearing of soft references\nis forced, this will be 0."), GcEventStatisticValueElement.SOFT_REFERENCE_MAX_LAST_USED_TIME, GcStatisticConverter.ElapsedTimeMaxConverter, new Attribute[0]),
    SOFT_REFERENCES_FOUND(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Found soft refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Found soft references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of SoftReference objects that were encountered during this GC event"), GcEventStatisticValueElement.SOFT_REFERENCES_FOUND, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    SOFT_REFERENCES_RESURRECTED_BY_POLICY(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft refs kept alive by policy"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Soft references kept alive by policy"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of SoftReference objects whose referents were kept alive by\nthe soft reference policy during the marking phase of the garbage collection."), GcEventStatisticValueElement.SOFT_REFERENCES_RESURRECTED_BY_POLICY, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    SOFT_REFERENCES_CLEARED(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Cleared soft refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cleared soft references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of SoftReference objects that were cleared during this GC event."), GcEventStatisticValueElement.SOFT_REFERENCES_CLEARED, GcStatisticConverter.NrOfSoftRefsConverter, 47108, new Attribute[0]),
    SOFT_REFERENCES_NOT_CLEARED(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft refs not cleared"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Soft references not cleared"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of SoftReference objects that were not cleared during this GC event."), GcEventStatisticValueElement.SOFT_REFERENCES_NOT_CLEARED, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    SOFT_REFERENCES_LIVE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Live soft refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Live soft references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of live SoftReference objects."), GcEventStatisticValueElement.SOFT_REFERENCES_LIVE, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    SOFT_REFERENCES_ENQUEUED(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft refs newly enqueued"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Soft references newly enqueued"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of SoftReference objects that were newly enqueued during this GC event."), GcEventStatisticValueElement.SOFT_REFERENCES_ENQUEUED, GcStatisticConverter.NrOfSoftRefsConverter, 47108, new Attribute[0]),
    SOFT_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft refs found in SoftRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New soft references found during SoftRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive SoftReference objects that were encountered during\nhandling of SoftReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.SOFT_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    WEAK_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Weak refs found in SoftRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New weak references found during SoftRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive WeakReference objects that were encountered during\nhandling of SoftReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.WEAK_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, GcStatisticConverter.NrOfWeakRefsConverter, 47104, new Attribute[0]),
    FINAL_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Final refs found in SoftRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New final references found during SoftRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive FinalReference objects that were encountered during\nhandling of SoftReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.FINAL_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, GcStatisticConverter.NrOfFinalRefsConverter, 47104, new Attribute[0]),
    PHANTOM_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Phantom refs found in SoftRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New phantom references found during SoftRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive PhantomReference objects that were encountered during\nhandling of SoftReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.PHANTOM_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, GcStatisticConverter.NrOfPhantomRefsConverter, 47104, new Attribute[0]),
    WEAK_REFERENCES_FOUND(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Found weak refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Found weak references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of WeakReference objects that were encountered during this GC event"), GcEventStatisticValueElement.WEAK_REFERENCES_FOUND, GcStatisticConverter.NrOfWeakRefsConverter, 47104, new Attribute[0]),
    WEAK_REFERENCES_CLEARED(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Cleared weak refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cleared weak references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of WeakReference objects that were cleared during this GC event."), GcEventStatisticValueElement.WEAK_REFERENCES_CLEARED, GcStatisticConverter.NrOfWeakRefsConverter, 47108, new Attribute[0]),
    WEAK_REFERENCES_LIVE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Live weak refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Live weak references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of live WeakReference objects."), GcEventStatisticValueElement.WEAK_REFERENCES_LIVE, GcStatisticConverter.NrOfWeakRefsConverter, 47104, new Attribute[0]),
    WEAK_REFERENCES_ENQUEUED(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Weak refs newly enqueued"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Weak references newly enqueued"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of WeakReference objects that were newly enqueued during this GC event."), GcEventStatisticValueElement.WEAK_REFERENCES_ENQUEUED, GcStatisticConverter.NrOfWeakRefsConverter, 47108, new Attribute[0]),
    FINAL_REFERENCES_FOUND(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Found final refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Found final references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of FinalReference objects (that are used to implement\nfinalization) that were encountered during this GC event"), GcEventStatisticValueElement.FINAL_REFERENCES_FOUND, GcStatisticConverter.NrOfFinalRefsConverter, 47104, new Attribute[0]),
    FINAL_REFERENCES_LIVE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Live final refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Live final references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of live FinalReference objects."), GcEventStatisticValueElement.FINAL_REFERENCES_LIVE, GcStatisticConverter.NrOfFinalRefsConverter, 47104, new Attribute[0]),
    FINAL_REFERENCES_ENQUEUED(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Final refs newly enqueued"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Final references newly enqueued"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of FinalReference objects that were newly enqueued during this GC event."), GcEventStatisticValueElement.FINAL_REFERENCES_ENQUEUED, GcStatisticConverter.NrOfFinalRefsConverter, 47108, new Attribute[0]),
    SOFT_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft refs found in FinalRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New soft references found during FinalRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive SoftReference objects that were encountered during\nhandling of FinalReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.SOFT_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    WEAK_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Weak refs found in FinalRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New weak references found during FinalRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive WeakReference objects that were encountered during\nhandling of FinalReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.WEAK_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, GcStatisticConverter.NrOfWeakRefsConverter, 47104, new Attribute[0]),
    FINAL_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Final refs found in FinalRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New final references found during FinalRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive FinalReference objects that were encountered during\nhandling of FinalReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.FINAL_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, GcStatisticConverter.NrOfFinalRefsConverter, 47104, new Attribute[0]),
    PHANTOM_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Phantom refs found in FinalRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New phantom references found during FinalRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive PhantomReference objects that were encountered during\nhandling of FinalReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.PHANTOM_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, GcStatisticConverter.NrOfPhantomRefsConverter, 47104, new Attribute[0]),
    PHANTOM_REFERENCES_FOUND(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Found phantom refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Found phantom references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of PhantomReference objects (that are used to implement\nfinalization) that were encountered during this GC event"), GcEventStatisticValueElement.PHANTOM_REFERENCES_FOUND, GcStatisticConverter.NrOfPhantomRefsConverter, 47104, new Attribute[0]),
    PHANTOM_REFERENCES_LIVE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Live phantom refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Live phantom references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of live PhantomReference objects."), GcEventStatisticValueElement.PHANTOM_REFERENCES_LIVE, GcStatisticConverter.NrOfPhantomRefsConverter, 47104, new Attribute[0]),
    PHANTOM_REFERENCES_ENQUEUED(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Phantom refs newly enqueued"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phantom references newly enqueued"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of PhantomReference objects that were newly enqueued during this GC event."), GcEventStatisticValueElement.PHANTOM_REFERENCES_ENQUEUED, GcStatisticConverter.NrOfPhantomRefsConverter, 47108, new Attribute[0]),
    SOFT_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft refs found in PhantomRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New soft references found during PhantomRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive SoftReference objects that were encountered during\nhandling of PhantomReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.SOFT_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    WEAK_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Weak refs found in PhantomRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New weak references found during PhantomRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive WeakReference objects that were encountered during\nhandling of PhantomReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.WEAK_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, GcStatisticConverter.NrOfWeakRefsConverter, 47104, new Attribute[0]),
    FINAL_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Final refs found in PhantomRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New final references found during PhantomRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive FinalReference objects that were encountered during\nhandling of PhantomReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.FINAL_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, GcStatisticConverter.NrOfFinalRefsConverter, 47104, new Attribute[0]),
    PHANTOM_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Phantom refs found in PhantomRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"New phantom references found during PhantomRef handling"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of alive PhantomReference objects that were encountered during\nhandling of PhantomReference objects.") + "\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Reference objects that are found during reference processing are not\nhandled specially, but treated like ordinary objects, i.e. strong references.\nTherefore, the referents of these Reference objects may survive longer than expected."), GcEventStatisticValueElement.PHANTOM_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, GcStatisticConverter.NrOfPhantomRefsConverter, 47104, new Attribute[0]),
    SOFT_REFERENCES_FOUND_IN_PREPROCESSING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft refs found in preprocessing"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Soft references found in preprocessing"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of SoftReference objects were encountered during the SoftReference preprocessing"), GcEventStatisticValueElement.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Dead soft refs found in preprocessing"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Dead soft references found in preprocessing"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of dead SoftReference objects were encountered during the SoftReference preprocessing"), GcEventStatisticValueElement.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft refs resurrected in preprocessing"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Soft references resurrected in preprocessing"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of SoftReference objects were resurrected during the SoftReference preprocessing"), GcEventStatisticValueElement.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING, GcStatisticConverter.NrOfSoftRefsConverter, 47104, new Attribute[0]),
    SOFT_REFERENCE_HANDLING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft ref handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Soft references handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the SoftReference handling"), GcEventStatisticValueElement.SOFT_REFERENCE_HANDLING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    SOFT_REFERENCE_HANDLING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Soft ref handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Soft references handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by handling SoftReference objects"), GcEventStatisticValueElement.SOFT_REFERENCE_HANDLING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    WEAK_REFERENCE_HANDLING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Weak ref handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Weak references handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the WeakReference handling"), GcEventStatisticValueElement.WEAK_REFERENCE_HANDLING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    WEAK_REFERENCE_HANDLING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Weak ref handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Weak references handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by handling WeakReference objects"), GcEventStatisticValueElement.WEAK_REFERENCE_HANDLING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    FINAL_REFERENCE_HANDLING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Final ref handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Final references handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the FinalReference handling"), GcEventStatisticValueElement.FINAL_REFERENCE_HANDLING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    FINAL_REFERENCE_HANDLING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Final ref handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Final references handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by handling FinalReference objects"), GcEventStatisticValueElement.FINAL_REFERENCE_HANDLING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    PHANTOM_REFERENCE_HANDLING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Phantom ref handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phantom references handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the PhantomReference handling"), GcEventStatisticValueElement.PHANTOM_REFERENCE_HANDLING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    PHANTOM_REFERENCE_HANDLING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Phantom ref handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phantom references handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by handling PhantomReference objects"), GcEventStatisticValueElement.PHANTOM_REFERENCE_HANDLING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    JNIWEAK_REFERENCE_HANDLING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"JNI weak ref handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"JNI weak references handling duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the JNI weak reference handling"), GcEventStatisticValueElement.JNIWEAK_REFERENCE_HANDLING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    JNIWEAK_REFERENCE_HANDLING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"JNI weak ref handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"JNI weak references handling CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by handling JNI weak references"), GcEventStatisticValueElement.JNIWEAK_REFERENCE_HANDLING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    TRANSITION_TO_SINGLE_THREADING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Transition to serial duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the transition from multi-threading to serial execution"), GcEventStatisticValueElement.TRANSITION_TO_SINGLE_THREADING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    TRANSITION_TO_SINGLE_THREADING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Transition to serial CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by switching from multi-threading to serial execution"), GcEventStatisticValueElement.TRANSITION_TO_SINGLE_THREADING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    JNIWEAK_REFS_ALIVE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Live JNI weak refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Live JNI weak references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of references found to be alive during handling of JNI weak references"), GcEventStatisticValueElement.JNIWEAK_REFS_ALIVE, GcStatisticConverter.NrOfJniWeakRefsConverter, 47104, new Attribute[0]),
    JNIWEAK_REFS_DEADS(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Dead JNI weak refs"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Dead JNI weak references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of references found to be dead during handling of JNI weak references"), GcEventStatisticValueElement.JNIWEAK_REFS_DEADS, GcStatisticConverter.NrOfJniWeakRefsConverter, 47108, new Attribute[0]),
    BYTES_IN_EDEN_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Eden before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in eden-space before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the eden-space before this GC event"), GcEventStatisticValueElement.BYTES_IN_EDEN_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_EDEN_BEFORE_GC), 12288, new Attribute[0]),
    BYTES_IN_EDEN_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Eden after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in eden-space after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that are used in the eden-space after this GC event"), GcEventStatisticValueElement.BYTES_IN_EDEN_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_EDEN_AFTER_GC), 12288, new Attribute[0]),
    BYTES_IN_EDEN_BEFORE_AND_AFTER(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"Eden"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in eden-space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the eden-space before and after this GC."), GcEventStatisticValueElement.BYTES_IN_EDEN_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcEventStatisticValueElement.BYTES_IN_EDEN_BEFORE, (StatisticValueElement)GcEventStatisticValueElement.BYTES_IN_EDEN_AFTER, (StatisticValueElement)GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), new Attribute[0]),
    FREED_IN_EDEN(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Freed in Eden"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in eden-space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were freed in the eden-space during this GC event"), GcEventStatisticValueElement.FREED_IN_EDEN, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), 12292, new Attribute[0]),
    BYTES_IN_FROM_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"From-space before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in from-space before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the from-space before this GC event"), GcEventStatisticValueElement.BYTES_IN_FROM_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_FROM_BEFORE_GC), 12288, new Attribute[0]),
    BYTES_IN_FROM_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"From-space after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in from-space after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that are used in the from-space after this GC event"), GcEventStatisticValueElement.BYTES_IN_FROM_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_FROM_AFTER_GC), 12288, new Attribute[0]),
    BYTES_IN_FROM_BEFORE_AND_AFTER(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"From"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in from-space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the from-space before and after this GC."), GcEventStatisticValueElement.BYTES_IN_FROM_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcEventStatisticValueElement.BYTES_IN_FROM_BEFORE, (StatisticValueElement)GcEventStatisticValueElement.BYTES_IN_FROM_AFTER, (StatisticValueElement)GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), new Attribute[0]),
    FREED_IN_FROM(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Freed in From"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in from-space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were freed in the from-space during this GC event"), GcEventStatisticValueElement.FREED_IN_FROM, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), 45056, new Attribute[0]),
    BYTES_IN_TO_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"To-space before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in to-space before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the to-space before this GC event"), GcEventStatisticValueElement.BYTES_IN_TO_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_TO_BEFORE_GC), 45056, new Attribute[0]),
    BYTES_IN_TO_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"To-space after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in to-space after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that are used in the to-space after this GC event"), GcEventStatisticValueElement.BYTES_IN_TO_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_TO_AFTER_GC), 45056, new Attribute[0]),
    BYTES_IN_TO_BEFORE_AND_AFTER(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"To"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in to-space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the to-space before and after this GC."), GcEventStatisticValueElement.BYTES_IN_TO_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcEventStatisticValueElement.BYTES_IN_TO_BEFORE, (StatisticValueElement)GcEventStatisticValueElement.BYTES_IN_TO_AFTER, (StatisticValueElement)GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), new Attribute[0]),
    FREED_IN_TO(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Freed in To"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in to-space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were freed in the to-space during this GC event"), GcEventStatisticValueElement.FREED_IN_TO, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), 45056, new Attribute[0]),
    BYTES_IN_YOUNG_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Young before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in young generation before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the young generation before this GC event"), GcEventStatisticValueElement.BYTES_IN_YOUNG_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_YOUNG_BEFORE_GC), 45056, new Attribute[0]),
    BYTES_IN_YOUNG_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Young after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in young generation after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that are used in the young generation after this GC event"), GcEventStatisticValueElement.BYTES_IN_YOUNG_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_YOUNG_AFTER_GC), 45056, new Attribute[0]),
    BYTES_IN_YOUNG_BEFORE_AND_AFTER(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"Young"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in young generation"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the young generation before and after this GC."), GcEventStatisticValueElement.BYTES_IN_YOUNG_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcEventStatisticValueElement.BYTES_IN_YOUNG_BEFORE, (StatisticValueElement)GcEventStatisticValueElement.BYTES_IN_YOUNG_AFTER, (StatisticValueElement)GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), new Attribute[0]),
    FREED_IN_YOUNG(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Freed in Young"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in young generation"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were freed in the young generation during this GC event"), GcEventStatisticValueElement.FREED_IN_YOUNG, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), 45060, new Attribute[0]),
    BYTES_IN_OLD_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Old before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in old generation before"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the old generation before this GC event"), GcEventStatisticValueElement.BYTES_IN_OLD_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_OLD_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_OLD_BEFORE_GC), 12288, new Attribute[0]),
    BYTES_IN_OLD(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"Old"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in old generation"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the old generation"), GcEventStatisticValueElement.BYTES_IN_OLD, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_OLD_GEN_SIZE), 12288, new Attribute[0]),
    BYTES_IN_OLD_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Old after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in old generation after"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that are used in the old generation after this GC event"), GcEventStatisticValueElement.BYTES_IN_OLD_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_OLD_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_OLD_AFTER_GC), 12288, new Attribute[0]),
    BYTES_IN_OLD_BEFORE_AND_AFTER(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"Old"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in old generation"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the old generation before and after this GC."), GcEventStatisticValueElement.BYTES_IN_OLD_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcEventStatisticValueElement.BYTES_IN_OLD_BEFORE, (StatisticValueElement)GcEventStatisticValueElement.BYTES_IN_OLD_AFTER, (StatisticValueElement)GcStatisticValueElement.MAX_OLD_GEN_SIZE), new Attribute[0]),
    BYTES_FREED_IN_OLD(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Freed in Old"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in old generation"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were freed in the old generation during this GC event"), GcEventStatisticValueElement.BYTES_FREED_IN_OLD, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_OLD_GEN_SIZE), 45060, new Attribute[0]),
    BYTES_IN_PERM_BEFORE(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Perm before"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Meta before")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in perm generation before"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in meta space before")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the permanent generation before this GC event"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the meta space before this GC event")), GcEventStatisticValueElement.BYTES_IN_PERM_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_PERM_BEFORE_GC), 12288, new Attribute[0]),
    PERM_USED(new MetaSpaceAwareString(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"Perm"), I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"Meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in perm generation"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in meta space")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the permanent generation"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the meta space")), GcEventStatisticValueElement.PERM_USED, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE), 12288, new Attribute[0]),
    BYTES_IN_PERM_AFTER(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Perm after"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Meta after")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in perm generation after"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in meta space after")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the permanent generation after this GC event"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the meta space after this GC event")), GcEventStatisticValueElement.BYTES_IN_PERM_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_PERM_AFTER_GC), 12288, new Attribute[0]),
    BYTES_IN_PERM_BEFORE_AND_AFTER(new MetaSpaceAwareString(I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"Perm"), I18n._tss((I18n.TextType)I18n.TextType.XCOL, (String)"GC memory region name", (String)"Meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in perm generation"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in meta space")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the permanent generation before and after this GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the meta space before and after this GC")), GcEventStatisticValueElement.BYTES_IN_PERM_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcEventStatisticValueElement.BYTES_IN_PERM_BEFORE, (StatisticValueElement)GcEventStatisticValueElement.BYTES_IN_PERM_AFTER, (StatisticValueElement)GcStatisticValueElement.MAX_PERM_GEN_SIZE), -1, new Attribute[0]),
    BYTES_FREED_IN_PERM(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Freed in Perm"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Freed in Meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in perm generation"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in meta space")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were freed in the perm generation during this GC event"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were freed in the meta space during this GC event")), GcEventStatisticValueElement.BYTES_FREED_IN_PERM, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE), 45060, new Attribute[0]),
    SYSTEM_LOAD_1MIN_AVERAGE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"System load 1min average"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The system load average before the event measured over the last minute"), GcEventStatisticValueElement.SYSTEM_LOAD_1MIN_AVERAGE, GcStatisticConverter.LoadConverter, new Attribute[0]),
    SYSTEM_LOAD_5MIN_AVERAGE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"System load 5min average"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The system load average before the event measured over the last 5 minutes"), GcEventStatisticValueElement.SYSTEM_LOAD_5MIN_AVERAGE, GcStatisticConverter.LoadConverter, new Attribute[0]),
    SYSTEM_LOAD_15MIN_AVERAGE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"System load 15min average"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The system load average before the event measured over the last 15 minutes"), GcEventStatisticValueElement.SYSTEM_LOAD_15MIN_AVERAGE, GcStatisticConverter.LoadConverter, new Attribute[0]),
    SYSTEM_LOAD_AVERAGE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"System load average"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The system load average before the event (usually measured over the last 1/5/15 minutes)"), GcEventStatisticValueElement.SYSTEM_LOAD_AVERAGE, GcStatisticConverter.LoadConverter, SYSTEM_LOAD_1MIN_AVERAGE, SYSTEM_LOAD_5MIN_AVERAGE, SYSTEM_LOAD_15MIN_AVERAGE),
    VIRTUAL_CPU_UTILIZATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Host CPU utilization (virtualized)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The host CPU utilization before the event (usually measured over the last 1/5/15 minutes)"), GcEventStatisticValueElement.VIRTUAL_CPU_UTILIZATION, GcStatisticConverter.LoadConverter, new Attribute[0]),
    CLEAR_SOFTREFS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Forced clearing of soft references"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether soft references are cleared"), GcEventStatisticValueElement.CLEAR_SOFTREFS, GcStatisticConverter.BooleanTypeConverter, 16384, new Attribute[0]),
    NR_OF_UNLOADED_CLASSES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Unloaded classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of classes that were unloaded by this GC event"), GcEventStatisticValueElement.NR_OF_UNLOADED_CLASSES, GcStatisticConverter.NrOfUnloadedClassesConverter, 47108, new Attribute[0]),
    ALLOWED_NON_PERM_DEAD_SPACE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Allowed dead space in heap gens"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The dead space that is allowed during this GC event in the Java heap space"), GcEventStatisticValueElement.ALLOWED_NON_PERM_DEAD_SPACE, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    USED_NON_PERM_DEAD_SPACE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used dead space in heap gens"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The dead space that is used during this GC event in the Java heap space"), GcEventStatisticValueElement.USED_NON_PERM_DEAD_SPACE, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    ALLOWED_PERM_DEAD_SPACE(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Allowed dead space in perm gen"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Allowed dead space in meta space")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The dead space that is allowed during this GC event in the permanent generation"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The dead space that is allowed during this GC event in the meta space")), GcEventStatisticValueElement.ALLOWED_PERM_DEAD_SPACE, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    USED_PERM_DEAD_SPACE(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used dead space in perm gen"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used dead space in meta space")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The dead space that is used during this GC event in the permanent generation"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The dead space that is used during this GC event in the meta space")), GcEventStatisticValueElement.USED_PERM_DEAD_SPACE, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    PHASE_1_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phase 1 (marking) duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the first phase of the mark-and-compact\nalgorithm: marking all live objects"), GcEventStatisticValueElement.PHASE_1_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    PHASE_1_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phase 1 (marking) CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the first phase of the mark-and-compact\nalgorithm: marking all live objects"), GcEventStatisticValueElement.PHASE_1_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    PHASE_2_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phase 2 (address calculation) duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the second phase of the mark-and-compact\nalgorithm: calculating new addresses"), GcEventStatisticValueElement.PHASE_2_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    PHASE_2_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phase 2 (address calculation) CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the second phase of the mark-and-compact\nalgorithm: calculating new addresses"), GcEventStatisticValueElement.PHASE_2_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    PHASE_3_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phase 3 (updating pointers) duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the third phase of the mark-and-compact\nalgorithm: updating pointers"), GcEventStatisticValueElement.PHASE_3_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    PHASE_3_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phase 3 (updating pointers) CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the third phase of the mark-and-compact\nalgorithm: updating pointers"), GcEventStatisticValueElement.PHASE_3_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    PHASE_4_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phase 4 (moving objects) duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the fourth phase of the mark-and-compact\nalgorithm: moving objects"), GcEventStatisticValueElement.PHASE_4_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    PHASE_4_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Phase 4 (moving objects) CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the fourth phase of the mark-and-compact\nalgorithm: moving objects"), GcEventStatisticValueElement.PHASE_4_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    NR_OF_PARALLEL_COMPACT_THREADS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Parallel compact threads"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of threads that were used for the parallel compact step of this GC event"), GcEventStatisticValueElement.NR_OF_PARALLEL_COMPACT_THREADS, GcStatisticConverter.NrOfThreadsConverter, new Attribute[0]),
    SUCCESSFUL_STEALS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Successful steal operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of successful steal operations performed by any of the parallel garbage\ncollection threads.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The work items of a parallel garbage collection are stored in work queues per thread.\nIf the work queue of a thread becomes empty, it will try to \"steal\" some work from\nthe queue of another thread. This may succeed or fail depending on the filling level\nof the other queue."), GcEventStatisticValueElement.SUCCESSFUL_STEALS, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfSuccessfulStealOperations.PROTOTYPE, 47108), new Attribute[0]),
    FAILED_STEALS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Failed steal operations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of failed steal operations performed by any of the parallel garbage\ncollection threads.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The work items of a parallel garbage collection are stored in work queues per thread.\nIf the work queue of a thread becomes empty, it will try to \"steal\" some work from\nthe queue of another thread. This may succeed or fail depending on the filling level\nof the other queue."), GcEventStatisticValueElement.FAILED_STEALS, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfFailedStealOperations.PROTOTYPE, 47108), new Attribute[0]),
    FAILED_STEALS_WITH_YIELD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Failed steals and yields"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of failed steal operations performed by any of the parallel garbage\ncollection threads that led to a yield.\n\nThe work items of a parallel garbage collection are stored in work queues per thread.\nIf the work queue of a thread becomes empty, it will try to \"steal\" some work from\nthe queue of another thread. This may succeed or fail depending on the filling level\nof the other queue. If a steal operation failed it may cause the thread to yield."), GcEventStatisticValueElement.FAILED_STEALS_WITH_YIELD, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfYieldingStealOperations.PROTOTYPE, 47108), new Attribute[0]),
    IS_PROMOTION_FAILED(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Promotion failed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Did the promotion fail?"), GcEventStatisticValueElement.IS_PROMOTION_FAILED, GcStatisticConverter.BooleanTypeConverter, 16384, new Attribute[0]),
    PLABSIZE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Size of to-space PLAB (per thread)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The size of the per thread promotion local allocation buffer (PLAB) in bytes.\nTo achieve fast allocation even with several parallel threads, thread local\nallocation buffers are used. Each thread can then allocate in its own region\nwithout any additional locking."), GcEventStatisticValueElement.PLABSIZE, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    AGE_SIZES(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Sizes by age"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Object sizes by age"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The overall sizes of (alive) objects with the given age before the GC"), GcEventStatisticValueElement.AGE_SIZES, (GcStatisticConverter)new GcStatisticConverter.EventConverterBase(NrOfBytesByAge.class){

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcStatistic gcStatistic, int eventId) {
            assert (element.getType() == 3);
            GcEventBase event = gcStatistic.getEvents()[eventId];
            return new NrOfBytesByAge(element.getArrayValue(event));
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcEventStatisticValue value, GcEventStatisticValue total) {
            assert (element.getType() == 3);
            return new NrOfBytesByAge((long[])value.getElementValue(element));
        }
    }, new SubAttributesGetter(){

        @Override
        public Attribute<ObjectPair<GcStatistic, Integer>>[] getSubAttributes(ObjectPair<GcStatistic, Integer> event) {
            int distributionSize = ((AmountByAge)AGE_SIZES.getValue(event)).getDistribution().length;
            Attribute[] result = new Attribute[distributionSize];
            for (int i = 0; i < distributionSize; ++i) {
                result[i] = GcEventAttribute.createAgeDistrSubAttr(AGE_SIZES, false, i, I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Size of objects of age {0}", (Object[])new Object[]{i + 1}));
            }
            return result;
        }
    }),
    AGE_COUNTS(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Objects by age"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Number of objects by age"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of (alive) objects with the given age before the GC"), GcEventStatisticValueElement.AGE_COUNTS, (GcStatisticConverter)new GcStatisticConverter.EventConverterBase(NrOfObjectsByAge.class){

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcStatistic gcStatistic, int eventId) {
            assert (element.getType() == 3);
            GcEventBase event = gcStatistic.getEvents()[eventId];
            return new NrOfObjectsByAge(element.getArrayValue(event));
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcEventStatisticValue value, GcEventStatisticValue total) {
            assert (element.getType() == 3);
            return new NrOfObjectsByAge((long[])value.getElementValue(element));
        }
    }, new SubAttributesGetter(){

        @Override
        public Attribute<ObjectPair<GcStatistic, Integer>>[] getSubAttributes(ObjectPair<GcStatistic, Integer> event) {
            int distributionSize = ((AmountByAge)AGE_COUNTS.getValue(event)).getDistribution().length;
            Attribute[] result = new Attribute[distributionSize];
            for (int i = 0; i < distributionSize; ++i) {
                result[i] = GcEventAttribute.createAgeDistrSubAttr(AGE_COUNTS, true, i, I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Number of objects of age {0}", (Object[])new Object[]{i + 1}));
            }
            return result;
        }
    }),
    NR_OF_PARALLEL_GC_THREADS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Parallel threads"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of threads that were used for the parallel new GC"), GcEventStatisticValueElement.NR_OF_PARALLEL_GC_THREADS, GcStatisticConverter.NrOfThreadsConverter, 2048, new Attribute[0]),
    SUCCESSFUL_OVERFLOW_REFILLS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Successful overflow refills"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of successful steal operations targeting the global overflow list\nperformed by any of the parallel garbage collection threads.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The work items of a parallel garbage collection are stored in work queues per\nthread. If the work queue of a thread becomes full, all remaining work will\nbe pushed onto a global overflow queue. Worker threads may refill their work\nqueues from the global overflow queue. This will fail when the overflow queue\nis empty."), GcEventStatisticValueElement.SUCCESSFUL_OVERFLOW_REFILLS, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfSuccessfulOverflowRefills.PROTOTYPE, 47108), new Attribute[0]),
    SUCCESSFUL_OVERFLOW_REFILL_OBJECTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Number of objects from overflow refills"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects successfully refilled from the global overflow list\nperformed by any of the parallel garbage collection threads.\n\nThe work items of a parallel garbage collection are stored in work queues per\nthread. If the work queue of a thread becomes full, all remaining work will\nbe pushed onto a global overflow queue. Worker threads may refill their work\nqueues from the global overflow queue. To reduce the contention of the\noverflow queue, several objects may be \"stolen\" at once from the overflow queue."), GcEventStatisticValueElement.SUCCESSFUL_OVERFLOW_REFILL_OBJECTS, GcStatisticConverter.NrOfObjectsConverter, new Attribute[0]),
    FAILED_OVERFLOW_REFILLS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Failed overflow refills"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of failed steal operations targeting the global overflow list\nperformed by any of the parallel garbage collection threads.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The work items of a parallel garbage collection are stored in work queues per\nthread. If the work queue of a thread becomes full, all remaining work will\nbe pushed onto a global overflow queue. Worker threads may refill their work\nqueues from the global overflow queue. This will fail when the overflow queue\nis empty."), GcEventStatisticValueElement.FAILED_OVERFLOW_REFILLS, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfFailedOverflowRefills.PROTOTYPE, 47108), new Attribute[0]),
    NR_OF_CARDS_CLEANED(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cleaned cards"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of cleaned cards"), GcEventStatisticValueElement.NR_OF_CARDS_CLEANED, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfCleanedCards.PROTOTYPE, 47108), new Attribute[0]),
    IS_REMARKING_PARALLEL(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Remarking was parallel"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether the remarking used more than one thread."), GcEventStatisticValueElement.IS_REMARKING_PARALLEL, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    NR_OF_THREADS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Parallel threads"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of parallel threads that were used"), GcEventStatisticValueElement.NR_OF_THREADS, GcStatisticConverter.NrOfThreadsConverter, new Attribute[0]),
    IS_REFERENCE_PROCESSING_PARALLEL(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Reference processing was parallel"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether the processing of Reference objects (e.g. SoftReference objects) used more than one thread"), GcEventStatisticValueElement.IS_REFERENCE_PROCESSING_PARALLEL, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    NR_OF_NON_ARRAY_CLASSES_UNLOADED(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-array classes unloaded"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of unloaded non-array classes"), GcEventStatisticValueElement.NR_OF_NON_ARRAY_CLASSES_UNLOADED, GcStatisticConverter.NrOfUnloadedClassesConverter, new Attribute[0]),
    NR_OF_ARRAY_CLASSES_UNLOADED(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Array classes unloaded"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of unloaded array classes"), GcEventStatisticValueElement.NR_OF_ARRAY_CLASSES_UNLOADED, GcStatisticConverter.NrOfUnloadedArrayClassesConverter, new Attribute[0]),
    REMARKING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Remarking duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the remarking phase"), GcEventStatisticValueElement.REMARKING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    REMARKING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Remarking CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by the remarking phase"), GcEventStatisticValueElement.REMARKING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    CLASS_UNLOADING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Class unloading duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the class unloading"), GcEventStatisticValueElement.CLASS_UNLOADING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    CLASS_UNLOADING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Class unloading CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by the class unloading"), GcEventStatisticValueElement.CLASS_UNLOADING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    SYMBOL_UNLOADING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Symbol unloading duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the symbol unloading"), GcEventStatisticValueElement.SYMBOL_UNLOADING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    SYMBOL_UNLOADING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Symbol unloading CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by the symbol unloading"), GcEventStatisticValueElement.SYMBOL_UNLOADING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    REFERENCE_HANDLING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Reference processing duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of handling Reference objects"), GcEventStatisticValueElement.REFERENCE_HANDLING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    REFERENCE_HANDLING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Reference processing CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by handling Reference objects"), GcEventStatisticValueElement.REFERENCE_HANDLING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    REFERENCE_ENQUEUEING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Reference enqueueing duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of enqueueing Reference objects"), GcEventStatisticValueElement.REFERENCE_ENQUEUEING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    REFERENCE_ENQUEUEING_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Reference enqueueing CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed by enqueueing Reference objects"), GcEventStatisticValueElement.REFERENCE_ENQUEUEING_CPU_TIME, GcStatisticConverter.CpuTimeConverter, new Attribute[0]),
    COMMITTED_BYTES_IN_OLD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed in 'old generation'"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the old generation"), GcEventStatisticValueElement.COMMITTED_BYTES_IN_OLD, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_OLD_GEN_SIZE), 12288, new Attribute[0]),
    PERM_COMMITTED(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed in 'perm generation'"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed in 'meta space'")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of committed bytes in the permanent generation."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of committed bytes in the meta space.")), GcEventStatisticValueElement.PERM_COMMITTED, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE), 12288, new Attribute[0]),
    NR_OF_NON_ARRAY_CLASSES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-array classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of non-array classes during this GC event"), GcEventStatisticValueElement.NR_OF_NON_ARRAY_CLASSES, GcStatisticConverter.NrOfClassesConverter, 12288, new Attribute[0]),
    NR_OF_ARRAY_CLASSES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Array classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of array classes during this GC event"), GcEventStatisticValueElement.NR_OF_ARRAY_CLASSES, GcStatisticConverter.NrOfClassesConverter, 12288, new Attribute[0]),
    IS_MARKING_CONCURRENT(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Marking was concurrent"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether the marking phase was concurrent"), GcEventStatisticValueElement.IS_MARKING_CONCURRENT, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    IS_PARALLEL(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Is parallel"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether the event used more than one thread."), GcEventStatisticValueElement.IS_PARALLEL, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    NR_OF_GC_THREADS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Parallel threads"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of parallel threads that were used for the event"), GcEventStatisticValueElement.NR_OF_GC_THREADS, GcStatisticConverter.NrOfThreadsConverter, 2048, new Attribute[0]),
    IS_SWEEPING_CONCURRENT(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Sweeping was concurrent"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether the sweeping phase was concurrent"), GcEventStatisticValueElement.IS_SWEEPING_CONCURRENT, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    BYTES_PROMOTED_TO_OLD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Concurrently promoted to old gen"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes concurrently promoted to old generation"), GcEventStatisticValueElement.BYTES_PROMOTED_TO_OLD, GcStatisticConverter.NrOfBytesConverter, new Attribute[0]),
    BYTES_ALLOCATED_IN_OLD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Concurrently allocated in old gen"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes concurrently allocated in old generation"), GcEventStatisticValueElement.BYTES_ALLOCATED_IN_OLD, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    BYTES_ALLOCATED_IN_PERM(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Concurrently allocated in perm gen"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Concurrently allocated in meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes concurrently allocated in perm generation"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes concurrently allocated in meta space")), GcEventStatisticValueElement.BYTES_ALLOCATED_IN_PERM, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    NR_OF_NON_COALESCABLE_BLOCKS_IN_OLD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-coalescable blocks in old gen"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of free blocks in the old generation that cannot be coalesced.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Some parts of the free space may be reused for other purposes, e.g. storing\nintermediate garbage collection results. These blocks may become reusable\nat a later point in time but currently prevent coalescing of free blocks."), GcEventStatisticValueElement.NR_OF_NON_COALESCABLE_BLOCKS_IN_OLD, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfNonCoalescableBlocks.PROTOTYPE, 47104), new Attribute[0]),
    SIZE_OF_NON_COALESCABLE_BLOCKS_IN_OLD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-coalescable bytes in old gen"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes occupied by free blocks in the old generation that cannot be coalesced.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Some parts of the free space may be reused for other purposes, e.g. storing\nintermediate garbage collection results. These blocks may become reusable\nat a later point in time but currently prevent coalescing of free blocks."), GcEventStatisticValueElement.SIZE_OF_NON_COALESCABLE_BLOCKS_IN_OLD, GcStatisticConverter.NrOfBytesConverter, new Attribute[0]),
    NR_OF_NON_COALESCABLE_BLOCKS_IN_PERM(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-coalescable blocks in perm gen"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-coalescable blocks in meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of free blocks in the perm generation that cannot be coalesced.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Some parts of the free space may be reused for other purposes, e.g. storing\nintermediate garbage collection results. These blocks may become reusable\nat a later point in time but currently prevent coalescing of free blocks."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of free blocks in the meta space that cannot be coalesced.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Some parts of the free space may be reused for other purposes, e.g. storing\nintermediate garbage collection results. These blocks may become reusable\nat a later point in time but currently prevent coalescing of free blocks.")), GcEventStatisticValueElement.NR_OF_NON_COALESCABLE_BLOCKS_IN_PERM, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfNonCoalescableBlocks.PROTOTYPE, 47104), -1, new Attribute[0]),
    SIZE_OF_NON_COALESCABLE_BLOCKS_IN_PERM(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-coalescable bytes in perm gen"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-coalescable bytes in meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes occupied by free blocks in the perm generation that cannot be coalesced.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Some parts of the free space may be reused for other purposes, e.g. storing\nintermediate garbage collection results. These blocks may become reusable\nat a later point in time but currently prevent coalescing of free blocks."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes occupied by free blocks in the meta space that cannot be coalesced.") + "\n\n" + I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Some parts of the free space may be reused for other purposes, e.g. storing\nintermediate garbage collection results. These blocks may become reusable\nat a later point in time but currently prevent coalescing of free blocks.")), GcEventStatisticValueElement.SIZE_OF_NON_COALESCABLE_BLOCKS_IN_PERM, GcStatisticConverter.NrOfBytesConverter, 47104, new Attribute[0]),
    CLEARED_BITMAP_BYTES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes cleared in marking bitmap"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes cleared in the marking bitmap."), GcEventStatisticValueElement.CLEARED_BITMAP_BYTES, GcStatisticConverter.NrOfBytesConverter, new Attribute[0]),
    YIELD_COUNT(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Number of yields"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of times the concurrent bitmap clearing yielded to allow mutator activity."), GcEventStatisticValueElement.YIELD_COUNT, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfYields.PROTOTYPE, 47108), new Attribute[0]),
    BYTES_IN_NON_PERM_BEFORE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used in Java heap before event"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the Java heap before the event."), GcEventStatisticValueElement.BYTES_IN_NON_PERM_BEFORE, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE), 12288, new Attribute[0]),
    LIVE_BYTES_IN_NON_PERM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Live in Java heap before event"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were alive in the Java heap."), GcEventStatisticValueElement.LIVE_BYTES_IN_NON_PERM, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE), 12288, new Attribute[0]),
    GARBAGE_IN_NON_PERM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Garbage in Java heap before event"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of used bytes in the Java heap that were not alive."), GcEventStatisticValueElement.GARBAGE_IN_NON_PERM, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE), 12288, new Attribute[0]),
    GARBAGE_REGION_COUNT(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Garbage only heap regions"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of heap regions that were found to contain only garbage."), GcEventStatisticValueElement.GARBAGE_REGION_COUNT, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfGarbageOnlyHeapRegions.PROTOTYPE, 47108), new Attribute[0]),
    BYTES_IN_GARBAGE_REGIONS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes in garbage only heap regions"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes in heap regions that were found to contain only garbage."), GcEventStatisticValueElement.BYTES_IN_GARBAGE_REGIONS, GcStatisticConverter.NrOfBytesConverter, 47108, new Attribute[0]),
    REGIONS_TO_BE_CLEANED_COUNT(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Heap regions to be cleaned"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of heap regions to be cleaned up."), GcEventStatisticValueElement.REGIONS_TO_BE_CLEANED_COUNT, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfHeapRegions.PROTOTYPE, 47108), new Attribute[0]),
    BYTES_FREED_IN_NON_PERM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Freed in Java heap by this GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes freed in the Java heap during concurrent cleanup."), GcEventStatisticValueElement.BYTES_FREED_IN_NON_PERM, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE), 45060, new Attribute[0]),
    NR_OF_ITERATIONS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Heap iterations"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The the number of iterations done in the counting phase."), GcEventStatisticValueElement.NR_OF_ITERATIONS, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfIterations.PROTOTYPE, 14340), new Attribute[0]),
    HAS_MARKING_STACK_OVERFLOW_OCCURRED(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Marking stack overflow occurred"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether a marking stack overflow has occurred."), GcEventStatisticValueElement.HAS_MARKING_STACK_OVERFLOW_OCCURRED, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    NR_OF_BYTES_SCANNED(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes Scanned"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes scanned during the final marking phase."), GcEventStatisticValueElement.NR_OF_BYTES_SCANNED_DURING_FINAL_MARKING, GcStatisticConverter.NrOfBytesConverter, new Attribute[0]),
    NR_OF_OBJECT_REFERENCES_REACHED(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Object References Reached"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of object references encountered during the final marking phase."), GcEventStatisticValueElement.NR_OF_OBJECT_REFERENCES_REACHED_DURING_FINAL_MARKING, GcStatisticConverter.NrOfObjectsConverter, new Attribute[0]),
    IS_PART_OF_PARTIAL_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Part of partial GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether the initial marking was done as part of a partial garbage collection or stand-alone."), GcEventStatisticValueElement.IS_PART_OF_PARTIAL_GC, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    BYTES_IN_NON_PERM_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used in Java heap after event"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the Java heap after the event."), GcEventStatisticValueElement.BYTES_IN_NON_PERM_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_NON_PERM_AFTER_GC), 12288, new Attribute[0]),
    COMMITTED_BYTES_IN_NON_PERM_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed in Java heap after event"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of committed bytes in the Java heap after the event."), GcEventStatisticValueElement.COMMITTED_BYTES_IN_NON_PERM_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE), 12288, new Attribute[0]),
    HAS_INITIAL_MARKING(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Includes initial marking"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates whether an initial marking was done as part of this incremental garbage collection."), GcEventStatisticValueElement.HAS_INITIAL_MARKING, GcStatisticConverter.BooleanTypeConverter, new Attribute[0]),
    YOUNG_PLABSIZE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Size of to-space PLAB (per thread)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The size in bytes of the per thread promotion local allocation buffer (PLAB)\nfor young objects.\nTo achieve fast allocation even with several parallel threads, thread local\nallocation buffers are used. Each thread can then allocate in its own region\nwithout any additional locking."), GcEventStatisticValueElement.YOUNG_PLABSIZE, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    OLD_PLABSIZE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Size of 'old' space PLAB (per thread)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The size in bytes of the per thread promotion local allocation buffer (PLAB)\nfor old objects.\nTo achieve fast allocation even with several parallel threads, thread local\nallocation buffers are used. Each thread can then allocate in its own region\nwithout any additional locking."), GcEventStatisticValueElement.OLD_PLABSIZE, GcStatisticConverter.NrOfBytesConverter, 14336, new Attribute[0]),
    CONCURRENT_MARKING_ROOT_SCAN_WAIT_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Root Scan Wait duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration spent waiting for the root scanning phase of the concurrent\nmarking to finish."), GcEventStatisticValueElement.CONCURRENT_MARKING_ROOT_SCAN_WAIT_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    PARALLEL_ROOT_SCANNING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Root Scanning"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the parallel root scanning."), GcEventStatisticValueElement.PARALLEL_ROOT_SCANNING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    PARALLEL_SNAPSHOT_AT_THE_BEGINNING_FILTERING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"SATB Filtering"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the parallel snapshot-at-the-beginning filtering."), GcEventStatisticValueElement.PARALLEL_SNAPSHOT_AT_THE_BEGINNING_FILTERING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    PARALLEL_REMEMBERED_SET_UPDATING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Remembered Set Updating"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the parallel updating of the remembered set."), GcEventStatisticValueElement.PARALLEL_REMEMBERED_SET_UPDATING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    BUFFERS_PROCESSED_DURING_PARALLEL_REMEMBERED_SET_UPDATING(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Remembered Set Update Buffers"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of buffers processed parallelly during the remembered set update."), GcEventStatisticValueElement.BUFFERS_PROCESSED_DURING_PARALLEL_REMEMBERED_SET_UPDATING, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfBuffers.PROTOTYPE, 14340), new Attribute[0]),
    PARALLEL_REMEMBERED_SET_SCANNING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Remembered Set Scanning"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the parallel scanning of the remembered set."), GcEventStatisticValueElement.PARALLEL_REMEMBERED_SET_SCANNING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    PARALLEL_OBJECT_COPYING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Object Copying"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the parallel copying of objects."), GcEventStatisticValueElement.PARALLEL_OBJECT_COPYING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    CARD_TABLE_CLEARING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Card Table Clearing"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of clearing the card table."), GcEventStatisticValueElement.CARD_TABLE_CLEARING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    COLLECTION_SET_CHOOSING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Collection Set Choosing"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of choosing the collection set."), GcEventStatisticValueElement.COLLECTION_SET_CHOOSING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    COLLECTION_SET_FREEING_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Collection Set Freeing"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of freeing the collection set."), GcEventStatisticValueElement.COLLECTION_SET_FREEING_DURATION, GcStatisticConverter.ElapsedTimeConverter, new Attribute[0]),
    HAS_ONLY_YOUNG_REGIONS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Collected Regions"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Indicates the type of heap regions that were collected as part of this incremental garbage collection."), GcEventStatisticValueElement.HAS_ONLY_YOUNG_REGIONS, GcStatisticConverter.YoungMixedConverter, new Attribute[0]),
    SCANNED_ROOT_REGIONS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Scanned root regions"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of root regions that were scanned during this phase."), GcEventStatisticValueElement.SCANNED_ROOT_REGION_COUNT, (GcStatisticConverter)new GcStatisticConverter.PrototypeConverter(NrOfHeapRegions.PROTOTYPE, 14336), new Attribute[0]);

    private static final GcEventAttribute[] attribute4Element;
    private GcStatisticConverter converter;
    private GcEventStatisticValueElement element;
    private SessionAwareString longDescription;
    private SessionAwareString shortDescription;
    private SessionAwareString columnName;
    private Attribute<ObjectPair<GcStatistic, Integer>>[] subAttributes;
    private SubAttributesGetter subAttrGetter;
    private int columnFlags;

    private GcEventAttribute(String shortDescription, String longDescription, GcEventStatisticValueElement element, GcStatisticConverter converter, Attribute<?> ... subAttributes) {
        this(null, shortDescription, longDescription, element, converter, subAttributes);
    }

    private GcEventAttribute(String columnName, String shortDescription, String longDescription, GcEventStatisticValueElement element, GcStatisticConverter converter, Attribute<?> ... subAttributes) {
        this.element = element;
        this.converter = converter;
        this.longDescription = GcEventAttribute.getString(longDescription);
        this.shortDescription = GcEventAttribute.getString(shortDescription);
        this.columnName = GcEventAttribute.getString(columnName);
        this.subAttributes = subAttributes;
        this.subAttrGetter = null;
        this.columnFlags = -1;
    }

    private GcEventAttribute(String columnName, String shortDescription, String longDescription, GcEventStatisticValueElement element, GcStatisticConverter converter, SubAttributesGetter subAttrGetter) {
        this.element = element;
        this.converter = converter;
        this.longDescription = GcEventAttribute.getString(longDescription);
        this.shortDescription = GcEventAttribute.getString(shortDescription);
        this.columnName = GcEventAttribute.getString(columnName);
        this.subAttributes = null;
        this.subAttrGetter = subAttrGetter;
        this.columnFlags = -1;
    }

    private GcEventAttribute(String shortDescription, String longDescription, GcEventStatisticValueElement element, GcStatisticConverter converter, int columnFlags, Attribute<?> ... subAttributes) {
        this(null, shortDescription, longDescription, element, converter, columnFlags, subAttributes);
    }

    private GcEventAttribute(String columnName, String shortDescription, String longDescription, GcEventStatisticValueElement element, GcStatisticConverter converter, int columnFlags, Attribute<?> ... subAttributes) {
        this.element = element;
        this.converter = converter;
        this.longDescription = GcEventAttribute.getString(longDescription);
        this.shortDescription = GcEventAttribute.getString(shortDescription);
        this.columnName = GcEventAttribute.getString(columnName);
        this.subAttributes = subAttributes;
        this.subAttrGetter = null;
        this.columnFlags = columnFlags;
    }

    private GcEventAttribute(SessionAwareString columnName, SessionAwareString shortDescription, SessionAwareString longDescription, GcEventStatisticValueElement element, GcStatisticConverter converter, int columnFlags, Attribute<?> ... subAttributes) {
        this.element = element;
        this.converter = converter;
        this.longDescription = longDescription;
        this.shortDescription = shortDescription;
        this.columnName = columnName;
        this.subAttributes = subAttributes;
        this.subAttrGetter = null;
        this.columnFlags = columnFlags;
    }

    private GcEventAttribute(String columnName, String shortDescription, String longDescription, GcEventStatisticValueElement element, GcStatisticConverter converter, SubAttributesGetter subAttrGetter, int columnFlags) {
        this.element = element;
        this.converter = converter;
        this.longDescription = GcEventAttribute.getString(longDescription);
        this.shortDescription = GcEventAttribute.getString(shortDescription);
        this.columnName = GcEventAttribute.getString(columnName);
        this.subAttributes = null;
        this.subAttrGetter = subAttrGetter;
        this.columnFlags = columnFlags;
    }

    @Override
    public Class<? extends ProviderEntry> getType() {
        return this.converter.getType();
    }

    @Override
    public Class<? extends ProviderEntry> getBaseType() {
        return TypedTimeSeriesProvider.getBaseAxis(this.converter.getType());
    }

    @Override
    public int getColumnFlags() {
        if (this.columnFlags == -1) {
            return this.converter.getColumnFlags();
        }
        return this.columnFlags;
    }

    @Override
    public ProviderEntry getValue(ObjectPair<GcStatistic, Integer> event) {
        return this.converter.getValue(this.element, (GcStatistic)event.getFirst(), (Integer)event.getSecond());
    }

    public ProviderEntry getValue(GcEventStatisticValue value, GcEventStatisticValue total) {
        return this.converter.getValue(this.element, value, total);
    }

    @Override
    public String getColumnName(ProfilingSession session) {
        return this.columnName == null ? this.getShortDescription(session) : this.columnName.getValue(session);
    }

    @Override
    public String getShortDescription(ProfilingSession session) {
        return this.shortDescription.getValue(session);
    }

    @Override
    public String getLongDescription(ProfilingSession session) {
        return this.longDescription.getValue(session);
    }

    @Override
    public GcEventStatisticValueElement getValueElement() {
        return this.element;
    }

    @Override
    public boolean hasSubAttributes() {
        return this.subAttrGetter != null || this.subAttributes != null && this.subAttributes.length > 0;
    }

    @Override
    public Attribute<ObjectPair<GcStatistic, Integer>>[] getSubAttributes(ObjectPair<GcStatistic, Integer> event) {
        if (this.subAttrGetter != null) {
            return this.subAttrGetter.getSubAttributes(event);
        }
        if (this.subAttributes == null) {
            return new GcEventAttribute[0];
        }
        return this.subAttributes;
    }

    @Override
    public int getTimeSeriesIndex() {
        throw new UnsupportedOperationException("Time series index is not mapped in GC Event attributes");
    }

    public static ProviderEntry getEntry(GcEventStatisticValueElement element, GcEventStatisticValue value, GcEventStatisticValue total) {
        return attribute4Element[element.ordinal()].getValue(value, total);
    }

    public static GcEventAttribute getAttributeForElement(GcEventStatisticValueElement element) {
        return attribute4Element[element.ordinal()];
    }

    private static Attribute<ObjectPair<GcStatistic, Integer>> createAgeDistrSubAttr(final GcEventAttribute distributionAttr, final boolean number, final int pos, final String text) {
        return new Attribute<ObjectPair<GcStatistic, Integer>>(){

            @Override
            public ProviderEntry getValue(ObjectPair<GcStatistic, Integer> event) {
                AmountByAge distributionEntry = (AmountByAge)distributionAttr.getValue(event);
                long[] ageData = distributionEntry.getDistribution();
                return number ? NrOfObjects.PROTOTYPE.create(ageData[pos], distributionEntry.getMax()) : NrOfBytes.PROTOTYPE.create(ageData[pos], distributionEntry.getMax());
            }

            @Override
            public String getShortDescription(ProfilingSession session) {
                return text;
            }

            @Override
            public String getLongDescription(ProfilingSession session) {
                return text;
            }

            @Override
            public String getColumnName(ProfilingSession session) {
                return text;
            }

            @Override
            public boolean hasSubAttributes() {
                return false;
            }

            @Override
            public Attribute<ObjectPair<GcStatistic, Integer>>[] getSubAttributes(ObjectPair<GcStatistic, Integer> event) {
                return null;
            }

            @Override
            public Class<? extends ProviderEntry> getType() {
                return number ? NrOfObjects.class : NrOfBytes.class;
            }

            @Override
            public Class<? extends ProviderEntry> getBaseType() {
                return number ? NrOfObjects.class : NrOfBytes.class;
            }

            @Override
            public int getColumnFlags() {
                return 0;
            }

            @Override
            public int getTimeSeriesIndex() {
                return -1;
            }

            @Override
            public StatisticValueElement getValueElement() {
                return distributionAttr.getValueElement();
            }
        };
    }

    private static SessionAwareString getString(final String value) {
        if (value == null) {
            return null;
        }
        return new SessionAwareString(){

            @Override
            public String getValue(ProfilingSession session) {
                return value;
            }
        };
    }

    static {
        attribute4Element = new GcEventAttribute[GcEventStatisticValueElement.values().length];
        GcEventAttribute[] gcEventAttributeArray = GcEventAttribute.values();
        int n = gcEventAttributeArray.length;
        for (int i = 0; i < n; ++i) {
            GcEventAttribute attribute;
            GcEventAttribute.attribute4Element[attribute.element.ordinal()] = attribute = gcEventAttributeArray[i];
        }
    }

    private static interface SubAttributesGetter {
        public Attribute<ObjectPair<GcStatistic, Integer>>[] getSubAttributes(ObjectPair<GcStatistic, Integer> var1);
    }
}

