/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.presentation.typed.gc.GcEventAttribute;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GcEventAttributeGroup {
    private static final GcEventAttributeGroup BASE_ATTRIBUTES = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Basic Attributes"), new GcEventAttribute[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP});
    private static final GcEventAttributeGroup DURATION_BASE_ATTRIBUTES = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Basic Attributes"), new GcEventAttribute[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS});
    private static final GcEventAttributeGroup CMS_ABORTED = new GcEventAttributeGroup(GcEventType.CMS_ABORTED.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.FULL_GCS_SINCE_CONC_GC, GcEventAttribute.FULL_GCS_BEFORE_COMPACTION, GcEventAttribute.IS_USER_REQUESTED, GcEventAttribute.IS_INCREMENTAL_COLLECTION_WILL_FAIL, GcEventAttribute.IS_CLEAR_SOFTREFS});
    private static final GcEventAttributeGroup PARALLEL_SMALL_GC_FORCED_FULL_GC = new GcEventAttributeGroup(GcEventType.PARALLEL_GC_SMALL_FORCED_FULL_GC.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.AVERAGE_PROMOTED});
    private static final GcEventAttributeGroup SKIPPED_GC = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Skipped GC"), new GcEventAttribute[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.SKIPPED_REASON});
    private static final GcEventAttributeGroup YOUNG_GEN_PROMOTION_FAILURE = new GcEventAttributeGroup(GcEventType.YOUNG_GEN_PROMOTION_FAILURE.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.PROMOTION_FAILURE_NR, GcEventAttribute.CAUSING_OBJECT_TYPE, GcEventAttribute.CAUSING_OBJECT_SIZE, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, GcEventAttribute.FAILED_PROMOTIONS_COUNT, GcEventAttribute.FIRST_PROMOTION_FAILURE_TIMESTAMP});
    private static final GcEventAttributeGroup GENERATIONAL = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Generational"), new GcEventAttribute[]{GcEventAttribute.BYTES_IN_EDEN_BEFORE_AND_AFTER, GcEventAttribute.BYTES_IN_EDEN_BEFORE, GcEventAttribute.BYTES_IN_EDEN_AFTER, GcEventAttribute.FREED_IN_EDEN, GcEventAttribute.BYTES_IN_FROM_BEFORE_AND_AFTER, GcEventAttribute.BYTES_IN_FROM_BEFORE, GcEventAttribute.BYTES_IN_FROM_AFTER, GcEventAttribute.FREED_IN_FROM, GcEventAttribute.BYTES_IN_TO_BEFORE_AND_AFTER, GcEventAttribute.BYTES_IN_TO_BEFORE, GcEventAttribute.BYTES_IN_TO_AFTER, GcEventAttribute.FREED_IN_TO, GcEventAttribute.BYTES_IN_YOUNG_BEFORE_AND_AFTER, GcEventAttribute.BYTES_IN_YOUNG_BEFORE, GcEventAttribute.BYTES_IN_YOUNG_AFTER, GcEventAttribute.FREED_IN_YOUNG, GcEventAttribute.BYTES_IN_OLD_BEFORE_AND_AFTER, GcEventAttribute.BYTES_IN_OLD_BEFORE, GcEventAttribute.BYTES_IN_OLD_AFTER, GcEventAttribute.BYTES_FREED_IN_OLD, GcEventAttribute.BYTES_IN_PERM_BEFORE_AND_AFTER, GcEventAttribute.BYTES_IN_PERM_BEFORE, GcEventAttribute.BYTES_IN_PERM_AFTER, GcEventAttribute.BYTES_FREED_IN_PERM, GcEventAttribute.SYSTEM_LOAD_AVERAGE, GcEventAttribute.VIRTUAL_CPU_UTILIZATION});
    private static final GcEventAttributeGroup GENERATIONAL_WITH_BASE = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Generational"), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL});
    private static final GcEventAttributeGroup CLASSUNLOADING_PHASE1 = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Classunloading phase 1"), new GcEventAttribute[]{GcEventAttribute.NR_OF_NON_ARRAY_CLASSES_BEFORE, GcEventAttribute.NR_OF_NON_ARRAY_CLASSES_AFTER, GcEventAttribute.NR_OF_UNLOADED_NON_ARRAY_CLASSES, GcEventAttribute.NR_OF_ARRAY_CLASSES_BEFORE, GcEventAttribute.NR_OF_ARRAY_CLASSES_AFTER, GcEventAttribute.NR_OF_UNLOADED_ARRAY_CLASSES});
    private static final GcEventAttributeGroup CLASSUNLOADING_PHASE1_WITH_BASE = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Classunloading phase 2"), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, CLASSUNLOADING_PHASE1});
    private static final GcEventAttributeGroup CLASSUNLOADING_PHASE2 = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Classunloading phase 2"), new GcEventAttribute[]{GcEventAttribute.METASPACE_USED_BEFORE_AND_AFTER, GcEventAttribute.METASPACE_USED_BEFORE, GcEventAttribute.METASPACE_USED_AFTER, GcEventAttribute.METASPACE_FREED, GcEventAttribute.METASPACE_COMMITTED_BEFORE, GcEventAttribute.METASPACE_COMMITTED_AFTER, GcEventAttribute.CLASS_SPACE_USED_BEFORE_AND_AFTER, GcEventAttribute.CLASS_SPACE_USED_BEFORE, GcEventAttribute.CLASS_SPACE_USED_AFTER, GcEventAttribute.CLASS_SPACE_FREED, GcEventAttribute.CLASS_SPACE_COMMITTED_BEFORE, GcEventAttribute.CLASS_SPACE_COMMITTED_AFTER});
    private static final GcEventAttributeGroup CLASSUNLOADING_PHASE2_WITH_BASE = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Classunloading phase 2"), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, CLASSUNLOADING_PHASE2});
    private static final GcEventAttributeGroup REFERENCE_HANDLING = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Reference Handling"), new GcEventAttribute[]{GcEventAttribute.SOFT_REFERENCE_MAX_LAST_USED_TIME, GcEventAttribute.SOFT_REFERENCES_FOUND, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_BY_POLICY, GcEventAttribute.SOFT_REFERENCES_CLEARED, GcEventAttribute.SOFT_REFERENCES_NOT_CLEARED, GcEventAttribute.SOFT_REFERENCES_LIVE, GcEventAttribute.SOFT_REFERENCES_ENQUEUED, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, GcEventAttribute.WEAK_REFERENCES_FOUND, GcEventAttribute.WEAK_REFERENCES_CLEARED, GcEventAttribute.WEAK_REFERENCES_LIVE, GcEventAttribute.WEAK_REFERENCES_ENQUEUED, GcEventAttribute.FINAL_REFERENCES_FOUND, GcEventAttribute.FINAL_REFERENCES_LIVE, GcEventAttribute.FINAL_REFERENCES_ENQUEUED, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, GcEventAttribute.PHANTOM_REFERENCES_FOUND, GcEventAttribute.PHANTOM_REFERENCES_LIVE, GcEventAttribute.PHANTOM_REFERENCES_ENQUEUED, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, GcEventAttribute.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING, GcEventAttribute.SOFT_REFERENCE_HANDLING_DURATION, GcEventAttribute.SOFT_REFERENCE_HANDLING_CPU_TIME, GcEventAttribute.WEAK_REFERENCE_HANDLING_DURATION, GcEventAttribute.WEAK_REFERENCE_HANDLING_CPU_TIME, GcEventAttribute.FINAL_REFERENCE_HANDLING_DURATION, GcEventAttribute.FINAL_REFERENCE_HANDLING_CPU_TIME, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_DURATION, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_CPU_TIME, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_DURATION, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_CPU_TIME, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_DURATION, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_CPU_TIME, GcEventAttribute.JNIWEAK_REFS_ALIVE, GcEventAttribute.JNIWEAK_REFS_DEADS});
    private static final GcEventAttributeGroup REFERENCE_HANDLING_WITH_BASE = new GcEventAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Reference Handling"), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, REFERENCE_HANDLING});
    private static final GcEventAttributeGroup PARALLEL_GC_MARK_SWEEP = new GcEventAttributeGroup(GcEventType.PARALLEL_GC_MARK_SWEEP.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.CLEAR_SOFTREFS, GcEventAttribute.NR_OF_UNLOADED_CLASSES, GcEventAttribute.ALLOWED_NON_PERM_DEAD_SPACE, GcEventAttribute.USED_NON_PERM_DEAD_SPACE, GcEventAttribute.ALLOWED_PERM_DEAD_SPACE, GcEventAttribute.USED_PERM_DEAD_SPACE, GcEventAttribute.PHASE_1_DURATION, GcEventAttribute.PHASE_1_CPU_TIME, GcEventAttribute.PHASE_2_DURATION, GcEventAttribute.PHASE_2_CPU_TIME, GcEventAttribute.PHASE_3_DURATION, GcEventAttribute.PHASE_3_CPU_TIME, GcEventAttribute.PHASE_4_DURATION, GcEventAttribute.PHASE_4_CPU_TIME});
    private static final GcEventAttributeGroup PARALLEL_GC_MARK_SWEEP_WITH_BASE = new GcEventAttributeGroup(GcEventType.PARALLEL_GC_MARK_SWEEP.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL, PARALLEL_GC_MARK_SWEEP});
    private static final GcEventAttributeGroup PARALLEL_GC_PARALLEL_COMPACT = new GcEventAttributeGroup(GcEventType.PARALLEL_GC_PARALLEL_COMPACT.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.CLEAR_SOFTREFS, GcEventAttribute.NR_OF_UNLOADED_CLASSES, GcEventAttribute.NR_OF_PARALLEL_COMPACT_THREADS, GcEventAttribute.SUCCESSFUL_STEALS, GcEventAttribute.FAILED_STEALS, GcEventAttribute.FAILED_STEALS_WITH_YIELD, GcEventAttribute.ALLOWED_NON_PERM_DEAD_SPACE, GcEventAttribute.USED_NON_PERM_DEAD_SPACE, GcEventAttribute.ALLOWED_PERM_DEAD_SPACE, GcEventAttribute.USED_PERM_DEAD_SPACE, GcEventAttribute.PHASE_1_DURATION, GcEventAttribute.PHASE_1_CPU_TIME, GcEventAttribute.PHASE_2_DURATION, GcEventAttribute.PHASE_2_CPU_TIME, GcEventAttribute.PHASE_3_DURATION, GcEventAttribute.PHASE_3_CPU_TIME, GcEventAttribute.PHASE_4_DURATION, GcEventAttribute.PHASE_4_CPU_TIME});
    private static final GcEventAttributeGroup PARALLEL_GC_PARALLEL_COMPACT_WITH_BASE = new GcEventAttributeGroup(GcEventType.PARALLEL_GC_PARALLEL_COMPACT.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL, PARALLEL_GC_PARALLEL_COMPACT});
    private static final GcEventAttributeGroup PARALLEL_GC_SCAVENGE = new GcEventAttributeGroup(GcEventType.PARALLEL_GC_SCAVENGE.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_PROMOTION_FAILED, GcEventAttribute.SUCCESSFUL_STEALS, GcEventAttribute.FAILED_STEALS, GcEventAttribute.FAILED_STEALS_WITH_YIELD, GcEventAttribute.PLABSIZE, GcEventAttribute.AGE_COUNTS, GcEventAttribute.AGE_SIZES});
    private static final GcEventAttributeGroup PARALLEL_GC_SCAVENGE_WITH_BASE = new GcEventAttributeGroup(GcEventType.PARALLEL_GC_SCAVENGE.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL, PARALLEL_GC_SCAVENGE});
    private static final GcEventAttributeGroup TENURED_GC = new GcEventAttributeGroup(GcEventType.TENURED_GC.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.CLEAR_SOFTREFS, GcEventAttribute.NR_OF_UNLOADED_CLASSES, GcEventAttribute.ALLOWED_NON_PERM_DEAD_SPACE, GcEventAttribute.USED_NON_PERM_DEAD_SPACE, GcEventAttribute.ALLOWED_PERM_DEAD_SPACE, GcEventAttribute.USED_PERM_DEAD_SPACE, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, GcEventAttribute.PHASE_1_DURATION, GcEventAttribute.PHASE_1_CPU_TIME, GcEventAttribute.PHASE_2_DURATION, GcEventAttribute.PHASE_2_CPU_TIME, GcEventAttribute.PHASE_3_DURATION, GcEventAttribute.PHASE_3_CPU_TIME, GcEventAttribute.PHASE_4_DURATION, GcEventAttribute.PHASE_4_CPU_TIME});
    private static final GcEventAttributeGroup TENURED_GC_WITH_BASE = new GcEventAttributeGroup(GcEventType.TENURED_GC.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL, TENURED_GC});
    private static final GcEventAttributeGroup PARALLEL_NEW_GC = new GcEventAttributeGroup(GcEventType.PARALLEL_NEW_GC.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.NR_OF_PARALLEL_GC_THREADS, GcEventAttribute.CLEAR_SOFTREFS, GcEventAttribute.IS_PROMOTION_FAILED, GcEventAttribute.SUCCESSFUL_STEALS, GcEventAttribute.FAILED_STEALS, GcEventAttribute.FAILED_STEALS_WITH_YIELD, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILLS, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILL_OBJECTS, GcEventAttribute.FAILED_OVERFLOW_REFILLS, GcEventAttribute.PLABSIZE, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, GcEventAttribute.AGE_COUNTS, GcEventAttribute.AGE_SIZES});
    private static final GcEventAttributeGroup PARALLEL_NEW_GC_WITH_BASE = new GcEventAttributeGroup(GcEventType.PARALLEL_NEW_GC.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL, PARALLEL_NEW_GC});
    private static final GcEventAttributeGroup SERIAL_NEW_GC = new GcEventAttributeGroup(GcEventType.SERIAL_NEW_GC.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_PROMOTION_FAILED, GcEventAttribute.CLEAR_SOFTREFS, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, GcEventAttribute.AGE_COUNTS, GcEventAttribute.AGE_SIZES});
    private static final GcEventAttributeGroup SERIAL_NEW_GC_WITH_BASE = new GcEventAttributeGroup(GcEventType.SERIAL_NEW_GC.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL, SERIAL_NEW_GC});
    private static final GcEventAttributeGroup CMS_ABORTABLE_PRECLEANING = new GcEventAttributeGroup(GcEventType.CMS_ABORTABLE_PRECLEANING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.NR_OF_CARDS_CLEANED, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, GcEventAttribute.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING});
    private static final GcEventAttributeGroup CMS_ABORTABLE_PRECLEANING_WITH_BASE = new GcEventAttributeGroup(GcEventType.CMS_ABORTABLE_PRECLEANING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, CMS_ABORTABLE_PRECLEANING});
    private static final GcEventAttributeGroup CMS_PRECLEANING = new GcEventAttributeGroup(GcEventType.CMS_PRECLEANING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.NR_OF_CARDS_CLEANED, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, GcEventAttribute.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING});
    private static final GcEventAttributeGroup CMS_PRECLEANING_WITH_BASE = new GcEventAttributeGroup(GcEventType.CMS_PRECLEANING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, CMS_PRECLEANING});
    private static final GcEventAttributeGroup CMS_FINAL_MARKING = new GcEventAttributeGroup(GcEventType.CMS_FINAL_MARKING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_REMARKING_PARALLEL, GcEventAttribute.NR_OF_THREADS, GcEventAttribute.IS_REFERENCE_PROCESSING_PARALLEL, GcEventAttribute.NR_OF_NON_ARRAY_CLASSES_UNLOADED, GcEventAttribute.NR_OF_ARRAY_CLASSES_UNLOADED, GcEventAttribute.SUCCESSFUL_STEALS, GcEventAttribute.FAILED_STEALS, GcEventAttribute.FAILED_STEALS_WITH_YIELD, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILLS, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILL_OBJECTS, GcEventAttribute.FAILED_OVERFLOW_REFILLS, GcEventAttribute.REMARKING_DURATION, GcEventAttribute.REMARKING_CPU_TIME, GcEventAttribute.CLASS_UNLOADING_DURATION, GcEventAttribute.CLASS_UNLOADING_CPU_TIME, GcEventAttribute.SYMBOL_UNLOADING_DURATION, GcEventAttribute.SYMBOL_UNLOADING_CPU_TIME, GcEventAttribute.REFERENCE_HANDLING_DURATION, GcEventAttribute.REFERENCE_HANDLING_CPU_TIME, GcEventAttribute.REFERENCE_ENQUEUEING_DURATION, GcEventAttribute.REFERENCE_ENQUEUEING_CPU_TIME, GcEventAttribute.SYSTEM_LOAD_AVERAGE, GcEventAttribute.VIRTUAL_CPU_UTILIZATION});
    private static final GcEventAttributeGroup CMS_FINAL_MARKING_WITH_BASE = new GcEventAttributeGroup(GcEventType.CMS_FINAL_MARKING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, CMS_FINAL_MARKING});
    private static final GcEventAttributeGroup CMS_MARKING = new GcEventAttributeGroup(GcEventType.CMS_MARKING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_MARKING_CONCURRENT, GcEventAttribute.IS_PARALLEL, GcEventAttribute.NR_OF_GC_THREADS, GcEventAttribute.SUCCESSFUL_STEALS, GcEventAttribute.FAILED_STEALS, GcEventAttribute.FAILED_STEALS_WITH_YIELD, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILLS, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILL_OBJECTS, GcEventAttribute.FAILED_OVERFLOW_REFILLS});
    private static final GcEventAttributeGroup CMS_MARKING_WITH_BASE = new GcEventAttributeGroup(GcEventType.CMS_MARKING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, CMS_MARKING});
    private static final GcEventAttributeGroup CMS_INITIAL_MARKING = new GcEventAttributeGroup(GcEventType.CMS_INITIAL_MARKING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_PARALLEL, GcEventAttribute.NR_OF_THREADS, GcEventAttribute.BYTES_IN_OLD, GcEventAttribute.COMMITTED_BYTES_IN_OLD, GcEventAttribute.PERM_USED, GcEventAttribute.PERM_COMMITTED, GcEventAttribute.NR_OF_NON_ARRAY_CLASSES, GcEventAttribute.NR_OF_ARRAY_CLASSES, GcEventAttribute.SYSTEM_LOAD_AVERAGE, GcEventAttribute.VIRTUAL_CPU_UTILIZATION});
    private static final GcEventAttributeGroup CMS_INITIAL_MARKING_WITH_BASE = new GcEventAttributeGroup(GcEventType.CMS_INITIAL_MARKING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, CMS_INITIAL_MARKING});
    private static final GcEventAttributeGroup CMS_SWEEPING = new GcEventAttributeGroup(GcEventType.CMS_SWEEPING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_SWEEPING_CONCURRENT, GcEventAttribute.BYTES_FREED_IN_OLD, GcEventAttribute.BYTES_FREED_IN_PERM, GcEventAttribute.BYTES_PROMOTED_TO_OLD, GcEventAttribute.BYTES_ALLOCATED_IN_OLD, GcEventAttribute.BYTES_ALLOCATED_IN_PERM, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, GcEventAttribute.NR_OF_NON_COALESCABLE_BLOCKS_IN_OLD, GcEventAttribute.SIZE_OF_NON_COALESCABLE_BLOCKS_IN_OLD, GcEventAttribute.NR_OF_NON_COALESCABLE_BLOCKS_IN_PERM, GcEventAttribute.SIZE_OF_NON_COALESCABLE_BLOCKS_IN_PERM});
    private static final GcEventAttributeGroup CMS_SWEEPING_WITH_BASE = new GcEventAttributeGroup(GcEventType.CMS_SWEEPING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, CMS_SWEEPING});
    private static final GcEventAttributeGroup G1_BITMAP_CLEARING_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_BITMAP_CLEARING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GcEventAttribute.CLEARED_BITMAP_BYTES, GcEventAttribute.YIELD_COUNT});
    private static final GcEventAttributeGroup G1_CLEANUP = new GcEventAttributeGroup(GcEventType.G1_CLEANUP.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_PARALLEL, GcEventAttribute.NR_OF_GC_THREADS, GcEventAttribute.BYTES_IN_NON_PERM_BEFORE, GcEventAttribute.LIVE_BYTES_IN_NON_PERM, GcEventAttribute.GARBAGE_IN_NON_PERM, GcEventAttribute.GARBAGE_REGION_COUNT, GcEventAttribute.BYTES_IN_GARBAGE_REGIONS, GcEventAttribute.SYSTEM_LOAD_AVERAGE, GcEventAttribute.VIRTUAL_CPU_UTILIZATION});
    private static final GcEventAttributeGroup G1_CLEANUP_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_CLEANUP.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, G1_CLEANUP});
    private static final GcEventAttributeGroup G1_EMPTY_REGIONS_RECLAIM = new GcEventAttributeGroup(GcEventType.G1_EMPTY_REGIONS_RECLAIM.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_PARALLEL, GcEventAttribute.NR_OF_GC_THREADS, GcEventAttribute.BYTES_IN_NON_PERM_BEFORE, GcEventAttribute.LIVE_BYTES_IN_NON_PERM, GcEventAttribute.GARBAGE_IN_NON_PERM, GcEventAttribute.GARBAGE_REGION_COUNT, GcEventAttribute.BYTES_IN_GARBAGE_REGIONS, GcEventAttribute.SYSTEM_LOAD_AVERAGE, GcEventAttribute.VIRTUAL_CPU_UTILIZATION});
    private static final GcEventAttributeGroup G1_EMPTY_REGIONS_RECLAIM_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_EMPTY_REGIONS_RECLAIM.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, G1_EMPTY_REGIONS_RECLAIM});
    private static final GcEventAttributeGroup G1_CONCURRENT_CLEANUP_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_CONCURRENT_CLEANUP.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GcEventAttribute.REGIONS_TO_BE_CLEANED_COUNT, GcEventAttribute.BYTES_FREED_IN_NON_PERM});
    private static final GcEventAttributeGroup G1_COUNTING_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_COUNTING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GcEventAttribute.NR_OF_ITERATIONS});
    private static final GcEventAttributeGroup G1_FINAL_MARKING = new GcEventAttributeGroup(GcEventType.G1_FINAL_MARKING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_REMARKING_PARALLEL, GcEventAttribute.NR_OF_THREADS, GcEventAttribute.NR_OF_BYTES_SCANNED, GcEventAttribute.NR_OF_OBJECT_REFERENCES_REACHED, GcEventAttribute.HAS_MARKING_STACK_OVERFLOW_OCCURRED, GcEventAttribute.IS_REFERENCE_PROCESSING_PARALLEL, GcEventAttribute.SUCCESSFUL_STEALS, GcEventAttribute.FAILED_STEALS, GcEventAttribute.REMARKING_DURATION, GcEventAttribute.REMARKING_CPU_TIME, GcEventAttribute.SYMBOL_UNLOADING_DURATION, GcEventAttribute.SYMBOL_UNLOADING_CPU_TIME, GcEventAttribute.REFERENCE_HANDLING_DURATION, GcEventAttribute.REFERENCE_HANDLING_CPU_TIME, GcEventAttribute.REFERENCE_ENQUEUEING_DURATION, GcEventAttribute.REFERENCE_ENQUEUEING_CPU_TIME, GcEventAttribute.SYSTEM_LOAD_AVERAGE, GcEventAttribute.VIRTUAL_CPU_UTILIZATION});
    private static final GcEventAttributeGroup G1_FINAL_MARKING_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_FINAL_MARKING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, G1_FINAL_MARKING});
    private static final GcEventAttributeGroup G1_INITIAL_MARKING = new GcEventAttributeGroup(GcEventType.G1_INITIAL_MARKING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_PARALLEL, GcEventAttribute.IS_PART_OF_PARTIAL_GC, GcEventAttribute.BYTES_IN_NON_PERM_AFTER, GcEventAttribute.COMMITTED_BYTES_IN_NON_PERM_AFTER, GcEventAttribute.NR_OF_THREADS, GcEventAttribute.SYSTEM_LOAD_AVERAGE, GcEventAttribute.VIRTUAL_CPU_UTILIZATION});
    private static final GcEventAttributeGroup G1_INITIAL_MARKING_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_INITIAL_MARKING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, G1_INITIAL_MARKING});
    private static final GcEventAttributeGroup G1_MARKING = new GcEventAttributeGroup(GcEventType.G1_MARKING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_PARALLEL, GcEventAttribute.NR_OF_THREADS, GcEventAttribute.SUCCESSFUL_STEALS, GcEventAttribute.FAILED_STEALS});
    private static final GcEventAttributeGroup G1_MARKING_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_MARKING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, G1_MARKING});
    private static final GcEventAttributeGroup G1_INCREMENTAL = new GcEventAttributeGroup(GcEventType.G1_INCREMENTAL_GC.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.NR_OF_THREADS, GcEventAttribute.IS_PROMOTION_FAILED, GcEventAttribute.HAS_INITIAL_MARKING, GcEventAttribute.HAS_ONLY_YOUNG_REGIONS, GcEventAttribute.SUCCESSFUL_STEALS, GcEventAttribute.FAILED_STEALS, GcEventAttribute.FAILED_STEALS_WITH_YIELD, GcEventAttribute.YOUNG_PLABSIZE, GcEventAttribute.OLD_PLABSIZE, GcEventAttribute.CONCURRENT_MARKING_ROOT_SCAN_WAIT_DURATION, GcEventAttribute.PARALLEL_ROOT_SCANNING_DURATION, GcEventAttribute.PARALLEL_SNAPSHOT_AT_THE_BEGINNING_FILTERING_DURATION, GcEventAttribute.PARALLEL_REMEMBERED_SET_UPDATING_DURATION, GcEventAttribute.BUFFERS_PROCESSED_DURING_PARALLEL_REMEMBERED_SET_UPDATING, GcEventAttribute.PARALLEL_REMEMBERED_SET_SCANNING_DURATION, GcEventAttribute.PARALLEL_OBJECT_COPYING_DURATION, GcEventAttribute.CARD_TABLE_CLEARING_DURATION, GcEventAttribute.COLLECTION_SET_CHOOSING_DURATION, GcEventAttribute.COLLECTION_SET_FREEING_DURATION, GcEventAttribute.REFERENCE_HANDLING_DURATION, GcEventAttribute.REFERENCE_ENQUEUEING_DURATION, GcEventAttribute.AGE_COUNTS, GcEventAttribute.AGE_SIZES});
    private static final GcEventAttributeGroup G1_INCREMENTAL_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_INCREMENTAL_GC.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL, G1_INCREMENTAL});
    private static final GcEventAttributeGroup G1_MARK_SWEEP = new GcEventAttributeGroup(GcEventType.G1_MARK_SWEEP_GC.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.ALLOWED_NON_PERM_DEAD_SPACE, GcEventAttribute.ALLOWED_PERM_DEAD_SPACE, GcEventAttribute.IS_CLEAR_SOFTREFS, GcEventAttribute.NR_OF_UNLOADED_CLASSES, GcEventAttribute.USED_NON_PERM_DEAD_SPACE, GcEventAttribute.USED_PERM_DEAD_SPACE, GcEventAttribute.PHASE_1_DURATION, GcEventAttribute.PHASE_1_CPU_TIME, GcEventAttribute.PHASE_2_DURATION, GcEventAttribute.PHASE_2_CPU_TIME, GcEventAttribute.PHASE_3_DURATION, GcEventAttribute.PHASE_3_CPU_TIME, GcEventAttribute.PHASE_4_DURATION, GcEventAttribute.PHASE_4_CPU_TIME});
    private static final GcEventAttributeGroup G1_MARK_SWEEP_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_MARK_SWEEP_GC.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL, G1_MARK_SWEEP});
    private static final GcEventAttributeGroup G1_PARALLEL_FULL = new GcEventAttributeGroup(GcEventType.G1_PARALLEL_FULL_GC.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_CLEAR_SOFTREFS, GcEventAttribute.NR_OF_THREADS, GcEventAttribute.PHASE_1_DURATION, GcEventAttribute.PHASE_1_CPU_TIME, GcEventAttribute.PHASE_2_DURATION, GcEventAttribute.PHASE_2_CPU_TIME, GcEventAttribute.PHASE_3_DURATION, GcEventAttribute.PHASE_3_CPU_TIME, GcEventAttribute.PHASE_4_DURATION, GcEventAttribute.PHASE_4_CPU_TIME});
    private static final GcEventAttributeGroup G1_PARALLEL_FULL_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_PARALLEL_FULL_GC.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, GENERATIONAL, G1_PARALLEL_FULL});
    private static final GcEventAttributeGroup G1_ROOT_SCANNING = new GcEventAttributeGroup(GcEventType.G1_ROOT_SCANNING.getShortDescrDisplay(), new GcEventAttribute[]{GcEventAttribute.IS_PARALLEL, GcEventAttribute.NR_OF_THREADS, GcEventAttribute.SCANNED_ROOT_REGIONS});
    private static final GcEventAttributeGroup G1_ROOT_SCANNING_WITH_BASE = new GcEventAttributeGroup(GcEventType.G1_ROOT_SCANNING.getShortDescrDisplay(), new Object[]{GcEventAttribute.EVENT_TYPE, GcEventAttribute.TIME_STAMP, GcEventAttribute.DURATION, GcEventAttribute.CPU_TIME, GcEventAttribute.PAGE_FAULTS, GcEventAttribute.MAJOR_PAGE_FAULTS, GcEventAttribute.MINOR_PAGE_FAULTS, G1_ROOT_SCANNING});
    private String description;
    private GroupOrAttribute[] entries;

    public static final GcEventAttributeGroup getGroup(GcEventType eventType, ProfilingSession session, GcType gcType) {
        GcEventAttributeGroup result = null;
        switch (eventType) {
            case PARALLEL_GC_SCAVENGE: {
                result = PARALLEL_GC_SCAVENGE_WITH_BASE;
                break;
            }
            case SKIPPED_PARALLEL_GC_SCAVENGE: {
                result = SKIPPED_GC;
                break;
            }
            case PARALLEL_GC_MARK_SWEEP: {
                result = PARALLEL_GC_MARK_SWEEP_WITH_BASE;
                break;
            }
            case SKIPPED_PARALLEL_GC_MARK_SWEEP: {
                result = SKIPPED_GC;
                break;
            }
            case PARALLEL_GC_PARALLEL_COMPACT: {
                result = PARALLEL_GC_PARALLEL_COMPACT_WITH_BASE;
                break;
            }
            case PARALLEL_GC_SMALL_FORCED_FULL_GC: {
                result = PARALLEL_SMALL_GC_FORCED_FULL_GC;
                break;
            }
            case SKIPPED_PARALLEL_GC_PARALLEL_COMPACT: {
                result = SKIPPED_GC;
                break;
            }
            case SERIAL_NEW_GC: {
                result = SERIAL_NEW_GC_WITH_BASE;
                break;
            }
            case SKIPPED_SERIAL_NEW_GC: {
                result = SKIPPED_GC;
                break;
            }
            case PARALLEL_NEW_GC: {
                result = PARALLEL_NEW_GC_WITH_BASE;
                break;
            }
            case SKIPPED_PARALLEL_NEW_GC: {
                result = SKIPPED_GC;
                break;
            }
            case TENURED_GC: {
                result = TENURED_GC_WITH_BASE;
                break;
            }
            case SKIPPED_TENURED_GC: {
                result = SKIPPED_GC;
                break;
            }
            case YOUNG_GEN_REF_HANDLING: {
                result = REFERENCE_HANDLING_WITH_BASE;
                break;
            }
            case ALL_GEN_REF_HANDLING: {
                result = REFERENCE_HANDLING_WITH_BASE;
                break;
            }
            case OLD_GEN_REF_HANDLING: {
                result = REFERENCE_HANDLING_WITH_BASE;
                break;
            }
            case CMS_INITIAL_MARKING: {
                result = CMS_INITIAL_MARKING_WITH_BASE;
                break;
            }
            case CMS_MARKING: {
                result = CMS_MARKING_WITH_BASE;
                break;
            }
            case CMS_PRECLEANING: {
                result = CMS_PRECLEANING_WITH_BASE;
                break;
            }
            case CMS_ABORTABLE_PRECLEANING: {
                result = CMS_ABORTABLE_PRECLEANING_WITH_BASE;
                break;
            }
            case CMS_FINAL_MARKING: {
                result = CMS_FINAL_MARKING_WITH_BASE;
                break;
            }
            case CMS_SWEEPING: {
                result = CMS_SWEEPING_WITH_BASE;
                break;
            }
            case CMS_ABORTED: {
                result = CMS_ABORTED;
                break;
            }
            case YOUNG_GEN_PROMOTION_FAILURE: {
                result = YOUNG_GEN_PROMOTION_FAILURE;
                break;
            }
            case G1_INCREMENTAL_GC: {
                result = G1_INCREMENTAL_WITH_BASE;
                break;
            }
            case SKIPPED_G1_INCREMENTAL_GC: {
                result = SKIPPED_GC;
                break;
            }
            case G1_MARK_SWEEP_GC: {
                result = G1_MARK_SWEEP_WITH_BASE;
                break;
            }
            case SKIPPED_G1_MARK_SWEEP_GC: {
                result = SKIPPED_GC;
                break;
            }
            case G1_PARALLEL_FULL_GC: {
                result = G1_PARALLEL_FULL_WITH_BASE;
                break;
            }
            case SKIPPED_G1_PARALLEL_FULL_GC: {
                result = SKIPPED_GC;
                break;
            }
            case G1_INITIAL_MARKING: {
                result = G1_INITIAL_MARKING_WITH_BASE;
                break;
            }
            case G1_MARKING: {
                result = G1_MARKING_WITH_BASE;
                break;
            }
            case G1_FINAL_MARKING: {
                result = G1_FINAL_MARKING_WITH_BASE;
                break;
            }
            case G1_COUNTING: {
                result = G1_COUNTING_WITH_BASE;
                break;
            }
            case G1_CLEANUP: {
                result = G1_CLEANUP_WITH_BASE;
                break;
            }
            case G1_CONCURRENT_CLEANUP: {
                result = G1_CONCURRENT_CLEANUP_WITH_BASE;
                break;
            }
            case G1_BITMAP_CLEARING: {
                result = G1_BITMAP_CLEARING_WITH_BASE;
                break;
            }
            case G1_MARKING_ABORTED: {
                result = BASE_ATTRIBUTES;
                break;
            }
            case G1_ROOT_SCANNING: {
                result = G1_ROOT_SCANNING_WITH_BASE;
                break;
            }
            case PARTIAL_REF_HANDLING: {
                result = REFERENCE_HANDLING_WITH_BASE;
                break;
            }
            case CLASSUNLOADING_PHASE1: {
                result = CLASSUNLOADING_PHASE1_WITH_BASE;
                break;
            }
            case CLASSUNLOADING_PHASE2: {
                result = CLASSUNLOADING_PHASE2_WITH_BASE;
                break;
            }
            case G1_EMPTY_REGIONS_RECLAIM: {
                result = G1_EMPTY_REGIONS_RECLAIM_WITH_BASE;
            }
        }
        assert (result != null);
        if (GcEventAttributeGroup.hasNonApplicables(result, session, gcType, eventType)) {
            result = GcEventAttributeGroup.removeNonApplicables(result, session, gcType, eventType);
            assert (result != null);
        }
        return result;
    }

    private static boolean hasNonApplicables(GcEventAttributeGroup group, ProfilingSession session, GcType gcType, GcEventType evType) {
        return Arrays.stream(group.getEntries()).anyMatch(a -> a.isAttribute() ? !a.getAttribute().isApplicable(session, gcType, evType) : GcEventAttributeGroup.hasNonApplicables(a.getGroup(), session, gcType, evType));
    }

    private static final GcEventAttributeGroup removeNonApplicables(GcEventAttributeGroup group, ProfilingSession session, GcType type, GcEventType evType) {
        Object[] filtered = Arrays.stream(group.getEntries()).filter(a -> a.isAttribute() && a.getAttribute().isApplicable(session, type, evType) || a.isGroup()).map(a -> a.isAttribute() ? a.getAttribute() : GcEventAttributeGroup.removeNonApplicables(a.getGroup(), session, type, evType)).filter(g -> g != null).toArray(Object[]::new);
        return filtered.length == 0 ? null : new GcEventAttributeGroup(group.description, filtered);
    }

    public static final GcEventAttributeGroup getGroupForGenerationalEvents(ProfilingSession session, GcType type) {
        GcEventAttributeGroup res = GENERATIONAL_WITH_BASE;
        if (GcEventAttributeGroup.hasNonApplicables(res, session, type, null)) {
            res = GcEventAttributeGroup.removeNonApplicables(res, session, type, null);
        }
        return res;
    }

    public static final GcEventAttributeGroup getGroupForReferenceHandling(ProfilingSession session, GcType type) {
        GcEventAttributeGroup res = REFERENCE_HANDLING_WITH_BASE;
        if (GcEventAttributeGroup.hasNonApplicables(res, session, type, null)) {
            res = GcEventAttributeGroup.removeNonApplicables(res, session, type, null);
        }
        return res;
    }

    public static final GcEventType[] getEventTypes(GcType type) {
        ArrayList<GcEventType> result = new ArrayList<GcEventType>();
        result.add(GcEventType.YOUNG_GEN_REF_HANDLING);
        result.add(GcEventType.ALL_GEN_REF_HANDLING);
        result.add(GcEventType.YOUNG_GEN_PROMOTION_FAILURE);
        result.add(GcEventType.CLASSUNLOADING_PHASE1);
        result.add(GcEventType.CLASSUNLOADING_PHASE2);
        switch (type) {
            case PARALLEL_GC: {
                result.add(GcEventType.PARALLEL_GC_MARK_SWEEP);
                result.add(GcEventType.PARALLEL_GC_SCAVENGE);
                result.add(GcEventType.PARALLEL_GC_SMALL_FORCED_FULL_GC);
                result.add(GcEventType.SKIPPED_PARALLEL_GC_MARK_SWEEP);
                result.add(GcEventType.SKIPPED_PARALLEL_GC_SCAVENGE);
                break;
            }
            case PARALLEL_OLD_GC: {
                result.add(GcEventType.PARALLEL_GC_PARALLEL_COMPACT);
                result.add(GcEventType.PARALLEL_GC_SCAVENGE);
                result.add(GcEventType.PARALLEL_GC_SMALL_FORCED_FULL_GC);
                result.add(GcEventType.SKIPPED_PARALLEL_GC_PARALLEL_COMPACT);
                result.add(GcEventType.SKIPPED_PARALLEL_GC_SCAVENGE);
                break;
            }
            case SERIAL_GC: {
                result.add(GcEventType.SERIAL_NEW_GC);
                result.add(GcEventType.TENURED_GC);
                result.add(GcEventType.SKIPPED_SERIAL_NEW_GC);
                result.add(GcEventType.SKIPPED_TENURED_GC);
                break;
            }
            case PARALLEL_NEW_GC: {
                result.add(GcEventType.PARALLEL_NEW_GC);
                result.add(GcEventType.TENURED_GC);
                result.add(GcEventType.SKIPPED_PARALLEL_NEW_GC);
                result.add(GcEventType.SKIPPED_TENURED_GC);
                break;
            }
            case CONC_MARK_SWEEP_GC: {
                result.add(GcEventType.OLD_GEN_REF_HANDLING);
                result.add(GcEventType.CMS_INITIAL_MARKING);
                result.add(GcEventType.CMS_MARKING);
                result.add(GcEventType.CMS_PRECLEANING);
                result.add(GcEventType.CMS_ABORTABLE_PRECLEANING);
                result.add(GcEventType.CMS_FINAL_MARKING);
                result.add(GcEventType.CMS_SWEEPING);
                result.add(GcEventType.CMS_ABORTED);
                result.add(GcEventType.PARALLEL_NEW_GC);
                result.add(GcEventType.SERIAL_NEW_GC);
                result.add(GcEventType.TENURED_GC);
                result.add(GcEventType.SKIPPED_PARALLEL_NEW_GC);
                result.add(GcEventType.SKIPPED_SERIAL_NEW_GC);
                break;
            }
            case GARBAGE_FIRST_GC: {
                result.remove(GcEventType.YOUNG_GEN_REF_HANDLING);
                result.add(GcEventType.PARTIAL_REF_HANDLING);
                result.add(GcEventType.G1_INCREMENTAL_GC);
                result.add(GcEventType.G1_MARK_SWEEP_GC);
                result.add(GcEventType.G1_PARALLEL_FULL_GC);
                result.add(GcEventType.G1_INITIAL_MARKING);
                result.add(GcEventType.G1_MARKING);
                result.add(GcEventType.G1_FINAL_MARKING);
                result.add(GcEventType.G1_COUNTING);
                result.add(GcEventType.G1_CLEANUP);
                result.add(GcEventType.G1_CONCURRENT_CLEANUP);
                result.add(GcEventType.G1_BITMAP_CLEARING);
                result.add(GcEventType.G1_MARKING_ABORTED);
                result.add(GcEventType.G1_ROOT_SCANNING);
                result.add(GcEventType.SKIPPED_G1_INCREMENTAL_GC);
                result.add(GcEventType.SKIPPED_G1_MARK_SWEEP_GC);
                result.add(GcEventType.SKIPPED_G1_PARALLEL_FULL_GC);
                break;
            }
        }
        return result.toArray(new GcEventType[result.size()]);
    }

    public GcEventAttributeGroup(String description, Object[] entries) {
        this.description = description;
        this.entries = new GroupOrAttribute[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            Object entry = entries[i];
            this.entries[i] = entry instanceof GcEventAttribute ? new GroupOrAttribute((GcEventAttribute)entry) : new GroupOrAttribute((GcEventAttributeGroup)entry);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public GroupOrAttribute[] getEntries() {
        return this.entries;
    }

    public List<GcEventAttribute> getAttributes() {
        ArrayList<GcEventAttribute> result = new ArrayList<GcEventAttribute>();
        GcEventAttributeGroup.getAttributes(result, this.getEntries());
        return result;
    }

    public List<GcEventStatisticValueElement> getValueElements() {
        List<GcEventAttribute> attributes = this.getAttributes();
        ArrayList<GcEventStatisticValueElement> result = new ArrayList<GcEventStatisticValueElement>(attributes.size());
        for (GcEventAttribute attribute : attributes) {
            result.add(attribute.getValueElement());
        }
        return result;
    }

    private static final void getAttributes(Collection<GcEventAttribute> attributes, GroupOrAttribute[] entries) {
        for (GroupOrAttribute entry : entries) {
            if (entry.isAttribute()) {
                attributes.add(entry.getAttribute());
                continue;
            }
            GcEventAttributeGroup.getAttributes(attributes, entry.getGroup().getEntries());
        }
    }

    public class GroupOrAttribute {
        private GcEventAttributeGroup group;
        private GcEventAttribute attribute;

        protected GroupOrAttribute(GcEventAttributeGroup group) {
            this.group = group;
            this.attribute = null;
        }

        GroupOrAttribute(GcEventAttribute attribute) {
            this.attribute = attribute;
            this.group = null;
        }

        public boolean isGroup() {
            return this.group != null;
        }

        public boolean isAttribute() {
            return this.attribute != null;
        }

        public GcEventAttribute getAttribute() {
            return this.attribute;
        }

        public GcEventAttributeGroup getGroup() {
            return this.group;
        }
    }
}

