/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesProvider;
import com.sap.jvm.profiling.presentation.typed.entries.NormalString;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.gc.Attribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcStatisticConverter;
import com.sap.jvm.profiling.presentation.typed.gc.MetaSpaceAwareString;
import com.sap.jvm.profiling.presentation.typed.gc.SessionAwareString;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.StatisticValueElement;

public enum GcStatisticAttribute implements Attribute<GcStatistic>
{
    GC_NR(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"GC No."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The GC number"), GcStatisticValueElement.GC_NR, GcStatisticConverter.NormalGcIdConverter, new GcStatisticAttribute[0]),
    GC_TYPE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"GC Type"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The type of the GC, i.e. full, partial or concurrent"), GcStatisticValueElement.GC_TYPE, GcStatisticConverter.GcTypeEntryConverter, new GcStatisticAttribute[0]),
    MAX_PAUSE_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Max Pause Time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum pause time of the current GC"), 10, GcStatisticValueElement.MAX_PAUSE_TIME, GcStatisticConverter.ElapsedTimeMaxConverter, 12292, new GcStatisticAttribute[0]),
    DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The duration of the current GC"), 1, GcStatisticValueElement.DURATION, GcStatisticConverter.ElapsedTimeMaxConverter, new GcStatisticAttribute[0]),
    CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The CPU time consumed during the current GC"), 0, GcStatisticValueElement.CPU_TIME, GcStatisticConverter.CpuTimeConverter, new GcStatisticAttribute[0]),
    GC_CAUSE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cause"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The reason why the GC was triggered"), GcStatisticValueElement.GC_CAUSE, GcStatisticConverter.GcCauseEntryConverter, new GcStatisticAttribute[0]),
    TIME_STAMP(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Start time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The start time of the GC"), GcStatisticValueElement.TIME_STAMP, GcStatisticConverter.TimestampConverter, new GcStatisticAttribute[0]),
    CONCURRENCY_GROUP(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Ongoing concurrent GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The concurrency group that this GC is part of."), GcStatisticValueElement.CONCURRENCY_GROUP, new GcStatisticConverter(){
        private final String toolTip = I18n._s((String)"This GC was running in parallel to the concurrent GC of group {0}");
        private final String toolTipConc = I18n._s((String)"This GC was concurrent to the other GCs in group {0}");
        private final NormalString emptyString = new NormalString("");

        @Override
        public ProviderEntry getValue(GcStatisticValueElement element, GcStatisticValue value, GcStatisticValue total) {
            return this.getValue(value);
        }

        @Override
        public ProviderEntry getValue(GcStatisticValueElement element, GcStatistic gcStatistic) {
            return this.emptyString;
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcStatistic gcStatistic, int eventId) {
            return this.emptyString;
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcEventStatisticValue value, GcEventStatisticValue total) {
            return this.getValue(value.getGcStatisticData());
        }

        @Override
        public Class<? extends ProviderEntry> getType() {
            return NormalString.class;
        }

        @Override
        public int getColumnFlags() {
            return 0;
        }

        private ProviderEntry getValue(GcStatisticValue value) {
            int phase = value.getConcurrencyGroup();
            boolean isLast = value.getElementValue(GcStatisticValueElement.GC_TYPE) == 3L;
            return this.getEntry(phase, isLast);
        }

        private ProviderEntry getEntry(int group, boolean isLast) {
            if (group == 0) {
                return this.emptyString;
            }
            char marker = isLast ? (char)'\u23a6' : '\u23a5';
            String tooltip = isLast ? I18n.formatText((String)this.toolTipConc, (Object[])new Object[]{group}) : I18n.formatText((String)this.toolTip, (Object[])new Object[]{group});
            return new NormalString("  " + marker + "   " + group, tooltip);
        }
    }, new GcStatisticAttribute[0]),
    TIME_SINCE_LAST_CONC_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Time since last conc GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The time since the end of the last concurrent GC"), 716, GcStatisticValueElement.TIME_SINCE_LAST_CONC_GC, GcStatisticConverter.PositiveElapsedTimeConverter, new GcStatisticAttribute[0]),
    GC_ALGORITHM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"GC Algorithm"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The configured GC algorithm"), GcStatisticValueElement.GC_ALGORITHM, (GcStatisticConverter)new GcStatisticConverter.ConverterBase(NormalString.class){

        @Override
        public ProviderEntry getValue(long value) {
            GcType type = GcType.values()[(int)value];
            return new NormalString(type.getDisplayName(), type.getParametersText());
        }
    }, new GcStatisticAttribute[0]),
    PROMOTION_FAILURES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Promotion Failures"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of objects that could not be promoted to the old generation during this GC"), GcStatisticValueElement.PROMOTION_FAILURES, GcStatisticConverter.NrOfPromotionFailuresConverter, new GcStatisticAttribute[0]),
    FORCED_SOFT_REF_CLEAR(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Forced clearing of SoftRefs"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"Was the flag to clear all soft references during the GC set?"), GcStatisticValueElement.FORCED_SOFT_REF_CLEAR, GcStatisticConverter.BooleanTypeConverter, new GcStatisticAttribute[0]),
    NR_OF_UNLOADED_CLASSES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Unloaded classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of classes that were unloaded by this GC"), GcStatisticValueElement.NR_OF_UNLOADED_CLASSES, GcStatisticConverter.NrOfUnloadedClassesConverter, new GcStatisticAttribute[0]),
    NR_OF_ARRAY_CLASSES_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Array classes after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of array classes that existed after the GC"), 5, GcStatisticValueElement.NR_OF_ARRAY_CLASSES_AFTER_GC, GcStatisticConverter.NrOfClassesConverter, 14336, new GcStatisticAttribute[0]),
    NR_OF_ARRAY_CLASSES_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Array classes before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of array classes that existed before the GC"), 6, GcStatisticValueElement.NR_OF_ARRAY_CLASSES_BEFORE_GC, GcStatisticConverter.NrOfClassesConverter, 14336, new GcStatisticAttribute[0]),
    NR_OF_NON_ARRAY_CLASSES_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-array classes after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of non-array classes that existed after the GC"), 7, GcStatisticValueElement.NR_OF_NON_ARRAY_CLASSES_AFTER_GC, GcStatisticConverter.NrOfClassesConverter, 14336, new GcStatisticAttribute[0]),
    NR_OF_NON_ARRAY_CLASSES_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-array classes before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of non-array classes that existed before the GC"), 8, GcStatisticValueElement.NR_OF_NON_ARRAY_CLASSES_BEFORE_GC, GcStatisticConverter.NrOfClassesConverter, 14336, new GcStatisticAttribute[0]),
    ALLOCATION_GOAL(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Allocation goal"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes the failed allocation tried to get"), 9, GcStatisticValueElement.ALLOCATION_GOAL, GcStatisticConverter.NrOfBytesConverter, new GcStatisticAttribute[0]),
    PAGE_FAULTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Page faults"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of page faults triggered during the current GC"), 2, GcStatisticValueElement.PAGE_FAULTS, GcStatisticConverter.NrOfPageFaultsConverter, new GcStatisticAttribute[0]),
    MAJOR_PAGE_FAULTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Major page faults"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of major page faults triggered during the current GC"), 3, GcStatisticValueElement.MAJOR_PAGE_FAULTS, GcStatisticConverter.NrOfMajorPageFaultsConverter, new GcStatisticAttribute[0]),
    MINOR_PAGE_FAULTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Minor page faults"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of minor page faults triggered during the current GC"), 4, GcStatisticValueElement.MINOR_PAGE_FAULTS, GcStatisticConverter.NrOfMinorPageFaultsConverter, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_YOUNG_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in young before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in young before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the young generation before this GC."), 38, GcStatisticValueElement.COMMITTED_BYTES_IN_YOUNG_BEFORE_GC, GcStatisticConverter.NrOfBytesConverter, 47104, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_YOUNG_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in young after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in young after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the young generation after this GC."), 37, GcStatisticValueElement.COMMITTED_BYTES_IN_YOUNG_AFTER_GC, GcStatisticConverter.NrOfBytesConverter, 47104, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_TO_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in to before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in to-space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in to-space before this GC."), 36, GcStatisticValueElement.COMMITTED_BYTES_IN_TO_BEFORE_GC, GcStatisticConverter.NrOfBytesConverter, 47104, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_TO_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in to after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in to-space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in to-space after this GC."), 35, GcStatisticValueElement.COMMITTED_BYTES_IN_TO_AFTER_GC, GcStatisticConverter.NrOfBytesConverter, 47104, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_FROM_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in from before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in from-space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in from-space before this GC."), 32, GcStatisticValueElement.COMMITTED_BYTES_IN_FROM_BEFORE_GC, GcStatisticConverter.NrOfBytesConverter, 47104, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_FROM_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in from after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in from-space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in from-space after this GC."), 31, GcStatisticValueElement.COMMITTED_BYTES_IN_FROM_AFTER_GC, GcStatisticConverter.NrOfBytesConverter, 47104, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_EDEN_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in eden before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in eden-space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in eden-space before this GC."), 30, GcStatisticValueElement.COMMITTED_BYTES_IN_EDEN_BEFORE_GC, GcStatisticConverter.NrOfBytesConverter, 47104, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_EDEN_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in eden after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in eden-space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in eden-space after this GC."), 29, GcStatisticValueElement.COMMITTED_BYTES_IN_EDEN_AFTER_GC, GcStatisticConverter.NrOfBytesConverter, 47104, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_OLD_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in old before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in old before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the old generation before this GC."), 34, GcStatisticValueElement.COMMITTED_BYTES_IN_OLD_BEFORE_GC, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_OLD_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in old after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in old after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the old generation after this GC."), 33, GcStatisticValueElement.COMMITTED_BYTES_IN_OLD_AFTER_GC, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_NON_PERM_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in heap before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in Java heap before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the Java heap before this GC."), 40, GcStatisticValueElement.COMMITTED_BYTES_IN_NON_PERM_BEFORE_GC, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_NON_PERM_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in heap after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in Java heap after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the Java heap after this GC."), 39, GcStatisticValueElement.COMMITTED_BYTES_IN_NON_PERM_AFTER_GC, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_PERM_BEFORE_GC(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in perm before GC"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in meta before GC")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in perm before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in meta before GC")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the permanent generation before this GC."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the meta space before this GC.")), 42, GcStatisticValueElement.COMMITTED_BYTES_IN_PERM_BEFORE_GC, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_PERM_AFTER_GC(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in perm after GC"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in meta after GC")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in perm after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in meta after GC")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the permanent generation after this GC."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the meta space after this GC.")), 41, GcStatisticValueElement.COMMITTED_BYTES_IN_PERM_AFTER_GC, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    BYTES_IN_YOUNG_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Young before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in young before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the young generation before this GC."), 28, GcStatisticValueElement.BYTES_IN_YOUNG_BEFORE_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_YOUNG_BEFORE_GC), 45056, COMMITTED_BYTES_IN_YOUNG_BEFORE_GC),
    BYTES_IN_YOUNG_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Young after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in young after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the young generation after this GC."), 27, GcStatisticValueElement.BYTES_IN_YOUNG_AFTER_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_YOUNG_AFTER_GC), 45056, COMMITTED_BYTES_IN_YOUNG_AFTER_GC),
    BYTES_IN_YOUNG_BEFORE_AND_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Young"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in young"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the young generation before and after this GC."), GcStatisticValueElement.BYTES_IN_YOUNG_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcStatisticValueElement.BYTES_IN_YOUNG_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_YOUNG_AFTER_GC, (StatisticValueElement)GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), new GcStatisticAttribute[0]),
    BYTES_IN_YOUNG_DIFFERENCE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Diff in Young"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in young (diff)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The difference of the number of bytes used in the young generation before and after this GC."), 708, GcStatisticValueElement.BYTES_IN_YOUNG_DIFFERENCE, (GcStatisticConverter)new GcStatisticConverter.MemoryDiffConverter(GcStatisticValueElement.BYTES_IN_YOUNG_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_YOUNG_AFTER_GC), new GcStatisticAttribute[0]),
    BYTES_IN_TO_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"To-space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in to-space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in to-space before this GC."), 20, GcStatisticValueElement.BYTES_IN_TO_BEFORE_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_TO_BEFORE_GC), 45056, COMMITTED_BYTES_IN_TO_BEFORE_GC),
    BYTES_IN_TO_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"To-space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in to-space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in to-space after this GC."), 19, GcStatisticValueElement.BYTES_IN_TO_AFTER_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_TO_AFTER_GC), 45056, COMMITTED_BYTES_IN_TO_AFTER_GC),
    BYTES_IN_TO_BEFORE_AND_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"To-space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in to-space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in to-space before and after this GC."), GcStatisticValueElement.BYTES_IN_TO_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcStatisticValueElement.BYTES_IN_TO_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_TO_AFTER_GC, (StatisticValueElement)GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), new GcStatisticAttribute[0]),
    BYTES_IN_TO_DIFFERENCE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Diff in To-space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in to-space (diff)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The difference of the number of bytes used in to-space before and after this GC."), 709, GcStatisticValueElement.BYTES_IN_TO_DIFFERENCE, (GcStatisticConverter)new GcStatisticConverter.MemoryDiffConverter(GcStatisticValueElement.BYTES_IN_TO_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_TO_AFTER_GC), new GcStatisticAttribute[0]),
    BYTES_IN_FROM_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"From-space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in from-space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in from-space before this GC."), 16, GcStatisticValueElement.BYTES_IN_FROM_BEFORE_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_FROM_BEFORE_GC), 45056, COMMITTED_BYTES_IN_FROM_BEFORE_GC),
    BYTES_IN_FROM_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"From-space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in from-space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in from-space after this GC."), 15, GcStatisticValueElement.BYTES_IN_FROM_AFTER_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_FROM_AFTER_GC), 45056, COMMITTED_BYTES_IN_FROM_AFTER_GC),
    BYTES_IN_FROM_BEFORE_AND_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"From-space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in from-space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in from-space before and after this GC."), GcStatisticValueElement.BYTES_IN_FROM_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcStatisticValueElement.BYTES_IN_FROM_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_FROM_AFTER_GC, (StatisticValueElement)GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), new GcStatisticAttribute[0]),
    BYTES_IN_FROM_DIFFERENCE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Diff in From-space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in from-space (diff)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The difference of the number of bytes used in from-space before and after this GC."), 710, GcStatisticValueElement.BYTES_IN_FROM_DIFFERENCE, (GcStatisticConverter)new GcStatisticConverter.MemoryDiffConverter(GcStatisticValueElement.BYTES_IN_FROM_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_FROM_AFTER_GC), new GcStatisticAttribute[0]),
    BYTES_IN_EDEN_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Eden-space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in eden-space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in eden-space before this GC."), 13, GcStatisticValueElement.BYTES_IN_EDEN_BEFORE_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_EDEN_BEFORE_GC), COMMITTED_BYTES_IN_EDEN_BEFORE_GC),
    BYTES_IN_EDEN_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Eden-space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in eden-space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in eden-space after this GC."), 12, GcStatisticValueElement.BYTES_IN_EDEN_AFTER_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_EDEN_AFTER_GC), 45056, COMMITTED_BYTES_IN_EDEN_AFTER_GC),
    BYTES_IN_EDEN_BEFORE_AND_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Eden-space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in eden-space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in eden-space before and after this GC."), GcStatisticValueElement.BYTES_IN_EDEN_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcStatisticValueElement.BYTES_IN_EDEN_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_EDEN_AFTER_GC, (StatisticValueElement)GcStatisticValueElement.MAX_YOUNG_GEN_SIZE), new GcStatisticAttribute[0]),
    BYTES_IN_EDEN_DIFFERENCE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Diff in Eden-space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in eden-space (diff)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The difference of the number of bytes used in eden-space before and after this GC."), 711, GcStatisticValueElement.BYTES_IN_EDEN_DIFFERENCE, (GcStatisticConverter)new GcStatisticConverter.MemoryDiffConverter(GcStatisticValueElement.BYTES_IN_EDEN_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_EDEN_AFTER_GC), new GcStatisticAttribute[0]),
    BYTES_WASTED_BY_TLABS_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Wasted by TLABs before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes wasted by TLABs before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes wasted by TLABs in eden-space before this GC."), 14, GcStatisticValueElement.BYTES_WASTED_BY_TLABS_BEFORE_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.BYTES_IN_EDEN_BEFORE_GC), 45060, new GcStatisticAttribute[0]),
    BYTES_IN_OLD_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Old before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in old before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the old generation before this GC."), 18, GcStatisticValueElement.BYTES_IN_OLD_BEFORE_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_OLD_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_OLD_BEFORE_GC), 12288, COMMITTED_BYTES_IN_OLD_BEFORE_GC),
    BYTES_IN_OLD_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Old after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in old after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the old generation after this GC."), 17, GcStatisticValueElement.BYTES_IN_OLD_AFTER_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_OLD_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_OLD_AFTER_GC), 12288, COMMITTED_BYTES_IN_OLD_AFTER_GC),
    BYTES_IN_OLD_BEFORE_AND_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Old"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in old"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the old generation before and after this GC."), GcStatisticValueElement.BYTES_IN_OLD_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcStatisticValueElement.BYTES_IN_OLD_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_OLD_AFTER_GC, (StatisticValueElement)GcStatisticValueElement.MAX_OLD_GEN_SIZE), new GcStatisticAttribute[0]),
    BYTES_IN_OLD_DIFFERENCE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Diff in Old"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in old (diff)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The difference of the number of bytes used in the old generation before and after this GC."), 712, GcStatisticValueElement.BYTES_IN_OLD_DIFFERENCE, (GcStatisticConverter)new GcStatisticConverter.MemoryDiffConverter(GcStatisticValueElement.BYTES_IN_OLD_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_OLD_AFTER_GC), new GcStatisticAttribute[0]),
    PROMOTIONS_TO_OLD(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Promoted to old"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes promoted to old"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were promoted to old generation during this GC."), 702, GcStatisticValueElement.PROMOTIONS_TO_OLD, GcStatisticConverter.NrOfBytesConverter, new GcStatisticAttribute[0]),
    SURVIVING_YOUNG(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Surviving young GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes surviving young GCs"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that survived young GCs."), 703, GcStatisticValueElement.SURVIVING_YOUNG, GcStatisticConverter.PositiveNrOfBytesConverter, new GcStatisticAttribute[0]),
    BYTES_IN_NON_PERM_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Java Heap before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in Java heap before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the Java heap before this GC."), 22, GcStatisticValueElement.BYTES_IN_NON_PERM_BEFORE_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_NON_PERM_BEFORE_GC), 12288, COMMITTED_BYTES_IN_NON_PERM_BEFORE_GC),
    BYTES_IN_NON_PERM_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Java Heap after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in Java heap after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the Java heap after this GC."), 21, GcStatisticValueElement.BYTES_IN_NON_PERM_AFTER_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_NON_PERM_AFTER_GC), 12288, COMMITTED_BYTES_IN_NON_PERM_AFTER_GC),
    BYTES_IN_NON_PERM_BEFORE_AND_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Java Heap"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in Java heap"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the Java heap before and after this GC."), GcStatisticValueElement.BYTES_IN_NON_PERM_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcStatisticValueElement.BYTES_IN_NON_PERM_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_NON_PERM_AFTER_GC, (StatisticValueElement)GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE), new GcStatisticAttribute[0]),
    BYTES_IN_NON_PERM_DIFFERENCE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Diff in Java Heap"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in Java heap (diff)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The difference of the number of bytes used in the Java heap before and after this GC."), 713, GcStatisticValueElement.BYTES_IN_NON_PERM_DIFFERENCE, (GcStatisticConverter)new GcStatisticConverter.MemoryDiffConverter(GcStatisticValueElement.BYTES_IN_NON_PERM_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_NON_PERM_AFTER_GC), new GcStatisticAttribute[0]),
    BYTES_IN_PERM_BEFORE_GC(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Perm before GC"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Meta before GC")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in perm before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in meta before GC")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the permanent generation before this GC."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the meta space before this GC.")), 24, GcStatisticValueElement.BYTES_IN_PERM_BEFORE_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_PERM_BEFORE_GC), 12288, COMMITTED_BYTES_IN_PERM_BEFORE_GC),
    BYTES_IN_PERM_AFTER_GC(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Perm after GC"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Meta after GC")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in perm after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in meta after GC")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the permanent generation after this GC."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the meta space after this GC.")), 23, GcStatisticValueElement.BYTES_IN_PERM_AFTER_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_PERM_GEN_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_PERM_AFTER_GC), 12288, COMMITTED_BYTES_IN_PERM_AFTER_GC),
    COMMITTED_BYTES_IN_CLASS_SPACE_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in class space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in class space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the class meta space before this GC."), 44, GcStatisticValueElement.COMMITTED_BYTES_IN_CLASS_SPACE_BEFORE_GC, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    COMMITTED_BYTES_IN_CLASS_SPACE_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Committed in class space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed bytes in class space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were committed in the class meta space after this GC."), 43, GcStatisticValueElement.COMMITTED_BYTES_IN_CLASS_SPACE_AFTER_GC, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    BYTES_IN_CLASS_SPACE_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in class space before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the class meta space before this GC."), 26, GcStatisticValueElement.BYTES_IN_CLASS_SPACE_BEFORE_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_CLASS_SPACE_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_CLASS_SPACE_BEFORE_GC), 12288, COMMITTED_BYTES_IN_CLASS_SPACE_BEFORE_GC),
    BYTES_IN_CLASS_SPACE_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in class space after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes that were used in the class meta space after this GC."), 25, GcStatisticValueElement.BYTES_IN_CLASS_SPACE_AFTER_GC, (GcStatisticConverter)new GcStatisticConverter.MemoryUsageConverter(GcStatisticValueElement.MAX_CLASS_SPACE_SIZE, (StatisticValueElement)GcStatisticValueElement.COMMITTED_BYTES_IN_CLASS_SPACE_AFTER_GC), 12288, COMMITTED_BYTES_IN_CLASS_SPACE_AFTER_GC),
    BYTES_IN_CLASS_SPACE_BEFORE_AND_AFTER(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Class Space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in class space"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the class meta space before and after this GC."), -1, GcStatisticValueElement.BYTES_IN_CLASS_SPACE_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcStatisticValueElement.BYTES_IN_CLASS_SPACE_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_CLASS_SPACE_AFTER_GC, (StatisticValueElement)GcStatisticValueElement.MAX_CLASS_SPACE_SIZE), -1, new GcStatisticAttribute[0]),
    BYTES_IN_CLASS_SPACE_DIFFERENCE(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Diff in Class Space"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in class space (diff)"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The difference of the number of bytes used in the class meta space before and after this GC."), 715, GcStatisticValueElement.BYTES_IN_CLASS_SPACE_DIFFERENCE, (GcStatisticConverter)new GcStatisticConverter.MemoryDiffConverter(GcStatisticValueElement.BYTES_IN_CLASS_SPACE_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_CLASS_SPACE_AFTER_GC), 12288, new GcStatisticAttribute[0]),
    MAX_CLASS_SPACE_SIZE(null, I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Max class space size"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum size of the class meta space."), 47, GcStatisticValueElement.MAX_CLASS_SPACE_SIZE, GcStatisticConverter.NrOfBytesConverter, 2048, new GcStatisticAttribute[0]),
    BYTES_IN_PERM_BEFORE_AND_AFTER(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Perm"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in perm"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the permanent generation before and after this GC."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes used in the meta space before and after this GC.")), -1, GcStatisticValueElement.BYTES_IN_PERM_BEFORE_AND_AFTER, (GcStatisticConverter)new GcStatisticConverter.MemoryBeforeAndAfterConverter(GcStatisticValueElement.BYTES_IN_PERM_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_PERM_AFTER_GC, (StatisticValueElement)GcStatisticValueElement.MAX_PERM_GEN_SIZE), -1, new GcStatisticAttribute[0]),
    BYTES_IN_PERM_DIFFERENCE(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Diff in Perm"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Diff in Meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in perm (diff)"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Used bytes in meta (diff)")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The difference of the number of bytes used in the permanent generation before and after this GC."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The difference of the number of bytes used in the meta space before and after this GC.")), 714, GcStatisticValueElement.BYTES_IN_PERM_DIFFERENCE, (GcStatisticConverter)new GcStatisticConverter.MemoryDiffConverter(GcStatisticValueElement.BYTES_IN_PERM_BEFORE_GC, (StatisticValueElement)GcStatisticValueElement.BYTES_IN_PERM_AFTER_GC), 12288, new GcStatisticAttribute[0]),
    BYTES_DECOMMITTED_IN_JAVA_HEAP(I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Decommitted in Java Heap"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes decommitted in Java heap"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes decommitted in Java heap."), GcStatisticValueElement.BYTES_DECOMMITTED_IN_JAVA_HEAP, GcStatisticConverter.NrOfBytesConverter, 47104, new GcStatisticAttribute[0]),
    MAX_OLD_GEN_SIZE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Max old size"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum size of the old generation."), 45, GcStatisticValueElement.MAX_OLD_GEN_SIZE, GcStatisticConverter.NrOfBytesConverter, 2048, new GcStatisticAttribute[0]),
    MAX_PERM_GEN_SIZE(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Max perm size"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Max meta size")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum size of the permanent generation."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum size of the meta space.")), 46, GcStatisticValueElement.MAX_PERM_GEN_SIZE, GcStatisticConverter.NrOfBytesConverter, 2048, new GcStatisticAttribute[0]),
    MAX_NON_PERM_GEN_SIZE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Max Java heap size"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum size of the Java heap."), 48, GcStatisticValueElement.MAX_NON_PERM_GEN_SIZE, GcStatisticConverter.NrOfBytesConverter, 2048, new GcStatisticAttribute[0]),
    MAX_YOUNG_GEN_SIZE(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Max young size"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The maximum size of the young generation."), 49, GcStatisticValueElement.MAX_YOUNG_GEN_SIZE, GcStatisticConverter.NrOfBytesConverter, 2048, new GcStatisticAttribute[0]),
    NR_OF_FULL_GCS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Number of full GCs"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of full GCs that occurred until this GC."), GcStatisticValueElement.NR_OF_FULL_GCS, GcStatisticConverter.NrOfGcsConverter, 14336, new GcStatisticAttribute[0]),
    TENURING_THRESHOLD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Tenuring threshold"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of partial GCs which an objects must survive to be promoted to the old generation."), 50, GcStatisticValueElement.TENURING_THRESHOLD, GcStatisticConverter.NrOfGcsConverter, 14336, new GcStatisticAttribute[0]),
    CUMULATIVE_DURATION(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cumulative duration"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative duration of all GCs"), GcStatisticValueElement.CUMULATIVE_DURATION, GcStatisticConverter.DurationConverter, 14336, new GcStatisticAttribute[0]),
    CUMULATIVE_CPU_TIME(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cumulative CPU time"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative CPU time of all GCs"), GcStatisticValueElement.CUMULATIVE_CPU_TIME, GcStatisticConverter.CpuTimeConverter, 14336, new GcStatisticAttribute[0]),
    CUMULATIVE_PAGE_FAULTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cumulative page faults"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of page faults of all GCs"), GcStatisticValueElement.CUMULATIVE_PAGE_FAULTS, GcStatisticConverter.NrOfPageFaultsConverter, 14336, new GcStatisticAttribute[0]),
    CUMULATIVE_MAJOR_PAGE_FAULTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cumulative major page faults"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of major page faults of all GCs"), GcStatisticValueElement.CUMULATIVE_MAJOR_PAGE_FAULTS, GcStatisticConverter.NrOfMajorPageFaultsConverter, 14336, new GcStatisticAttribute[0]),
    CUMULATIVE_MINOR_PAGE_FAULTS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cumulative minor page faults"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of minor page faults of all GCs"), GcStatisticValueElement.CUMULATIVE_MINOR_PAGE_FAULTS, GcStatisticConverter.NrOfMinorPageFaultsConverter, 14336, new GcStatisticAttribute[0]),
    CUMULATIVE_UNLOADED_NON_ARRAY_CLASSES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cumulative unloaded non-array classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of unloaded non-array classes of all GCs"), GcStatisticValueElement.CUMULATIVE_UNLOADED_NON_ARRAY_CLASSES, GcStatisticConverter.NrOfUnloadedClassesConverter, new GcStatisticAttribute[0]),
    CUMULATIVE_UNLOADED_ARRAY_CLASSES(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Cumulative unloaded array classes"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of unloaded array classes of all GCs"), GcStatisticValueElement.CUMULATIVE_UNLOADED_ARRAY_CLASSES, GcStatisticConverter.NrOfUnloadedArrayClassesConverter, new GcStatisticAttribute[0]),
    CUMULATIV_BYTES_ALLOCATED_IN_PERM(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes allocated in perm until now"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes allocated in meta until now")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of bytes allocated in the permanent generation (including this GC)."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of bytes allocated in the meta space (including this GC).")), -1, GcStatisticValueElement.CUMULATIV_BYTES_ALLOCATED_IN_PERM, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    CUMULATIV_BYTES_FREED_IN_PERM(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes freed in perm until now"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes freed in meta until now")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of bytes freed in the permanent generation (including this GC)."), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of bytes freed in the meta space (including this GC).")), -1, GcStatisticValueElement.CUMULATIV_BYTES_FREED_IN_PERM, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    CUMULATIV_BYTES_ALLOCATED_IN_NON_PERM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes allocated in Java heap until now"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of bytes allocated in the Java heap (including this GC)."), GcStatisticValueElement.CUMULATIV_BYTES_ALLOCATED_IN_NON_PERM, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    CUMULATIV_BYTES_FREED_IN_NON_PERM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes freed in Java heap until now"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of bytes freed in the Java heap (including this GC)."), GcStatisticValueElement.CUMULATIV_BYTES_FREED_IN_NON_PERM, GcStatisticConverter.NrOfBytesConverter, 14336, new GcStatisticAttribute[0]),
    CLEARED_SOFT_REFS_SUM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. of soft refs cleared until now"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of cleared soft references"), GcStatisticValueElement.CLEARED_SOFT_REFS_SUM, GcStatisticConverter.NrOfSoftRefsConverter, 14336, new GcStatisticAttribute[0]),
    ENQUEUED_SOFT_REFS_SUM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. of soft refs enqueued until now"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of enqueued soft references"), GcStatisticValueElement.ENQUEUED_SOFT_REFS_SUM, GcStatisticConverter.NrOfSoftRefsConverter, 14336, new GcStatisticAttribute[0]),
    CLEARED_WEAK_REFS_SUM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. of weak refs cleared until now"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of cleared weak references"), GcStatisticValueElement.CLEARED_WEAK_REFS_SUM, GcStatisticConverter.NrOfWeakRefsConverter, 14336, new GcStatisticAttribute[0]),
    ENQUEUED_WEAK_REFS_SUM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. of weak refs enqueued until now"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of enqueued weak references"), GcStatisticValueElement.ENQUEUED_WEAK_REFS_SUM, GcStatisticConverter.NrOfWeakRefsConverter, 14336, new GcStatisticAttribute[0]),
    ENQUEUED_FINAL_REFS_SUM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. of final refs enqueued until now"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of enqueued final references"), GcStatisticValueElement.ENQUEUED_FINAL_REFS_SUM, GcStatisticConverter.NrOfFinalRefsConverter, 14336, new GcStatisticAttribute[0]),
    ENQUEUED_PHANTOM_REFS_SUM(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Nr. of phantom refs enqueued until now"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The cumulative number of enqueued phantom references"), GcStatisticValueElement.ENQUEUED_PHANTOM_REFS_SUM, GcStatisticConverter.NrOfPhantomRefsConverter, 14336, new GcStatisticAttribute[0]),
    IS_CONCURRENT(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Collection was fully concurrent"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The garbage collection was fully concurrent"), GcStatisticValueElement.IS_CONCURRENT, GcStatisticConverter.BooleanTypeConverter, new GcStatisticAttribute[0]),
    IS_COMPACTING_OLD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Collection has compacted old gen"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The garbage collection has compacted the old generation"), GcStatisticValueElement.IS_COMPACTING_OLD, GcStatisticConverter.BooleanTypeConverter, new GcStatisticAttribute[0]),
    NR_OF_THREADS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Parallel GC threads"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of threads used for parallel remarking and parallel young GC"), 51, GcStatisticValueElement.NR_OF_THREADS, GcStatisticConverter.NrOfThreadsConverter, 2048, new GcStatisticAttribute[0]),
    BYTES_FREED_CONCURRENTLY_IN_OLD(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes concurrently freed in old"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes freed in the old generation concurrently in the time\ninterval since the last GC statistic was written"), 52, GcStatisticValueElement.BYTES_FREED_CONCURRENTLY_IN_OLD, GcStatisticConverter.NrOfBytesConverter, 47108, new GcStatisticAttribute[0]),
    BYTES_FREED_CONCURRENTLY_IN_PERM(null, new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes concurrently freed in perm"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes concurrently freed in meta")), new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes freed in the permanent generation concurrently in the time\ninterval since the last GC statistic was written"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes freed in the meta space concurrently in the time\ninterval since the last GC statistic was written")), 53, GcStatisticValueElement.BYTES_FREED_CONCURRENTLY_IN_PERM, GcStatisticConverter.NrOfBytesConverter, 47108, new GcStatisticAttribute[0]),
    BYTES_FREED_CONCURRENTLY(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Bytes concurrently freed"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of bytes freed in the Java heap concurrently in the time\ninterval since the last GC statistic was written"), 57, GcStatisticValueElement.BYTES_FREED_CONCURRENTLY, GcStatisticConverter.NrOfBytesConverter, 47108, new GcStatisticAttribute[0]),
    NR_OF_NON_ARRAY_CLASSES_UNLOADED_CONCURRENTLY(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Non-arr. classes concurrently unloaded"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of non-array classes unloaded concurrently in the time\ninterval since the last GC statistic was written."), 54, GcStatisticValueElement.NR_OF_NON_ARRAY_CLASSES_UNLOADED_CONCURRENTLY, GcStatisticConverter.NrOfUnloadedClassesConverter, 47108, new GcStatisticAttribute[0]),
    NR_OF_ARRAY_CLASSES_UNLOADED_CONCURRENTLY(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Array classes concurrently unloaded"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of array classes unloaded concurrently in the time\ninterval since the last GC statistic was written."), 55, GcStatisticValueElement.NR_OF_ARRAY_CLASSES_UNLOADED_CONCURRENTLY, GcStatisticConverter.NrOfUnloadedArrayClassesConverter, 47108, new GcStatisticAttribute[0]),
    HUMONGOUS_REGIONS_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Humongous regions before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of humongous regions before this GC"), 62, GcStatisticValueElement.HUMONGOUS_REGIONS_BEFORE_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    HUMONGOUS_REGIONS_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Humongous regions after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of humongous regions after this GC"), 63, GcStatisticValueElement.HUMONGOUS_REGIONS_AFTER_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    HUMONGOUS_START_REGIONS_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Humongous start regions before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of humongous start regions before this GC"), 65, GcStatisticValueElement.HUMONGOUS_START_REGIONS_BEFORE_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    HUMONGOUS_START_REGIONS_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Humongous start regions after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of humongous start regions after this GC"), 65, GcStatisticValueElement.HUMONGOUS_START_REGIONS_AFTER_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    FREE_REGIONS_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Free regions before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of free regions before this GC"), 60, GcStatisticValueElement.FREE_REGIONS_BEFORE_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    FREE_REGIONS_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Free regions after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of free regions after this GC"), 61, GcStatisticValueElement.FREE_REGIONS_AFTER_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    YOUNG_REGIONS_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Young regions before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of young regions before this GC"), 66, GcStatisticValueElement.YOUNG_REGIONS_BEFORE_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    YOUNG_REGIONS_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Young regions after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of young regions after this GC"), 67, GcStatisticValueElement.YOUNG_REGIONS_AFTER_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    SURVIVOR_REGIONS_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Survivor regions before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of survivor regions before this GC"), 68, GcStatisticValueElement.SURVIVOR_REGIONS_BEFORE_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    SURVIVOR_REGIONS_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Survivor regions after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of survivor regions after this GC"), 69, GcStatisticValueElement.SURVIVOR_REGIONS_AFTER_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    YOUNG_LIST_TARGET_REGIONS_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Target young regions before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The target length of the young list in regions before this GC"), 70, GcStatisticValueElement.YOUNG_LIST_TARGET_REGIONS_BEFORE_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    YOUNG_LIST_TARGET_REGIONS_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Target young regions after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The target length of the young list in regions after this GC"), 71, GcStatisticValueElement.YOUNG_LIST_TARGET_REGIONS_AFTER_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    YOUNG_LIST_MAXIMUM_REGIONS_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Young list maximum regions before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of young list maximum regions before this GC"), 72, GcStatisticValueElement.YOUNG_LIST_MAXIMUM_REGIONS_BEFORE_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    YOUNG_LIST_MAXIMUM_REGIONS_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Young list maximum regions after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of young list maximum regions after this GC"), 73, GcStatisticValueElement.YOUNG_LIST_MAXIMUM_REGIONS_AFTER_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    COMMITTED_REGIONS_BEFORE_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed regions before GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of committed regions before this GC"), 58, GcStatisticValueElement.COMMITTED_REGIONS_BEFORE_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    COMMITTED_REGIONS_AFTER_GC(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Committed regions after GC"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of committed regions after this GC"), 59, GcStatisticValueElement.COMMITTED_REGIONS_AFTER_GC, GcStatisticConverter.NrOfHeapRegionsConverter, 2048, new GcStatisticAttribute[0]),
    YOUNG_LIST_TARGET_SEL_REASON(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Young List Target Length Reason"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The reason for the selection of the young list target length"), GcStatisticValueElement.YOUNG_LIST_TARGET_SEL_REASON, GcStatisticConverter.G1YoungListTargetSelReason, new GcStatisticAttribute[0]),
    COLLECTION_SET(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Coll. Set"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The type of heap regions in the collection set of this G1 evacuation pause"), GcStatisticValueElement.COLLECTION_SET, GcStatisticConverter.G1CollectionSetConverter, new GcStatisticAttribute[0]),
    NR_OF_SCAVENGE_THREADS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Parallel scavenge threads"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of scavenge threads during this GC"), 56, GcStatisticValueElement.NR_OF_SCAVENGE_THREADS, GcStatisticConverter.NrOfThreadsConverter, 2048, new GcStatisticAttribute[0]),
    NR_OF_COMPACT_THREADS(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Parallel compact threads"), I18n._ts((I18n.TextType)I18n.TextType.XTOL, (String)"The number of compact threads (used for the parallel full GC) during this GC"), 74, GcStatisticValueElement.NR_OF_COMPACT_THREADS, GcStatisticConverter.NrOfThreadsConverter, 2048, new GcStatisticAttribute[0]);

    private static final GcStatisticAttribute[] attribute4Element;
    private GcStatisticConverter converter;
    private GcStatisticValueElement element;
    private SessionAwareString longDescription;
    private SessionAwareString shortDescription;
    private SessionAwareString columnName;
    private GcStatisticAttribute[] subAttributes;
    private int timeSeriesIndex = -1;
    private int columnFlags;

    private GcStatisticAttribute(String shortDescription, String longDescription, GcStatisticValueElement element, GcStatisticConverter converter, GcStatisticAttribute ... subAttributes) {
        this(null, shortDescription, longDescription, element, converter, subAttributes);
    }

    private GcStatisticAttribute(String shortDescription, String longDescription, GcStatisticValueElement element, GcStatisticConverter converter, int columnFlags, GcStatisticAttribute ... subAttributes) {
        this(null, shortDescription, longDescription, element, converter, columnFlags, subAttributes);
    }

    private GcStatisticAttribute(String columnName, String shortDescription, String longDescription, GcStatisticValueElement element, GcStatisticConverter converter, GcStatisticAttribute ... subAttributes) {
        this(columnName, shortDescription, longDescription, -1, element, converter, subAttributes);
    }

    private GcStatisticAttribute(String columnName, String shortDescription, String longDescription, GcStatisticValueElement element, GcStatisticConverter converter, int columnFlags, GcStatisticAttribute ... subAttributes) {
        this(columnName, shortDescription, longDescription, -1, element, converter, columnFlags, subAttributes);
    }

    private GcStatisticAttribute(String shortDescription, String longDescription, int timeSeriesIndex, GcStatisticValueElement element, GcStatisticConverter converter, int columnFlags, GcStatisticAttribute ... subAttributes) {
        this(null, shortDescription, longDescription, timeSeriesIndex, element, converter, columnFlags, subAttributes);
    }

    private GcStatisticAttribute(String shortDescription, String longDescription, int timeSeriesIndex, GcStatisticValueElement element, GcStatisticConverter converter, GcStatisticAttribute ... subAttributes) {
        this(null, shortDescription, longDescription, timeSeriesIndex, element, converter, subAttributes);
    }

    private GcStatisticAttribute(String columnName, String shortDescription, String longDescription, int timeSeriesIndex, GcStatisticValueElement element, GcStatisticConverter converter, GcStatisticAttribute ... subAttributes) {
        this.element = element;
        this.converter = converter;
        this.timeSeriesIndex = timeSeriesIndex;
        this.longDescription = GcStatisticAttribute.getString(longDescription);
        this.shortDescription = GcStatisticAttribute.getString(shortDescription);
        this.columnName = GcStatisticAttribute.getString(columnName);
        this.subAttributes = subAttributes;
        this.columnFlags = -1;
    }

    private GcStatisticAttribute(String columnName, String shortDescription, String longDescription, int timeSeriesIndex, GcStatisticValueElement element, GcStatisticConverter converter, int columnFlags, GcStatisticAttribute ... subAttributes) {
        this.element = element;
        this.converter = converter;
        this.timeSeriesIndex = timeSeriesIndex;
        this.longDescription = GcStatisticAttribute.getString(longDescription);
        this.shortDescription = GcStatisticAttribute.getString(shortDescription);
        this.columnName = GcStatisticAttribute.getString(columnName);
        this.subAttributes = subAttributes;
        this.columnFlags = columnFlags;
    }

    private GcStatisticAttribute(SessionAwareString columnName, SessionAwareString shortDescription, SessionAwareString longDescription, int timeSeriesIndex, GcStatisticValueElement element, GcStatisticConverter converter, int columnFlags, GcStatisticAttribute ... subAttributes) {
        this.element = element;
        this.converter = converter;
        this.timeSeriesIndex = timeSeriesIndex;
        this.longDescription = longDescription;
        this.shortDescription = shortDescription;
        this.columnName = columnName;
        this.subAttributes = subAttributes;
        this.columnFlags = columnFlags;
    }

    @Override
    public Class<? extends ProviderEntry> getType() {
        return this.converter.getType();
    }

    @Override
    public Class<? extends ProviderEntry> getBaseType() {
        return TypedTimeSeriesProvider.getBaseAxis(this.getType());
    }

    @Override
    public int getColumnFlags() {
        if (this.columnFlags != -1) {
            return this.columnFlags;
        }
        return this.converter.getColumnFlags();
    }

    @Override
    public ProviderEntry getValue(GcStatistic event) {
        return this.converter.getValue(this.element, event);
    }

    public ProviderEntry getValue(GcStatisticValue value, GcStatisticValue total) {
        return this.converter.getValue(this.element, value, total);
    }

    @Override
    public String getColumnName(ProfilingSession session) {
        return this.columnName == null ? this.getShortDescription(session) : this.columnName.getValue(session);
    }

    @Override
    public String getShortDescription(ProfilingSession session) {
        return this.shortDescription.getValue(session);
    }

    @Override
    public String getLongDescription(ProfilingSession session) {
        return this.longDescription.getValue(session);
    }

    @Override
    public boolean hasSubAttributes() {
        return this.subAttributes != null && this.subAttributes.length > 0;
    }

    public Attribute<GcStatistic>[] getSubAttributes() {
        if (this.subAttributes == null) {
            return new GcStatisticAttribute[0];
        }
        return this.subAttributes;
    }

    @Override
    public Attribute<GcStatistic>[] getSubAttributes(GcStatistic data) {
        return this.getSubAttributes();
    }

    @Override
    public int getTimeSeriesIndex() {
        return this.timeSeriesIndex;
    }

    public String getColumnTag() {
        return this.element.getColumnTag();
    }

    @Override
    public StatisticValueElement getValueElement() {
        return this.element;
    }

    public static ProviderEntry getEntry(GcStatisticValueElement element, GcStatisticValue value, GcStatisticValue total) {
        return attribute4Element[element.ordinal()].getValue(value, total);
    }

    public static GcStatisticAttribute getAttributeForElement(GcStatisticValueElement element) {
        return attribute4Element[element.ordinal()];
    }

    private static SessionAwareString getString(final String value) {
        if (value == null) {
            return null;
        }
        return new SessionAwareString(){

            @Override
            public String getValue(ProfilingSession session) {
                return value;
            }
        };
    }

    static {
        attribute4Element = new GcStatisticAttribute[GcStatisticValueElement.values().length];
        GcStatisticAttribute[] gcStatisticAttributeArray = GcStatisticAttribute.values();
        int n = gcStatisticAttributeArray.length;
        for (int i = 0; i < n; ++i) {
            GcStatisticAttribute attribute;
            GcStatisticAttribute.attribute4Element[attribute.element.ordinal()] = attribute = gcStatisticAttributeArray[i];
        }
    }
}

