/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.presentation.typed.gc.Attribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcStatisticAttribute;
import com.sap.jvm.profiling.presentation.typed.gc.MetaSpaceAwareString;
import com.sap.jvm.profiling.presentation.typed.gc.SessionAwareString;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class GcStatisticAttributeGroup {
    public static final GcStatisticAttributeGroup ALL_BASE_ATTRIBUTES = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"All Attributes"), GcStatisticAttribute.values());
    private static final GcStatisticAttributeGroup BASIC_ATTRIBUTES = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Basic Attributes"), new GcStatisticAttribute[]{GcStatisticAttribute.GC_NR, GcStatisticAttribute.GC_TYPE, GcStatisticAttribute.NR_OF_FULL_GCS, GcStatisticAttribute.GC_ALGORITHM, GcStatisticAttribute.GC_CAUSE, GcStatisticAttribute.TIME_STAMP, GcStatisticAttribute.MAX_PAUSE_TIME, GcStatisticAttribute.DURATION, GcStatisticAttribute.CPU_TIME, GcStatisticAttribute.PROMOTION_FAILURES});
    private static final GcStatisticAttributeGroup BASIC_ATTRIBUTES_CMS = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Basic Attributes"), new GcStatisticAttribute[]{GcStatisticAttribute.GC_NR, GcStatisticAttribute.GC_TYPE, GcStatisticAttribute.NR_OF_FULL_GCS, GcStatisticAttribute.GC_ALGORITHM, GcStatisticAttribute.GC_CAUSE, GcStatisticAttribute.TIME_STAMP, GcStatisticAttribute.MAX_PAUSE_TIME, GcStatisticAttribute.DURATION, GcStatisticAttribute.CPU_TIME, GcStatisticAttribute.PROMOTION_FAILURES, GcStatisticAttribute.IS_CONCURRENT, GcStatisticAttribute.IS_COMPACTING_OLD, GcStatisticAttribute.NR_OF_THREADS, GcStatisticAttribute.TIME_SINCE_LAST_CONC_GC});
    private static final GcStatisticAttributeGroup BASIC_ATTRIBUTES_G1 = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Basic Attributes"), new GcStatisticAttribute[]{GcStatisticAttribute.GC_NR, GcStatisticAttribute.GC_TYPE, GcStatisticAttribute.COLLECTION_SET, GcStatisticAttribute.NR_OF_FULL_GCS, GcStatisticAttribute.GC_ALGORITHM, GcStatisticAttribute.GC_CAUSE, GcStatisticAttribute.TIME_STAMP, GcStatisticAttribute.MAX_PAUSE_TIME, GcStatisticAttribute.DURATION, GcStatisticAttribute.CPU_TIME, GcStatisticAttribute.PROMOTION_FAILURES, GcStatisticAttribute.IS_CONCURRENT, GcStatisticAttribute.NR_OF_SCAVENGE_THREADS, GcStatisticAttribute.TIME_SINCE_LAST_CONC_GC});
    private static final GcStatisticAttributeGroup BASIC_ATTRIBUTES_PAR = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Basic Attributes"), new GcStatisticAttribute[]{GcStatisticAttribute.GC_NR, GcStatisticAttribute.GC_TYPE, GcStatisticAttribute.NR_OF_FULL_GCS, GcStatisticAttribute.GC_ALGORITHM, GcStatisticAttribute.GC_CAUSE, GcStatisticAttribute.TIME_STAMP, GcStatisticAttribute.MAX_PAUSE_TIME, GcStatisticAttribute.DURATION, GcStatisticAttribute.CPU_TIME, GcStatisticAttribute.PROMOTION_FAILURES, GcStatisticAttribute.NR_OF_SCAVENGE_THREADS});
    private static final GcStatisticAttributeGroup BASIC_ATTRIBUTES_PAR_OLD = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Basic Attributes"), new GcStatisticAttribute[]{GcStatisticAttribute.GC_NR, GcStatisticAttribute.GC_TYPE, GcStatisticAttribute.NR_OF_FULL_GCS, GcStatisticAttribute.GC_ALGORITHM, GcStatisticAttribute.GC_CAUSE, GcStatisticAttribute.TIME_STAMP, GcStatisticAttribute.MAX_PAUSE_TIME, GcStatisticAttribute.DURATION, GcStatisticAttribute.CPU_TIME, GcStatisticAttribute.PROMOTION_FAILURES, GcStatisticAttribute.NR_OF_SCAVENGE_THREADS, GcStatisticAttribute.NR_OF_COMPACT_THREADS});
    private static final GcStatisticAttributeGroup PAGE_FAULTS_ATTRIBUTES = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Page Faults"), new GcStatisticAttribute[]{GcStatisticAttribute.PAGE_FAULTS, GcStatisticAttribute.CUMULATIVE_PAGE_FAULTS, GcStatisticAttribute.MAJOR_PAGE_FAULTS, GcStatisticAttribute.CUMULATIVE_MAJOR_PAGE_FAULTS, GcStatisticAttribute.MINOR_PAGE_FAULTS, GcStatisticAttribute.CUMULATIVE_MINOR_PAGE_FAULTS});
    private static final GcStatisticAttributeGroup UNLOADED_CLASSES_ATTRIBUTES = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Unloaded Classes"), new GcStatisticAttribute[]{GcStatisticAttribute.NR_OF_UNLOADED_CLASSES, GcStatisticAttribute.NR_OF_NON_ARRAY_CLASSES_BEFORE_GC, GcStatisticAttribute.NR_OF_NON_ARRAY_CLASSES_AFTER_GC, GcStatisticAttribute.NR_OF_ARRAY_CLASSES_BEFORE_GC, GcStatisticAttribute.NR_OF_ARRAY_CLASSES_AFTER_GC, GcStatisticAttribute.CUMULATIVE_UNLOADED_NON_ARRAY_CLASSES, GcStatisticAttribute.CUMULATIVE_UNLOADED_ARRAY_CLASSES});
    private static final GcStatisticAttributeGroup UNLOADED_CLASSES_ATTRIBUTES_CMS_AND_G1 = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Unloaded Classes"), new GcStatisticAttribute[]{GcStatisticAttribute.NR_OF_UNLOADED_CLASSES, GcStatisticAttribute.NR_OF_NON_ARRAY_CLASSES_BEFORE_GC, GcStatisticAttribute.NR_OF_NON_ARRAY_CLASSES_AFTER_GC, GcStatisticAttribute.NR_OF_ARRAY_CLASSES_BEFORE_GC, GcStatisticAttribute.NR_OF_ARRAY_CLASSES_AFTER_GC, GcStatisticAttribute.CUMULATIVE_UNLOADED_NON_ARRAY_CLASSES, GcStatisticAttribute.CUMULATIVE_UNLOADED_ARRAY_CLASSES, GcStatisticAttribute.NR_OF_NON_ARRAY_CLASSES_UNLOADED_CONCURRENTLY, GcStatisticAttribute.NR_OF_ARRAY_CLASSES_UNLOADED_CONCURRENTLY});
    private static final GcStatisticAttributeGroup JAVA_HEAP_ATTRIBUTES = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Java Heap"), new GcStatisticAttribute[]{GcStatisticAttribute.BYTES_IN_NON_PERM_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_NON_PERM_BEFORE_GC, GcStatisticAttribute.BYTES_IN_NON_PERM_AFTER_GC, GcStatisticAttribute.BYTES_IN_NON_PERM_DIFFERENCE, GcStatisticAttribute.MAX_NON_PERM_GEN_SIZE, GcStatisticAttribute.BYTES_DECOMMITTED_IN_JAVA_HEAP, GcStatisticAttribute.CUMULATIV_BYTES_ALLOCATED_IN_NON_PERM, GcStatisticAttribute.CUMULATIV_BYTES_FREED_IN_NON_PERM});
    private static final GcStatisticAttributeGroup JAVA_HEAP_ATTRIBUTES_CMS = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Java Heap"), new GcStatisticAttribute[]{GcStatisticAttribute.BYTES_IN_NON_PERM_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_NON_PERM_BEFORE_GC, GcStatisticAttribute.BYTES_IN_NON_PERM_AFTER_GC, GcStatisticAttribute.BYTES_IN_NON_PERM_DIFFERENCE, GcStatisticAttribute.MAX_NON_PERM_GEN_SIZE, GcStatisticAttribute.BYTES_DECOMMITTED_IN_JAVA_HEAP, GcStatisticAttribute.CUMULATIV_BYTES_ALLOCATED_IN_NON_PERM, GcStatisticAttribute.CUMULATIV_BYTES_FREED_IN_NON_PERM, GcStatisticAttribute.BYTES_FREED_CONCURRENTLY_IN_OLD});
    private static final GcStatisticAttributeGroup JAVA_HEAP_ATTRIBUTES_G1 = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Java Heap"), new GcStatisticAttribute[]{GcStatisticAttribute.BYTES_IN_NON_PERM_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_NON_PERM_BEFORE_GC, GcStatisticAttribute.BYTES_IN_NON_PERM_AFTER_GC, GcStatisticAttribute.BYTES_IN_NON_PERM_DIFFERENCE, GcStatisticAttribute.MAX_NON_PERM_GEN_SIZE, GcStatisticAttribute.BYTES_DECOMMITTED_IN_JAVA_HEAP, GcStatisticAttribute.CUMULATIV_BYTES_ALLOCATED_IN_NON_PERM, GcStatisticAttribute.CUMULATIV_BYTES_FREED_IN_NON_PERM, GcStatisticAttribute.BYTES_FREED_CONCURRENTLY});
    private static final GcStatisticAttributeGroup JAVA_HEAP_DETAILS_ATTRIBUTES = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Java Heap Details"), new GcStatisticAttribute[]{GcStatisticAttribute.BYTES_IN_EDEN_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_EDEN_BEFORE_GC, GcStatisticAttribute.BYTES_IN_EDEN_AFTER_GC, GcStatisticAttribute.BYTES_IN_EDEN_DIFFERENCE, GcStatisticAttribute.BYTES_WASTED_BY_TLABS_BEFORE_GC, GcStatisticAttribute.BYTES_IN_FROM_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_FROM_BEFORE_GC, GcStatisticAttribute.BYTES_IN_FROM_AFTER_GC, GcStatisticAttribute.BYTES_IN_FROM_DIFFERENCE, GcStatisticAttribute.BYTES_IN_TO_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_TO_BEFORE_GC, GcStatisticAttribute.BYTES_IN_TO_AFTER_GC, GcStatisticAttribute.BYTES_IN_TO_DIFFERENCE, GcStatisticAttribute.BYTES_IN_YOUNG_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_YOUNG_BEFORE_GC, GcStatisticAttribute.BYTES_IN_YOUNG_AFTER_GC, GcStatisticAttribute.BYTES_IN_YOUNG_DIFFERENCE, GcStatisticAttribute.MAX_YOUNG_GEN_SIZE, GcStatisticAttribute.TENURING_THRESHOLD, GcStatisticAttribute.BYTES_IN_OLD_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_OLD_BEFORE_GC, GcStatisticAttribute.BYTES_IN_OLD_AFTER_GC, GcStatisticAttribute.BYTES_IN_OLD_DIFFERENCE, GcStatisticAttribute.PROMOTIONS_TO_OLD, GcStatisticAttribute.SURVIVING_YOUNG, GcStatisticAttribute.MAX_OLD_GEN_SIZE});
    private static final GcStatisticAttributeGroup PERM_ATTRIBUTES = new GcStatisticAttributeGroup(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Permanent Generation"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Meta Space")), new GcStatisticAttribute[]{GcStatisticAttribute.BYTES_IN_PERM_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_PERM_BEFORE_GC, GcStatisticAttribute.BYTES_IN_PERM_AFTER_GC, GcStatisticAttribute.BYTES_IN_PERM_DIFFERENCE, GcStatisticAttribute.MAX_PERM_GEN_SIZE, GcStatisticAttribute.CUMULATIV_BYTES_ALLOCATED_IN_PERM, GcStatisticAttribute.CUMULATIV_BYTES_FREED_IN_PERM});
    private static final GcStatisticAttributeGroup CLASS_SPACE_ATTRIBUTES = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Class Space"), new GcStatisticAttribute[]{GcStatisticAttribute.BYTES_IN_CLASS_SPACE_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_CLASS_SPACE_BEFORE_GC, GcStatisticAttribute.BYTES_IN_CLASS_SPACE_AFTER_GC, GcStatisticAttribute.BYTES_IN_CLASS_SPACE_DIFFERENCE, GcStatisticAttribute.MAX_CLASS_SPACE_SIZE});
    private static final GcStatisticAttributeGroup PERM_ATTRIBUTES_CMS = new GcStatisticAttributeGroup(new MetaSpaceAwareString(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Permanent Generation"), I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Meta Space")), new GcStatisticAttribute[]{GcStatisticAttribute.BYTES_IN_PERM_BEFORE_AND_AFTER, GcStatisticAttribute.BYTES_IN_PERM_BEFORE_GC, GcStatisticAttribute.BYTES_IN_PERM_AFTER_GC, GcStatisticAttribute.BYTES_IN_PERM_DIFFERENCE, GcStatisticAttribute.MAX_PERM_GEN_SIZE, GcStatisticAttribute.CUMULATIV_BYTES_ALLOCATED_IN_PERM, GcStatisticAttribute.CUMULATIV_BYTES_FREED_IN_PERM, GcStatisticAttribute.BYTES_FREED_CONCURRENTLY_IN_PERM});
    private static final GcStatisticAttributeGroup REFERENCE_ATTRIBUTES = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Reference Handling"), new GcStatisticAttribute[]{GcStatisticAttribute.FORCED_SOFT_REF_CLEAR, GcStatisticAttribute.CLEARED_SOFT_REFS_SUM, GcStatisticAttribute.ENQUEUED_SOFT_REFS_SUM, GcStatisticAttribute.CLEARED_WEAK_REFS_SUM, GcStatisticAttribute.ENQUEUED_WEAK_REFS_SUM, GcStatisticAttribute.ENQUEUED_FINAL_REFS_SUM, GcStatisticAttribute.ENQUEUED_PHANTOM_REFS_SUM});
    private static final GcStatisticAttributeGroup GC_SPECIFIC_DETAILS_NONE = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"GC specifics"), new GcStatisticAttribute[0]);
    private static final GcStatisticAttributeGroup GC_SPECIFIC_DETAILS_G1 = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"G1 Specific Details"), new GcStatisticAttribute[]{GcStatisticAttribute.HUMONGOUS_REGIONS_BEFORE_GC, GcStatisticAttribute.HUMONGOUS_REGIONS_AFTER_GC, GcStatisticAttribute.HUMONGOUS_START_REGIONS_BEFORE_GC, GcStatisticAttribute.HUMONGOUS_START_REGIONS_AFTER_GC, GcStatisticAttribute.FREE_REGIONS_BEFORE_GC, GcStatisticAttribute.FREE_REGIONS_AFTER_GC, GcStatisticAttribute.YOUNG_REGIONS_BEFORE_GC, GcStatisticAttribute.YOUNG_REGIONS_AFTER_GC, GcStatisticAttribute.SURVIVOR_REGIONS_BEFORE_GC, GcStatisticAttribute.SURVIVOR_REGIONS_AFTER_GC, GcStatisticAttribute.YOUNG_LIST_TARGET_REGIONS_BEFORE_GC, GcStatisticAttribute.YOUNG_LIST_TARGET_REGIONS_AFTER_GC, GcStatisticAttribute.YOUNG_LIST_TARGET_SEL_REASON, GcStatisticAttribute.YOUNG_LIST_MAXIMUM_REGIONS_BEFORE_GC, GcStatisticAttribute.YOUNG_LIST_MAXIMUM_REGIONS_AFTER_GC, GcStatisticAttribute.COMMITTED_REGIONS_BEFORE_GC, GcStatisticAttribute.COMMITTED_REGIONS_AFTER_GC});
    private static final GcStatisticAttributeGroup OTHER_ATTRIBUTES = new GcStatisticAttributeGroup(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Other"), GcStatisticAttributeGroup.getOtherAttributes());
    private SessionAwareString description;
    private GcStatisticAttribute[] attributes;

    public static final GcStatisticAttributeGroup[] getGroups(GcStatistic data, ProfilingSession session) {
        return GcStatisticAttributeGroup.getGroups(data.getGcType(), session);
    }

    public static final GcStatisticAttributeGroup[] getGroups(GcType type, ProfilingSession session) {
        GcStatisticAttributeGroup[] result = new GcStatisticAttributeGroup[]{BASIC_ATTRIBUTES, PAGE_FAULTS_ATTRIBUTES, UNLOADED_CLASSES_ATTRIBUTES, JAVA_HEAP_ATTRIBUTES, JAVA_HEAP_DETAILS_ATTRIBUTES, PERM_ATTRIBUTES, CLASS_SPACE_ATTRIBUTES, REFERENCE_ATTRIBUTES, GC_SPECIFIC_DETAILS_NONE, OTHER_ATTRIBUTES};
        switch (type) {
            case CONC_MARK_SWEEP_GC: {
                result[0] = BASIC_ATTRIBUTES_CMS;
                result[2] = UNLOADED_CLASSES_ATTRIBUTES_CMS_AND_G1;
                result[3] = JAVA_HEAP_ATTRIBUTES_CMS;
                result[5] = PERM_ATTRIBUTES_CMS;
                break;
            }
            case GARBAGE_FIRST_GC: {
                result[0] = BASIC_ATTRIBUTES_G1;
                result[2] = UNLOADED_CLASSES_ATTRIBUTES_CMS_AND_G1;
                result[3] = JAVA_HEAP_ATTRIBUTES_G1;
                result[8] = GC_SPECIFIC_DETAILS_G1;
                break;
            }
            case PARALLEL_GC: 
            case PARALLEL_NEW_GC: {
                result[0] = BASIC_ATTRIBUTES_PAR;
                break;
            }
            case PARALLEL_OLD_GC: {
                result[0] = BASIC_ATTRIBUTES_PAR_OLD;
                break;
            }
        }
        for (int i = 0; i < result.length; ++i) {
            if (!GcStatisticAttributeGroup.hasNonApplicables(result[i], session, type)) continue;
            result[i] = GcStatisticAttributeGroup.removeNonApplicables(result[i], session, type);
        }
        return result;
    }

    private static boolean hasNonApplicables(GcStatisticAttributeGroup group, ProfilingSession session, GcType type) {
        return Arrays.stream(group.getAttributes()).anyMatch(a -> !a.isApplicable(session, type, null));
    }

    private static final GcStatisticAttributeGroup removeNonApplicables(GcStatisticAttributeGroup group, ProfilingSession session, GcType type) {
        GcStatisticAttribute[] filtered = (GcStatisticAttribute[])Arrays.stream(group.getAttributes()).filter(a -> a.isApplicable(session, type, null)).toArray(GcStatisticAttribute[]::new);
        return new GcStatisticAttributeGroup(group.description, filtered);
    }

    public GcStatisticAttributeGroup(final String description, GcStatisticAttribute[] attributes) {
        this.description = description == null ? null : new SessionAwareString(){

            @Override
            public String getValue(ProfilingSession session) {
                return description;
            }
        };
        this.attributes = attributes;
    }

    public GcStatisticAttributeGroup(SessionAwareString description, GcStatisticAttribute[] attributes) {
        this.description = description;
        this.attributes = attributes;
    }

    private static GcStatisticAttribute[] getOtherAttributes() {
        LinkedList<GcStatisticAttribute> result = new LinkedList<GcStatisticAttribute>(Arrays.asList(GcStatisticAttribute.values()));
        for (GcStatisticAttribute attribute : BASIC_ATTRIBUTES.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : BASIC_ATTRIBUTES_CMS.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : BASIC_ATTRIBUTES_PAR.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : BASIC_ATTRIBUTES_PAR_OLD.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : BASIC_ATTRIBUTES_G1.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : PAGE_FAULTS_ATTRIBUTES.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : UNLOADED_CLASSES_ATTRIBUTES.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : UNLOADED_CLASSES_ATTRIBUTES_CMS_AND_G1.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : JAVA_HEAP_ATTRIBUTES.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : JAVA_HEAP_ATTRIBUTES_CMS.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : JAVA_HEAP_DETAILS_ATTRIBUTES.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : PERM_ATTRIBUTES.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : CLASS_SPACE_ATTRIBUTES.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : PERM_ATTRIBUTES_CMS.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : JAVA_HEAP_ATTRIBUTES_G1.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : REFERENCE_ATTRIBUTES.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        for (GcStatisticAttribute attribute : GC_SPECIFIC_DETAILS_G1.getAttributes()) {
            GcStatisticAttributeGroup.removeRecursive(result, attribute);
        }
        return result.toArray(new GcStatisticAttribute[result.size()]);
    }

    private static void removeRecursive(List<GcStatisticAttribute> list, Attribute<GcStatistic> attr) {
        list.remove(attr);
        if (attr.hasSubAttributes()) {
            for (Attribute<Object> subAttr : attr.getSubAttributes(null)) {
                GcStatisticAttributeGroup.removeRecursive(list, subAttr);
            }
        }
    }

    public String getDescription(ProfilingSession session) {
        return this.description.getValue(session);
    }

    public GcStatisticAttribute[] getAttributes() {
        return this.attributes;
    }

    public boolean isEmpty() {
        return this.attributes.length == 0;
    }
}

