/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.gc;

import com.sap.jvm.profiling.memory.event.GcCause;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcG1CollectionSet;
import com.sap.jvm.profiling.memory.event.GcG1YoungListTargetSelReason;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.presentation.typed.entries.BaseQuantity;
import com.sap.jvm.profiling.presentation.typed.entries.BooleanType;
import com.sap.jvm.profiling.presentation.typed.entries.CpuTime;
import com.sap.jvm.profiling.presentation.typed.entries.Duration;
import com.sap.jvm.profiling.presentation.typed.entries.ElapsedTime;
import com.sap.jvm.profiling.presentation.typed.entries.GcCauseEntry;
import com.sap.jvm.profiling.presentation.typed.entries.GcG1CollectionSetEntry;
import com.sap.jvm.profiling.presentation.typed.entries.GcG1YoungListTargetSelReasonEntry;
import com.sap.jvm.profiling.presentation.typed.entries.GcTypeEntry;
import com.sap.jvm.profiling.presentation.typed.entries.LoadAverage;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsage;
import com.sap.jvm.profiling.presentation.typed.entries.MemoryUsageBeforeAndAfter;
import com.sap.jvm.profiling.presentation.typed.entries.NormalGcId;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfBytes;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfClasses;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfFinalReferences;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfGcs;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfHeapRegions;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfJniWeakReferences;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfMajorPageFaults;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfMinorPageFaults;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfObjects;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfPageFaults;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfPhantomReferences;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfPromotionFailures;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfSoftReferences;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfThreads;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfUnloadedArrayClasses;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfUnloadedClasses;
import com.sap.jvm.profiling.presentation.typed.entries.NrOfWeakReferences;
import com.sap.jvm.profiling.presentation.typed.entries.ProviderEntry;
import com.sap.jvm.profiling.presentation.typed.entries.Timestamp;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.StatisticValueElement;

public interface GcStatisticConverter {
    public static final GcStatisticConverter BooleanTypeConverter = new ConverterBase(BooleanType.class){

        @Override
        ProviderEntry getValue(long elementValue) {
            return new BooleanType(elementValue != 0L, BooleanType.Type.YES_NO);
        }

        @Override
        public int getColumnFlags() {
            return 16384;
        }
    };
    public static final GcStatisticConverter YoungMixedConverter = new ConverterBase(BooleanType.class){

        @Override
        ProviderEntry getValue(long elementValue) {
            return new BooleanType(elementValue != 0L, BooleanType.Type.YOUNG_MIXED);
        }

        @Override
        public int getColumnFlags() {
            return 16384;
        }
    };
    public static final GcStatisticConverter NrOfPromotionFailuresConverter = new PrototypeConverter(NrOfPromotionFailures.PROTOTYPE, 14340);
    public static final GcStatisticConverter CpuTimeConverter = new PrototypeConverter(CpuTime.PROTOTYPE, 14340);
    public static final GcStatisticConverter DurationConverter = new PrototypeConverter(Duration.PROTOTYPE, 14340);
    public static final GcStatisticConverter ElapsedTimeConverter = new PrototypeConverter(ElapsedTime.PROTOTYPE, 14340);
    public static final GcStatisticConverter PositiveElapsedTimeConverter = new PrototypeConverter((BaseQuantity)ElapsedTime.PROTOTYPE, 14340){

        @Override
        protected boolean skipValue(long val) {
            return val < 0L;
        }
    };
    public static final GcStatisticConverter ElapsedTimeTotalConverter = new ConverterBase(ElapsedTime.class){

        @Override
        public ProviderEntry getValue(GcStatisticValueElement element, GcStatisticValue value, GcStatisticValue total) {
            return ElapsedTime.PROTOTYPE.create(value.getElementValue(element), total.getElementValue(element));
        }

        @Override
        ProviderEntry getValue(long elementValue) {
            return ElapsedTime.PROTOTYPE.create(elementValue);
        }

        @Override
        public int getColumnFlags() {
            return 12292;
        }
    };
    public static final GcStatisticConverter ElapsedTimeMaxConverter = new ConverterBase(ElapsedTime.class){

        @Override
        ProviderEntry getValue(long elementValue) {
            return ElapsedTime.PROTOTYPE.create(elementValue, true);
        }

        @Override
        public int getColumnFlags() {
            return 12292;
        }
    };
    public static final GcStatisticConverter GcCauseEntryConverter = new ConverterBase(GcCauseEntry.class){

        @Override
        ProviderEntry getValue(long elementValue) {
            return new GcCauseEntry(GcCause.values()[(int)elementValue]);
        }

        @Override
        public int getColumnFlags() {
            return 16384;
        }
    };
    public static final GcStatisticConverter GcTypeEntryConverter = new ConverterBase(GcTypeEntry.class){

        @Override
        ProviderEntry getValue(long elementValue) {
            return new GcTypeEntry((byte)elementValue);
        }

        @Override
        public int getColumnFlags() {
            return 16384;
        }
    };
    public static final GcStatisticConverter NormalGcIdConverter = new ConverterBase(NormalGcId.class){

        @Override
        ProviderEntry getValue(long elementValue) {
            return new NormalGcId(elementValue);
        }

        @Override
        public int getColumnFlags() {
            return 8192;
        }
    };
    public static final GcStatisticConverter NrOfBytesConverter = new PrototypeConverter(NrOfBytes.PROTOTYPE, 14340);
    public static final GcStatisticConverter PositiveNrOfBytesConverter = new PrototypeConverter((BaseQuantity)NrOfBytes.PROTOTYPE, 14340){

        @Override
        protected boolean skipValue(long val) {
            return val < 0L;
        }
    };
    public static final GcStatisticConverter NrOfObjectsConverter = new PrototypeConverter(NrOfObjects.PROTOTYPE, 14340);
    public static final GcStatisticConverter NrOfClassesConverter = new PrototypeConverter(NrOfClasses.PROTOTYPE, 14340);
    public static final GcStatisticConverter NrOfUnloadedClassesConverter = new PrototypeConverter(NrOfUnloadedClasses.PROTOTYPE, 47108);
    public static final GcStatisticConverter NrOfUnloadedArrayClassesConverter = new PrototypeConverter(NrOfUnloadedArrayClasses.PROTOTYPE, 47108);
    public static final GcStatisticConverter NrOfThreadsConverter = new PrototypeConverter(NrOfThreads.PROTOTYPE, 14336);
    public static final GcStatisticConverter NrOfHeapRegionsConverter = new PrototypeConverter(NrOfHeapRegions.PROTOTYPE, 14336);
    public static final GcStatisticConverter G1YoungListTargetSelReason = new ConverterBase(GcG1YoungListTargetSelReasonEntry.class){

        @Override
        ProviderEntry getValue(long elementValue) {
            return new GcG1YoungListTargetSelReasonEntry(GcG1YoungListTargetSelReason.values()[(int)elementValue]);
        }

        @Override
        public int getColumnFlags() {
            return 16384;
        }
    };
    public static final GcStatisticConverter G1CollectionSetConverter = new ConverterBase(GcG1CollectionSetEntry.class){

        @Override
        ProviderEntry getValue(long elementValue) {
            return new GcG1CollectionSetEntry(GcG1CollectionSet.get((int)((int)elementValue)));
        }

        @Override
        public int getColumnFlags() {
            return 16384;
        }
    };
    public static final GcStatisticConverter NrOfSoftRefsConverter = new PrototypeConverter(NrOfSoftReferences.PROTOTYPE, 14340);
    public static final GcStatisticConverter NrOfFinalRefsConverter = new PrototypeConverter(NrOfFinalReferences.PROTOTYPE, 14340);
    public static final GcStatisticConverter NrOfPhantomRefsConverter = new PrototypeConverter(NrOfPhantomReferences.PROTOTYPE, 14340);
    public static final GcStatisticConverter NrOfWeakRefsConverter = new PrototypeConverter(NrOfWeakReferences.PROTOTYPE, 14340);
    public static final GcStatisticConverter NrOfJniWeakRefsConverter = new PrototypeConverter(NrOfJniWeakReferences.PROTOTYPE, 14340);
    public static final GcStatisticConverter NrOfGcsConverter = new PrototypeConverter(NrOfGcs.PROTOTYPE, 14340);
    public static final GcStatisticConverter NrOfPageFaultsConverter = new PrototypeConverter(NrOfPageFaults.PROTOTYPE, 47108);
    public static final GcStatisticConverter NrOfMinorPageFaultsConverter = new PrototypeConverter(NrOfMinorPageFaults.PROTOTYPE, 47108);
    public static final GcStatisticConverter NrOfMajorPageFaultsConverter = new PrototypeConverter(NrOfMajorPageFaults.PROTOTYPE, 47108);
    public static final GcStatisticConverter TimestampConverter = new ConverterBase(Timestamp.class){

        @Override
        public int getColumnFlags() {
            return 8192;
        }

        @Override
        ProviderEntry getValue(long elementValue) {
            return new Timestamp(elementValue);
        }
    };
    public static final GcStatisticConverter LoadConverter = new EventConverterBase(LoadAverage.class){

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcStatistic gcStatistic, int eventId) {
            GcEventBase event = gcStatistic.getEvents()[eventId];
            if (element.getType() == 3) {
                long[] load = element.getArrayValue(event);
                return new LoadAverage(load);
            }
            long load = element.getValue(event);
            return new LoadAverage(new long[]{load});
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcEventStatisticValue value, GcEventStatisticValue total) {
            if (element.getType() == 3) {
                long[] load = (long[])value.getElementValue(element);
                return new LoadAverage(load);
            }
            return new LoadAverage(new long[]{(Long)value.getElementValue(element)});
        }
    };

    public ProviderEntry getValue(GcStatisticValueElement var1, GcStatisticValue var2, GcStatisticValue var3);

    public ProviderEntry getValue(GcStatisticValueElement var1, GcStatistic var2);

    public ProviderEntry getValue(GcEventStatisticValueElement var1, GcStatistic var2, int var3);

    public ProviderEntry getValue(GcEventStatisticValueElement var1, GcEventStatisticValue var2, GcEventStatisticValue var3);

    public Class<? extends ProviderEntry> getType();

    public int getColumnFlags();

    public static class MemoryDiffConverter
    extends MultipleElementConverter {
        MemoryDiffConverter(StatisticValueElement before, StatisticValueElement after) {
            super(NrOfBytes.class, before, after);
        }

        @Override
        ProviderEntry convert(long colValue, long[] values) {
            long diff = values[1] - values[0];
            return NrOfBytes.PROTOTYPE.create(diff);
        }

        @Override
        public int getColumnFlags() {
            return 14340;
        }
    }

    public static class MemoryBeforeAndAfterConverter
    extends MultipleElementConverter {
        MemoryBeforeAndAfterConverter(StatisticValueElement before, StatisticValueElement after, StatisticValueElement max) {
            super(MemoryUsageBeforeAndAfter.class, before, after, max);
        }

        @Override
        ProviderEntry convert(long colValue, long[] values) {
            return new MemoryUsageBeforeAndAfter(values[0], values[1], values[2]);
        }
    }

    public static class MemoryUsageConverter
    extends MultipleElementConverter {
        MemoryUsageConverter(StatisticValueElement maxElement) {
            super(MemoryUsage.class, maxElement);
        }

        public MemoryUsageConverter(StatisticValueElement maxElement, StatisticValueElement comittedElement) {
            super(MemoryUsage.class, maxElement, comittedElement);
        }

        @Override
        ProviderEntry convert(long usedVal, long[] values) {
            long committedVal = -1L;
            long maxVal = -1L;
            if (values.length > 0) {
                maxVal = values[0];
                if (values.length > 1) {
                    committedVal = values[1];
                }
            }
            long committed = committedVal < usedVal ? -1L : committedVal;
            return new MemoryUsage(usedVal, maxVal, committed);
        }
    }

    public static abstract class MultipleElementConverter
    implements GcStatisticConverter {
        private StatisticValueElement[] elements;
        private Class<? extends ProviderEntry> type;

        public MultipleElementConverter(Class<? extends ProviderEntry> type, StatisticValueElement ... elements) {
            this.type = type;
            this.elements = elements;
        }

        abstract ProviderEntry convert(long var1, long[] var3);

        @Override
        public ProviderEntry getValue(GcStatisticValueElement columnElement, GcStatisticValue value, GcStatisticValue total) {
            long[] values = new long[this.elements.length];
            for (int i = 0; i < this.elements.length; ++i) {
                GcStatisticValueElement element = (GcStatisticValueElement)this.elements[i];
                values[i] = value.getElementValue(element);
            }
            long colValue = value.getElementValue(columnElement);
            return this.convert(colValue, values);
        }

        @Override
        public ProviderEntry getValue(GcStatisticValueElement columnElement, GcStatistic gcStatistic) {
            long[] values = new long[this.elements.length];
            for (int i = 0; i < this.elements.length; ++i) {
                GcStatisticValueElement element = (GcStatisticValueElement)this.elements[i];
                values[i] = element.getValue(gcStatistic);
            }
            long colValue = columnElement.getValue(gcStatistic);
            return this.convert(colValue, values);
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement columnElement, GcStatistic gcStatistic, int eventId) {
            long[] values = new long[this.elements.length];
            for (int i = 0; i < this.elements.length; ++i) {
                values[i] = this.elements[i] instanceof GcStatisticValueElement ? ((GcStatisticValueElement)this.elements[i]).getValue(gcStatistic) : ((GcEventStatisticValueElement)this.elements[i]).getValue(gcStatistic, eventId);
            }
            long colValue = columnElement.getValue(gcStatistic, eventId);
            return this.convert(colValue, values);
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement columnElement, GcEventStatisticValue value, GcEventStatisticValue total) {
            long[] values = new long[this.elements.length];
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i] instanceof GcStatisticValueElement) {
                    values[i] = value.getGcStatisticData().getElementValue((GcStatisticValueElement)this.elements[i]);
                    continue;
                }
                Object result = value.getElementValue((GcEventStatisticValueElement)this.elements[i]);
                assert (result instanceof Long);
                values[i] = (Long)result;
            }
            Object result = value.getElementValue(columnElement);
            assert (result instanceof Long);
            long colValue = (Long)result;
            return this.convert(colValue, values);
        }

        @Override
        public Class<? extends ProviderEntry> getType() {
            return this.type;
        }

        @Override
        public int getColumnFlags() {
            return 0;
        }
    }

    public static abstract class EventConverterBase
    implements GcStatisticConverter {
        private Class<? extends ProviderEntry> type;

        public EventConverterBase(Class<? extends ProviderEntry> type) {
            this.type = type;
        }

        @Override
        public ProviderEntry getValue(GcStatisticValueElement element, GcStatisticValue value, GcStatisticValue total) {
            throw new UnsupportedOperationException("This converter is usable only for GC event attributes");
        }

        @Override
        public ProviderEntry getValue(GcStatisticValueElement element, GcStatistic gcStatistic) {
            throw new UnsupportedOperationException("This converter is usable only for GC event attributes");
        }

        @Override
        public Class<? extends ProviderEntry> getType() {
            return this.type;
        }

        @Override
        public int getColumnFlags() {
            return 0;
        }
    }

    public static class PrototypeConverter
    implements GcStatisticConverter {
        private final BaseQuantity<?> prototype;
        private final int columnFlags;

        public PrototypeConverter(BaseQuantity<?> prototype, int columnFlags) {
            this.prototype = prototype;
            this.columnFlags = columnFlags;
        }

        protected ProviderEntry getValue(Object elementValue) {
            if (elementValue instanceof Long) {
                long val = (Long)elementValue;
                if (this.skipValue(val)) {
                    return null;
                }
                return this.prototype.create(val);
            }
            assert (false);
            return null;
        }

        @Override
        public ProviderEntry getValue(GcStatisticValueElement element, GcStatisticValue value, GcStatisticValue total) {
            return this.getValue(value.getElementValue(element));
        }

        @Override
        public ProviderEntry getValue(GcStatisticValueElement element, GcStatistic gcStatistic) {
            return this.getValue(element.getValue(gcStatistic));
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcStatistic gcStatistic, int eventId) {
            return this.getValue(element.getValue(gcStatistic, eventId));
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcEventStatisticValue value, GcEventStatisticValue total) {
            return this.getValue(value.getElementValue(element));
        }

        @Override
        public Class<? extends ProviderEntry> getType() {
            return this.prototype.getClass();
        }

        @Override
        public int getColumnFlags() {
            return this.columnFlags;
        }

        protected boolean skipValue(long val) {
            return false;
        }
    }

    public static abstract class ConverterBase
    implements GcStatisticConverter {
        private Class<? extends ProviderEntry> type;

        public ConverterBase(Class<? extends ProviderEntry> type) {
            this.type = type;
        }

        abstract ProviderEntry getValue(long var1);

        protected ProviderEntry getValue(Object elementValue) {
            if (elementValue instanceof Long) {
                return this.getValue((Long)elementValue);
            }
            assert (false);
            return null;
        }

        @Override
        public ProviderEntry getValue(GcStatisticValueElement element, GcStatisticValue value, GcStatisticValue total) {
            return this.getValue(value.getElementValue(element));
        }

        @Override
        public ProviderEntry getValue(GcStatisticValueElement element, GcStatistic gcStatistic) {
            return this.getValue(element.getValue(gcStatistic));
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcStatistic gcStatistic, int eventId) {
            return this.getValue(element.getValue(gcStatistic, eventId));
        }

        @Override
        public ProviderEntry getValue(GcEventStatisticValueElement element, GcEventStatisticValue value, GcEventStatisticValue total) {
            return this.getValue(value.getElementValue(element));
        }

        @Override
        public Class<? extends ProviderEntry> getType() {
            return this.type;
        }

        @Override
        public int getColumnFlags() {
            return 0;
        }
    }
}

