/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.presentation.typed.gc.Attribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcEventAttribute;
import com.sap.jvm.profiling.presentation.typed.gc.GcStatisticAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class GcTimeSeriesMetaData {
    public static final Attribute<?>[] ATTRIBUTE_FOR_TIMESERIES = new Attribute[717];
    private static final String[] GROUP_FOR_TIMESERIES = new String[717];
    private static final Group root = new Group("events root");
    private static Group classunloadingPhase1 = new Group(GcEventType.CLASSUNLOADING_PHASE1.getShortDescrDisplay());
    private static String classunloadingPhase1Details = GcEventType.CLASSUNLOADING_PHASE1.getShortDescrDisplay();
    private static Group classunloadingPhase2 = new Group(GcEventType.CLASSUNLOADING_PHASE2.getShortDescrDisplay());
    private static String classunloadingPhase2Details = GcEventType.CLASSUNLOADING_PHASE2.getShortDescrDisplay();
    private static Group cmsAbortablePrecleaning = new Group(GcEventType.CMS_ABORTABLE_PRECLEANING.getShortDescrDisplay());
    private static String cmsAbortablePrecleaningDetails = GcEventType.CMS_ABORTABLE_PRECLEANING.getShortDescrDisplay();
    private static Group cmsFinalMarking = new Group(GcEventType.CMS_FINAL_MARKING.getShortDescrDisplay());
    private static String cmsFinalMarkingDetails = GcEventType.CMS_FINAL_MARKING.getShortDescrDisplay();
    private static Group cmsInitialMarking = new Group(GcEventType.CMS_INITIAL_MARKING.getShortDescrDisplay());
    private static String cmsInitialMarkingDetails = GcEventType.CMS_INITIAL_MARKING.getShortDescrDisplay();
    private static Group cmsMarking = new Group(GcEventType.CMS_MARKING.getShortDescrDisplay());
    private static String cmsMarkingDetails = GcEventType.CMS_MARKING.getShortDescrDisplay();
    private static Group cmsPrecleaning = new Group(GcEventType.CMS_PRECLEANING.getShortDescrDisplay());
    private static String cmsPrecleaningDetails = GcEventType.CMS_PRECLEANING.getShortDescrDisplay();
    private static Group cmsSweeping = new Group(GcEventType.CMS_SWEEPING.getShortDescrDisplay());
    private static String cmsSweepingDetails = GcEventType.CMS_SWEEPING.getShortDescrDisplay();
    private static Group g1BitmapClearing = new Group(GcEventType.G1_BITMAP_CLEARING.getShortDescrDisplay());
    private static Group g1Cleanup = new Group(GcEventType.G1_CLEANUP.getShortDescrDisplay());
    private static String g1CleanupDetails = GcEventType.G1_CLEANUP.getShortDescrDisplay();
    private static Group g1EmptyRegionsReclaim = new Group(GcEventType.G1_EMPTY_REGIONS_RECLAIM.getShortDescrDisplay());
    private static String g1EmptyRegionsReclaimDetails = GcEventType.G1_EMPTY_REGIONS_RECLAIM.getShortDescrDisplay();
    private static Group g1ConcurrentCleanup = new Group(GcEventType.G1_CONCURRENT_CLEANUP.getShortDescrDisplay());
    private static Group g1Counting = new Group(GcEventType.G1_COUNTING.getShortDescrDisplay());
    private static Group g1FinalMarking = new Group(GcEventType.G1_FINAL_MARKING.getShortDescrDisplay());
    private static String g1FinalMarkingDetails = GcEventType.G1_FINAL_MARKING.getShortDescrDisplay();
    private static Group g1InitialMarking = new Group(GcEventType.G1_INITIAL_MARKING.getShortDescrDisplay());
    private static Group g1Marking = new Group(GcEventType.G1_MARKING.getShortDescrDisplay());
    private static Group g1IncrementalGc = new Group(GcEventType.G1_INCREMENTAL_GC.getShortDescrDisplay());
    private static String g1IncrementalGcDetails = GcEventType.G1_INCREMENTAL_GC.getShortDescrDisplay();
    private static Group g1MarkSweepGc = new Group(GcEventType.G1_MARK_SWEEP_GC.getShortDescrDisplay());
    private static String g1MarkSweepGcDetails = GcEventType.G1_MARK_SWEEP_GC.getShortDescrDisplay();
    private static Group g1ParallelFullGc = new Group(GcEventType.G1_PARALLEL_FULL_GC.getShortDescrDisplay());
    private static String g1ParallelFullGcDetails = GcEventType.G1_PARALLEL_FULL_GC.getShortDescrDisplay();
    private static Group g1RootScanning = new Group(GcEventType.G1_ROOT_SCANNING.getShortDescrDisplay());
    private static Group parallelGcMarkSweep = new Group(GcEventType.PARALLEL_GC_MARK_SWEEP.getShortDescrDisplay());
    private static String parallelGcMarkSweepDetails = GcEventType.PARALLEL_GC_MARK_SWEEP.getShortDescrDisplay();
    private static Group parallelGcParallelCompact = new Group(GcEventType.PARALLEL_GC_PARALLEL_COMPACT.getShortDescrDisplay());
    private static String parallelGcParallelCompactDetails = GcEventType.PARALLEL_GC_PARALLEL_COMPACT.getShortDescrDisplay();
    private static Group parallelGcScavenge = new Group(GcEventType.PARALLEL_GC_SCAVENGE.getShortDescrDisplay());
    private static String parallelGcScavengeDetails = GcEventType.PARALLEL_GC_SCAVENGE.getShortDescrDisplay();
    private static Group parallelNewGc = new Group(GcEventType.PARALLEL_NEW_GC.getShortDescrDisplay());
    private static String parallelNewGcDetails = GcEventType.PARALLEL_NEW_GC.getShortDescrDisplay();
    private static Group serialNewGc = new Group(GcEventType.SERIAL_NEW_GC.getShortDescrDisplay());
    private static Group tenuredGc = new Group(GcEventType.TENURED_GC.getShortDescrDisplay());
    private static String tenuredGcDetails = GcEventType.TENURED_GC.getShortDescrDisplay();
    private static Group allGenRefHandling = new Group(GcEventType.ALL_GEN_REF_HANDLING.getShortDescrDisplay());
    private static String allGenRefHandlingDetails = GcEventType.ALL_GEN_REF_HANDLING.getShortDescrDisplay();
    private static Group oldGenRefHandling = new Group(GcEventType.OLD_GEN_REF_HANDLING.getShortDescrDisplay());
    private static String oldGenRefHandlingDetails = GcEventType.OLD_GEN_REF_HANDLING.getShortDescrDisplay();
    private static Group youngGenRefHandling = new Group(GcEventType.YOUNG_GEN_REF_HANDLING.getShortDescrDisplay());
    private static String youngGenRefHandlingDetails = GcEventType.YOUNG_GEN_REF_HANDLING.getShortDescrDisplay();
    private static Group partialRefHandling = new Group(GcEventType.PARTIAL_REF_HANDLING.getShortDescrDisplay());
    private static String partialRefHandlingDetails = GcEventType.PARTIAL_REF_HANDLING.getShortDescrDisplay();
    private static Group cmsAborted = new Group(GcEventType.CMS_ABORTED.getShortDescrDisplay());
    private static Group parallelSmallGcForcedFullGc = new Group(GcEventType.PARALLEL_GC_SMALL_FORCED_FULL_GC.getShortDescrDisplay());
    private static Group youngGenPromotionFailure = new Group(GcEventType.YOUNG_GEN_PROMOTION_FAILURE.getShortDescrDisplay());
    private static String generational = I18n._tss((I18n.TextType)I18n.TextType.XFLD, (String)"GarbageCollection event/phase", (String)"Generational");
    private static Group other = new Group(I18n._ts((I18n.TextType)I18n.TextType.XFLD, (String)"Other attributes"));

    public static final Group[] getGroups(GcType type, ProfilingSession session) {
        ArrayList<Group> result = new ArrayList<Group>();
        result.add(allGenRefHandling);
        result.add(youngGenRefHandling);
        result.add(youngGenPromotionFailure);
        result.add(classunloadingPhase1);
        result.add(classunloadingPhase2);
        switch (type) {
            case PARALLEL_GC: {
                result.add(parallelGcMarkSweep);
                result.add(parallelGcScavenge);
                result.add(parallelSmallGcForcedFullGc);
                break;
            }
            case PARALLEL_OLD_GC: {
                result.add(parallelGcParallelCompact);
                result.add(parallelGcScavenge);
                result.add(parallelSmallGcForcedFullGc);
                break;
            }
            case SERIAL_GC: {
                result.add(serialNewGc);
                result.add(tenuredGc);
                break;
            }
            case PARALLEL_NEW_GC: {
                result.add(parallelNewGc);
                result.add(tenuredGc);
                break;
            }
            case CONC_MARK_SWEEP_GC: {
                result.add(oldGenRefHandling);
                result.add(serialNewGc);
                result.add(parallelNewGc);
                result.add(tenuredGc);
                result.add(cmsInitialMarking);
                result.add(cmsMarking);
                result.add(cmsFinalMarking);
                result.add(cmsSweeping);
                result.add(cmsPrecleaning);
                result.add(cmsAbortablePrecleaning);
                result.add(cmsAborted);
                break;
            }
            case GARBAGE_FIRST_GC: {
                result.remove(youngGenRefHandling);
                result.add(partialRefHandling);
                result.add(g1BitmapClearing);
                result.add(g1Cleanup);
                result.add(g1EmptyRegionsReclaim);
                result.add(g1ConcurrentCleanup);
                result.add(g1Counting);
                result.add(g1FinalMarking);
                result.add(g1InitialMarking);
                result.add(g1Marking);
                result.add(g1IncrementalGc);
                if (session.getSystemInfo().gcStatisticVersion() < 2) {
                    result.add(g1MarkSweepGc);
                } else {
                    result.add(g1ParallelFullGc);
                }
                result.add(g1RootScanning);
                break;
            }
        }
        if (!other.isEmpty()) {
            result.add(other);
        }
        return (Group[])result.stream().map(g -> g.applicableTo(session, type)).toArray(Group[]::new);
    }

    public static String getDescriptionForTimeSeries(int timeSeriesIdx, ProfilingSession session) {
        Attribute<?> attribute = ATTRIBUTE_FOR_TIMESERIES[timeSeriesIdx];
        String group = GROUP_FOR_TIMESERIES[timeSeriesIdx];
        return group == null ? attribute.getShortDescription(session) : I18n._tss((I18n.TextType)I18n.TextType.XFLD, (String)"Pair of group name and member name", (String)"{0} : {1}", (Object[])new Object[]{group, attribute.getShortDescription(session)});
    }

    private static void add(int timeSeriesIdx, GcStatisticAttribute attribute) {
        GcTimeSeriesMetaData.ATTRIBUTE_FOR_TIMESERIES[timeSeriesIdx] = attribute;
        GcTimeSeriesMetaData.GROUP_FOR_TIMESERIES[timeSeriesIdx] = null;
    }

    private static void add(int timeSeriesIdx, GcEventAttribute attribute, Group group, String ... groupPath) {
        GcTimeSeriesMetaData.ATTRIBUTE_FOR_TIMESERIES[timeSeriesIdx] = attribute;
        GcTimeSeriesMetaData.GROUP_FOR_TIMESERIES[timeSeriesIdx] = group.groupName;
        GcTimeSeriesMetaData.root.addGroupIfMissing(group);
        Group current = group;
        for (String pathElement : groupPath) {
            current = current.addSubGroupIfMissing(pathElement);
        }
        current.addMember(timeSeriesIdx);
    }

    static {
        GcTimeSeriesMetaData.add(0, GcStatisticAttribute.CPU_TIME);
        GcTimeSeriesMetaData.add(1, GcStatisticAttribute.DURATION);
        GcTimeSeriesMetaData.add(2, GcStatisticAttribute.PAGE_FAULTS);
        GcTimeSeriesMetaData.add(3, GcStatisticAttribute.MAJOR_PAGE_FAULTS);
        GcTimeSeriesMetaData.add(4, GcStatisticAttribute.MINOR_PAGE_FAULTS);
        GcTimeSeriesMetaData.add(5, GcStatisticAttribute.NR_OF_ARRAY_CLASSES_AFTER_GC);
        GcTimeSeriesMetaData.add(6, GcStatisticAttribute.NR_OF_ARRAY_CLASSES_BEFORE_GC);
        GcTimeSeriesMetaData.add(7, GcStatisticAttribute.NR_OF_NON_ARRAY_CLASSES_AFTER_GC);
        GcTimeSeriesMetaData.add(8, GcStatisticAttribute.NR_OF_NON_ARRAY_CLASSES_BEFORE_GC);
        GcTimeSeriesMetaData.add(9, GcStatisticAttribute.ALLOCATION_GOAL);
        GcTimeSeriesMetaData.add(10, GcStatisticAttribute.MAX_PAUSE_TIME);
        GcTimeSeriesMetaData.add(11, GcStatisticAttribute.GC_NR);
        GcTimeSeriesMetaData.add(12, GcStatisticAttribute.BYTES_IN_EDEN_AFTER_GC);
        GcTimeSeriesMetaData.add(13, GcStatisticAttribute.BYTES_IN_EDEN_BEFORE_GC);
        GcTimeSeriesMetaData.add(14, GcStatisticAttribute.BYTES_WASTED_BY_TLABS_BEFORE_GC);
        GcTimeSeriesMetaData.add(15, GcStatisticAttribute.BYTES_IN_FROM_AFTER_GC);
        GcTimeSeriesMetaData.add(16, GcStatisticAttribute.BYTES_IN_FROM_BEFORE_GC);
        GcTimeSeriesMetaData.add(17, GcStatisticAttribute.BYTES_IN_OLD_AFTER_GC);
        GcTimeSeriesMetaData.add(18, GcStatisticAttribute.BYTES_IN_OLD_BEFORE_GC);
        GcTimeSeriesMetaData.add(19, GcStatisticAttribute.BYTES_IN_TO_AFTER_GC);
        GcTimeSeriesMetaData.add(20, GcStatisticAttribute.BYTES_IN_TO_BEFORE_GC);
        GcTimeSeriesMetaData.add(21, GcStatisticAttribute.BYTES_IN_NON_PERM_AFTER_GC);
        GcTimeSeriesMetaData.add(22, GcStatisticAttribute.BYTES_IN_NON_PERM_BEFORE_GC);
        GcTimeSeriesMetaData.add(23, GcStatisticAttribute.BYTES_IN_PERM_AFTER_GC);
        GcTimeSeriesMetaData.add(24, GcStatisticAttribute.BYTES_IN_PERM_BEFORE_GC);
        GcTimeSeriesMetaData.add(25, GcStatisticAttribute.BYTES_IN_CLASS_SPACE_AFTER_GC);
        GcTimeSeriesMetaData.add(26, GcStatisticAttribute.BYTES_IN_CLASS_SPACE_BEFORE_GC);
        GcTimeSeriesMetaData.add(27, GcStatisticAttribute.BYTES_IN_YOUNG_AFTER_GC);
        GcTimeSeriesMetaData.add(28, GcStatisticAttribute.BYTES_IN_YOUNG_BEFORE_GC);
        GcTimeSeriesMetaData.add(29, GcStatisticAttribute.COMMITTED_BYTES_IN_EDEN_AFTER_GC);
        GcTimeSeriesMetaData.add(30, GcStatisticAttribute.COMMITTED_BYTES_IN_EDEN_BEFORE_GC);
        GcTimeSeriesMetaData.add(31, GcStatisticAttribute.COMMITTED_BYTES_IN_FROM_AFTER_GC);
        GcTimeSeriesMetaData.add(32, GcStatisticAttribute.COMMITTED_BYTES_IN_FROM_BEFORE_GC);
        GcTimeSeriesMetaData.add(33, GcStatisticAttribute.COMMITTED_BYTES_IN_OLD_AFTER_GC);
        GcTimeSeriesMetaData.add(34, GcStatisticAttribute.COMMITTED_BYTES_IN_OLD_BEFORE_GC);
        GcTimeSeriesMetaData.add(35, GcStatisticAttribute.COMMITTED_BYTES_IN_TO_AFTER_GC);
        GcTimeSeriesMetaData.add(36, GcStatisticAttribute.COMMITTED_BYTES_IN_TO_BEFORE_GC);
        GcTimeSeriesMetaData.add(37, GcStatisticAttribute.COMMITTED_BYTES_IN_YOUNG_AFTER_GC);
        GcTimeSeriesMetaData.add(38, GcStatisticAttribute.COMMITTED_BYTES_IN_YOUNG_BEFORE_GC);
        GcTimeSeriesMetaData.add(39, GcStatisticAttribute.COMMITTED_BYTES_IN_NON_PERM_AFTER_GC);
        GcTimeSeriesMetaData.add(40, GcStatisticAttribute.COMMITTED_BYTES_IN_NON_PERM_BEFORE_GC);
        GcTimeSeriesMetaData.add(41, GcStatisticAttribute.COMMITTED_BYTES_IN_PERM_AFTER_GC);
        GcTimeSeriesMetaData.add(42, GcStatisticAttribute.COMMITTED_BYTES_IN_PERM_BEFORE_GC);
        GcTimeSeriesMetaData.add(43, GcStatisticAttribute.COMMITTED_BYTES_IN_CLASS_SPACE_AFTER_GC);
        GcTimeSeriesMetaData.add(44, GcStatisticAttribute.COMMITTED_BYTES_IN_CLASS_SPACE_BEFORE_GC);
        GcTimeSeriesMetaData.add(45, GcStatisticAttribute.MAX_OLD_GEN_SIZE);
        GcTimeSeriesMetaData.add(46, GcStatisticAttribute.MAX_PERM_GEN_SIZE);
        GcTimeSeriesMetaData.add(47, GcStatisticAttribute.MAX_CLASS_SPACE_SIZE);
        GcTimeSeriesMetaData.add(48, GcStatisticAttribute.MAX_NON_PERM_GEN_SIZE);
        GcTimeSeriesMetaData.add(49, GcStatisticAttribute.MAX_YOUNG_GEN_SIZE);
        GcTimeSeriesMetaData.add(50, GcStatisticAttribute.TENURING_THRESHOLD);
        GcTimeSeriesMetaData.add(51, GcStatisticAttribute.NR_OF_THREADS);
        GcTimeSeriesMetaData.add(52, GcStatisticAttribute.BYTES_FREED_CONCURRENTLY_IN_OLD);
        GcTimeSeriesMetaData.add(53, GcStatisticAttribute.BYTES_FREED_CONCURRENTLY_IN_PERM);
        GcTimeSeriesMetaData.add(54, GcStatisticAttribute.NR_OF_NON_ARRAY_CLASSES_UNLOADED_CONCURRENTLY);
        GcTimeSeriesMetaData.add(55, GcStatisticAttribute.NR_OF_ARRAY_CLASSES_UNLOADED_CONCURRENTLY);
        GcTimeSeriesMetaData.add(56, GcStatisticAttribute.NR_OF_SCAVENGE_THREADS);
        GcTimeSeriesMetaData.add(57, GcStatisticAttribute.BYTES_FREED_CONCURRENTLY);
        GcTimeSeriesMetaData.add(58, GcStatisticAttribute.COMMITTED_REGIONS_BEFORE_GC);
        GcTimeSeriesMetaData.add(59, GcStatisticAttribute.COMMITTED_REGIONS_AFTER_GC);
        GcTimeSeriesMetaData.add(60, GcStatisticAttribute.FREE_REGIONS_BEFORE_GC);
        GcTimeSeriesMetaData.add(61, GcStatisticAttribute.FREE_REGIONS_AFTER_GC);
        GcTimeSeriesMetaData.add(62, GcStatisticAttribute.HUMONGOUS_REGIONS_BEFORE_GC);
        GcTimeSeriesMetaData.add(63, GcStatisticAttribute.HUMONGOUS_REGIONS_AFTER_GC);
        GcTimeSeriesMetaData.add(64, GcStatisticAttribute.HUMONGOUS_START_REGIONS_BEFORE_GC);
        GcTimeSeriesMetaData.add(65, GcStatisticAttribute.HUMONGOUS_START_REGIONS_AFTER_GC);
        GcTimeSeriesMetaData.add(66, GcStatisticAttribute.YOUNG_REGIONS_BEFORE_GC);
        GcTimeSeriesMetaData.add(67, GcStatisticAttribute.YOUNG_REGIONS_AFTER_GC);
        GcTimeSeriesMetaData.add(68, GcStatisticAttribute.SURVIVOR_REGIONS_BEFORE_GC);
        GcTimeSeriesMetaData.add(69, GcStatisticAttribute.SURVIVOR_REGIONS_AFTER_GC);
        GcTimeSeriesMetaData.add(70, GcStatisticAttribute.YOUNG_LIST_TARGET_REGIONS_BEFORE_GC);
        GcTimeSeriesMetaData.add(71, GcStatisticAttribute.YOUNG_LIST_TARGET_REGIONS_AFTER_GC);
        GcTimeSeriesMetaData.add(72, GcStatisticAttribute.YOUNG_LIST_MAXIMUM_REGIONS_BEFORE_GC);
        GcTimeSeriesMetaData.add(73, GcStatisticAttribute.YOUNG_LIST_MAXIMUM_REGIONS_AFTER_GC);
        GcTimeSeriesMetaData.add(74, GcStatisticAttribute.NR_OF_COMPACT_THREADS);
        GcTimeSeriesMetaData.add(75, GcEventAttribute.NR_OF_NON_ARRAY_CLASSES_BEFORE, classunloadingPhase1, classunloadingPhase1Details);
        GcTimeSeriesMetaData.add(76, GcEventAttribute.NR_OF_NON_ARRAY_CLASSES_AFTER, classunloadingPhase1, classunloadingPhase1Details);
        GcTimeSeriesMetaData.add(77, GcEventAttribute.NR_OF_ARRAY_CLASSES_BEFORE, classunloadingPhase1, classunloadingPhase1Details);
        GcTimeSeriesMetaData.add(78, GcEventAttribute.NR_OF_ARRAY_CLASSES_AFTER, classunloadingPhase1, classunloadingPhase1Details);
        GcTimeSeriesMetaData.add(79, GcEventAttribute.CPU_TIME, classunloadingPhase1, new String[0]);
        GcTimeSeriesMetaData.add(80, GcEventAttribute.DURATION, classunloadingPhase1, new String[0]);
        GcTimeSeriesMetaData.add(81, GcEventAttribute.PAGE_FAULTS, classunloadingPhase1, new String[0]);
        GcTimeSeriesMetaData.add(82, GcEventAttribute.MAJOR_PAGE_FAULTS, classunloadingPhase1, new String[0]);
        GcTimeSeriesMetaData.add(83, GcEventAttribute.MINOR_PAGE_FAULTS, classunloadingPhase1, new String[0]);
        GcTimeSeriesMetaData.add(84, GcEventAttribute.METASPACE_USED_BEFORE, classunloadingPhase2, classunloadingPhase2Details);
        GcTimeSeriesMetaData.add(85, GcEventAttribute.METASPACE_USED_AFTER, classunloadingPhase2, classunloadingPhase2Details);
        GcTimeSeriesMetaData.add(86, GcEventAttribute.METASPACE_COMMITTED_BEFORE, classunloadingPhase2, classunloadingPhase2Details);
        GcTimeSeriesMetaData.add(87, GcEventAttribute.METASPACE_COMMITTED_AFTER, classunloadingPhase2, classunloadingPhase2Details);
        GcTimeSeriesMetaData.add(88, GcEventAttribute.CLASS_SPACE_USED_BEFORE, classunloadingPhase2, classunloadingPhase2Details);
        GcTimeSeriesMetaData.add(89, GcEventAttribute.CLASS_SPACE_USED_AFTER, classunloadingPhase2, classunloadingPhase2Details);
        GcTimeSeriesMetaData.add(90, GcEventAttribute.CLASS_SPACE_COMMITTED_BEFORE, classunloadingPhase2, classunloadingPhase2Details);
        GcTimeSeriesMetaData.add(91, GcEventAttribute.CLASS_SPACE_COMMITTED_AFTER, classunloadingPhase2, classunloadingPhase2Details);
        GcTimeSeriesMetaData.add(92, GcEventAttribute.CPU_TIME, classunloadingPhase2, new String[0]);
        GcTimeSeriesMetaData.add(93, GcEventAttribute.DURATION, classunloadingPhase2, new String[0]);
        GcTimeSeriesMetaData.add(94, GcEventAttribute.PAGE_FAULTS, classunloadingPhase2, new String[0]);
        GcTimeSeriesMetaData.add(95, GcEventAttribute.MAJOR_PAGE_FAULTS, classunloadingPhase2, new String[0]);
        GcTimeSeriesMetaData.add(96, GcEventAttribute.MINOR_PAGE_FAULTS, classunloadingPhase2, new String[0]);
        GcTimeSeriesMetaData.add(97, GcEventAttribute.NR_OF_CARDS_CLEANED, cmsAbortablePrecleaning, cmsAbortablePrecleaningDetails);
        GcTimeSeriesMetaData.add(98, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, cmsAbortablePrecleaning, cmsAbortablePrecleaningDetails);
        GcTimeSeriesMetaData.add(99, GcEventAttribute.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, cmsAbortablePrecleaning, cmsAbortablePrecleaningDetails);
        GcTimeSeriesMetaData.add(100, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING, cmsAbortablePrecleaning, cmsAbortablePrecleaningDetails);
        GcTimeSeriesMetaData.add(101, GcEventAttribute.CPU_TIME, cmsAbortablePrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(102, GcEventAttribute.DURATION, cmsAbortablePrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(103, GcEventAttribute.PAGE_FAULTS, cmsAbortablePrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(104, GcEventAttribute.MAJOR_PAGE_FAULTS, cmsAbortablePrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(105, GcEventAttribute.MINOR_PAGE_FAULTS, cmsAbortablePrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(106, GcEventAttribute.NR_OF_THREADS, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(107, GcEventAttribute.NR_OF_CARDS_CLEANED, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(108, GcEventAttribute.NR_OF_ARRAY_CLASSES_UNLOADED, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(109, GcEventAttribute.NR_OF_NON_ARRAY_CLASSES_UNLOADED, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(110, GcEventAttribute.REMARKING_DURATION, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(111, GcEventAttribute.REMARKING_CPU_TIME, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(112, GcEventAttribute.CLASS_UNLOADING_DURATION, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(113, GcEventAttribute.CLASS_UNLOADING_CPU_TIME, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(114, GcEventAttribute.SYMBOL_UNLOADING_DURATION, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(115, GcEventAttribute.SYMBOL_UNLOADING_CPU_TIME, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(116, GcEventAttribute.REFERENCE_HANDLING_DURATION, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(117, GcEventAttribute.REFERENCE_HANDLING_CPU_TIME, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(118, GcEventAttribute.REFERENCE_ENQUEUEING_DURATION, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(119, GcEventAttribute.REFERENCE_ENQUEUEING_CPU_TIME, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(120, GcEventAttribute.SUCCESSFUL_STEALS, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(121, GcEventAttribute.FAILED_STEALS, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(122, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILLS, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(123, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILL_OBJECTS, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(124, GcEventAttribute.FAILED_OVERFLOW_REFILLS, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(125, GcEventAttribute.FAILED_STEALS_WITH_YIELD, cmsFinalMarking, cmsFinalMarkingDetails);
        GcTimeSeriesMetaData.add(126, GcEventAttribute.CPU_TIME, cmsFinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(127, GcEventAttribute.DURATION, cmsFinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(128, GcEventAttribute.PAGE_FAULTS, cmsFinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(129, GcEventAttribute.MAJOR_PAGE_FAULTS, cmsFinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(130, GcEventAttribute.MINOR_PAGE_FAULTS, cmsFinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(131, GcEventAttribute.NR_OF_THREADS, cmsInitialMarking, cmsInitialMarkingDetails);
        GcTimeSeriesMetaData.add(132, GcEventAttribute.BYTES_IN_OLD, cmsInitialMarking, cmsInitialMarkingDetails);
        GcTimeSeriesMetaData.add(133, GcEventAttribute.COMMITTED_BYTES_IN_OLD, cmsInitialMarking, cmsInitialMarkingDetails);
        GcTimeSeriesMetaData.add(134, GcEventAttribute.PERM_USED, cmsInitialMarking, cmsInitialMarkingDetails);
        GcTimeSeriesMetaData.add(135, GcEventAttribute.PERM_COMMITTED, cmsInitialMarking, cmsInitialMarkingDetails);
        GcTimeSeriesMetaData.add(136, GcEventAttribute.NR_OF_NON_ARRAY_CLASSES, cmsInitialMarking, cmsInitialMarkingDetails);
        GcTimeSeriesMetaData.add(137, GcEventAttribute.NR_OF_ARRAY_CLASSES, cmsInitialMarking, cmsInitialMarkingDetails);
        GcTimeSeriesMetaData.add(138, GcEventAttribute.CPU_TIME, cmsInitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(139, GcEventAttribute.DURATION, cmsInitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(140, GcEventAttribute.PAGE_FAULTS, cmsInitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(141, GcEventAttribute.MAJOR_PAGE_FAULTS, cmsInitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(142, GcEventAttribute.MINOR_PAGE_FAULTS, cmsInitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(143, GcEventAttribute.SUCCESSFUL_STEALS, cmsMarking, cmsMarkingDetails);
        GcTimeSeriesMetaData.add(144, GcEventAttribute.FAILED_STEALS, cmsMarking, cmsMarkingDetails);
        GcTimeSeriesMetaData.add(145, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILLS, cmsMarking, cmsMarkingDetails);
        GcTimeSeriesMetaData.add(146, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILL_OBJECTS, cmsMarking, cmsMarkingDetails);
        GcTimeSeriesMetaData.add(147, GcEventAttribute.FAILED_OVERFLOW_REFILLS, cmsMarking, cmsMarkingDetails);
        GcTimeSeriesMetaData.add(148, GcEventAttribute.FAILED_STEALS_WITH_YIELD, cmsMarking, cmsMarkingDetails);
        GcTimeSeriesMetaData.add(149, GcEventAttribute.NR_OF_GC_THREADS, cmsMarking, cmsMarkingDetails);
        GcTimeSeriesMetaData.add(150, GcEventAttribute.CPU_TIME, cmsMarking, new String[0]);
        GcTimeSeriesMetaData.add(151, GcEventAttribute.DURATION, cmsMarking, new String[0]);
        GcTimeSeriesMetaData.add(152, GcEventAttribute.PAGE_FAULTS, cmsMarking, new String[0]);
        GcTimeSeriesMetaData.add(153, GcEventAttribute.MAJOR_PAGE_FAULTS, cmsMarking, new String[0]);
        GcTimeSeriesMetaData.add(154, GcEventAttribute.MINOR_PAGE_FAULTS, cmsMarking, new String[0]);
        GcTimeSeriesMetaData.add(155, GcEventAttribute.NR_OF_CARDS_CLEANED, cmsPrecleaning, cmsPrecleaningDetails);
        GcTimeSeriesMetaData.add(156, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, cmsPrecleaning, cmsPrecleaningDetails);
        GcTimeSeriesMetaData.add(157, GcEventAttribute.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, cmsPrecleaning, cmsPrecleaningDetails);
        GcTimeSeriesMetaData.add(158, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING, cmsPrecleaning, cmsPrecleaningDetails);
        GcTimeSeriesMetaData.add(159, GcEventAttribute.CPU_TIME, cmsPrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(160, GcEventAttribute.DURATION, cmsPrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(161, GcEventAttribute.PAGE_FAULTS, cmsPrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(162, GcEventAttribute.MAJOR_PAGE_FAULTS, cmsPrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(163, GcEventAttribute.MINOR_PAGE_FAULTS, cmsPrecleaning, new String[0]);
        GcTimeSeriesMetaData.add(164, GcEventAttribute.BYTES_ALLOCATED_IN_OLD, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(165, GcEventAttribute.BYTES_ALLOCATED_IN_PERM, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(166, GcEventAttribute.BYTES_FREED_IN_OLD, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(167, GcEventAttribute.BYTES_FREED_IN_PERM, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(168, GcEventAttribute.BYTES_PROMOTED_TO_OLD, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(169, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(170, GcEventAttribute.NR_OF_NON_COALESCABLE_BLOCKS_IN_OLD, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(171, GcEventAttribute.SIZE_OF_NON_COALESCABLE_BLOCKS_IN_OLD, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(172, GcEventAttribute.NR_OF_NON_COALESCABLE_BLOCKS_IN_PERM, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(173, GcEventAttribute.SIZE_OF_NON_COALESCABLE_BLOCKS_IN_PERM, cmsSweeping, cmsSweepingDetails);
        GcTimeSeriesMetaData.add(174, GcEventAttribute.CPU_TIME, cmsSweeping, new String[0]);
        GcTimeSeriesMetaData.add(175, GcEventAttribute.DURATION, cmsSweeping, new String[0]);
        GcTimeSeriesMetaData.add(176, GcEventAttribute.PAGE_FAULTS, cmsSweeping, new String[0]);
        GcTimeSeriesMetaData.add(177, GcEventAttribute.MAJOR_PAGE_FAULTS, cmsSweeping, new String[0]);
        GcTimeSeriesMetaData.add(178, GcEventAttribute.MINOR_PAGE_FAULTS, cmsSweeping, new String[0]);
        GcTimeSeriesMetaData.add(179, GcEventAttribute.CLEARED_BITMAP_BYTES, g1BitmapClearing, new String[0]);
        GcTimeSeriesMetaData.add(180, GcEventAttribute.YIELD_COUNT, g1BitmapClearing, new String[0]);
        GcTimeSeriesMetaData.add(181, GcEventAttribute.CPU_TIME, g1BitmapClearing, new String[0]);
        GcTimeSeriesMetaData.add(182, GcEventAttribute.DURATION, g1BitmapClearing, new String[0]);
        GcTimeSeriesMetaData.add(183, GcEventAttribute.PAGE_FAULTS, g1BitmapClearing, new String[0]);
        GcTimeSeriesMetaData.add(184, GcEventAttribute.MAJOR_PAGE_FAULTS, g1BitmapClearing, new String[0]);
        GcTimeSeriesMetaData.add(185, GcEventAttribute.MINOR_PAGE_FAULTS, g1BitmapClearing, new String[0]);
        GcTimeSeriesMetaData.add(186, GcEventAttribute.NR_OF_GC_THREADS, g1Cleanup, g1CleanupDetails);
        GcTimeSeriesMetaData.add(187, GcEventAttribute.BYTES_IN_NON_PERM_BEFORE, g1Cleanup, g1CleanupDetails);
        GcTimeSeriesMetaData.add(188, GcEventAttribute.LIVE_BYTES_IN_NON_PERM, g1Cleanup, g1CleanupDetails);
        GcTimeSeriesMetaData.add(189, GcEventAttribute.GARBAGE_REGION_COUNT, g1Cleanup, g1CleanupDetails);
        GcTimeSeriesMetaData.add(190, GcEventAttribute.BYTES_IN_GARBAGE_REGIONS, g1Cleanup, g1CleanupDetails);
        GcTimeSeriesMetaData.add(191, GcEventAttribute.CPU_TIME, g1Cleanup, new String[0]);
        GcTimeSeriesMetaData.add(192, GcEventAttribute.DURATION, g1Cleanup, new String[0]);
        GcTimeSeriesMetaData.add(193, GcEventAttribute.PAGE_FAULTS, g1Cleanup, new String[0]);
        GcTimeSeriesMetaData.add(194, GcEventAttribute.MAJOR_PAGE_FAULTS, g1Cleanup, new String[0]);
        GcTimeSeriesMetaData.add(195, GcEventAttribute.MINOR_PAGE_FAULTS, g1Cleanup, new String[0]);
        GcTimeSeriesMetaData.add(196, GcEventAttribute.NR_OF_GC_THREADS, g1EmptyRegionsReclaim, g1EmptyRegionsReclaimDetails);
        GcTimeSeriesMetaData.add(197, GcEventAttribute.BYTES_IN_NON_PERM_BEFORE, g1EmptyRegionsReclaim, g1EmptyRegionsReclaimDetails);
        GcTimeSeriesMetaData.add(198, GcEventAttribute.LIVE_BYTES_IN_NON_PERM, g1EmptyRegionsReclaim, g1EmptyRegionsReclaimDetails);
        GcTimeSeriesMetaData.add(199, GcEventAttribute.GARBAGE_REGION_COUNT, g1EmptyRegionsReclaim, g1EmptyRegionsReclaimDetails);
        GcTimeSeriesMetaData.add(200, GcEventAttribute.BYTES_IN_GARBAGE_REGIONS, g1EmptyRegionsReclaim, g1EmptyRegionsReclaimDetails);
        GcTimeSeriesMetaData.add(201, GcEventAttribute.CPU_TIME, g1EmptyRegionsReclaim, new String[0]);
        GcTimeSeriesMetaData.add(202, GcEventAttribute.DURATION, g1EmptyRegionsReclaim, new String[0]);
        GcTimeSeriesMetaData.add(203, GcEventAttribute.PAGE_FAULTS, g1EmptyRegionsReclaim, new String[0]);
        GcTimeSeriesMetaData.add(204, GcEventAttribute.MAJOR_PAGE_FAULTS, g1EmptyRegionsReclaim, new String[0]);
        GcTimeSeriesMetaData.add(205, GcEventAttribute.MINOR_PAGE_FAULTS, g1EmptyRegionsReclaim, new String[0]);
        GcTimeSeriesMetaData.add(206, GcEventAttribute.REGIONS_TO_BE_CLEANED_COUNT, g1ConcurrentCleanup, new String[0]);
        GcTimeSeriesMetaData.add(207, GcEventAttribute.BYTES_FREED_IN_NON_PERM, g1ConcurrentCleanup, new String[0]);
        GcTimeSeriesMetaData.add(208, GcEventAttribute.CPU_TIME, g1ConcurrentCleanup, new String[0]);
        GcTimeSeriesMetaData.add(209, GcEventAttribute.DURATION, g1ConcurrentCleanup, new String[0]);
        GcTimeSeriesMetaData.add(210, GcEventAttribute.PAGE_FAULTS, g1ConcurrentCleanup, new String[0]);
        GcTimeSeriesMetaData.add(211, GcEventAttribute.MAJOR_PAGE_FAULTS, g1ConcurrentCleanup, new String[0]);
        GcTimeSeriesMetaData.add(212, GcEventAttribute.MINOR_PAGE_FAULTS, g1ConcurrentCleanup, new String[0]);
        GcTimeSeriesMetaData.add(213, GcEventAttribute.NR_OF_ITERATIONS, g1Counting, new String[0]);
        GcTimeSeriesMetaData.add(214, GcEventAttribute.CPU_TIME, g1Counting, new String[0]);
        GcTimeSeriesMetaData.add(215, GcEventAttribute.DURATION, g1Counting, new String[0]);
        GcTimeSeriesMetaData.add(216, GcEventAttribute.PAGE_FAULTS, g1Counting, new String[0]);
        GcTimeSeriesMetaData.add(217, GcEventAttribute.MAJOR_PAGE_FAULTS, g1Counting, new String[0]);
        GcTimeSeriesMetaData.add(218, GcEventAttribute.MINOR_PAGE_FAULTS, g1Counting, new String[0]);
        GcTimeSeriesMetaData.add(219, GcEventAttribute.NR_OF_THREADS, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(220, GcEventAttribute.REMARKING_DURATION, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(221, GcEventAttribute.REMARKING_CPU_TIME, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(222, GcEventAttribute.SYMBOL_UNLOADING_DURATION, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(223, GcEventAttribute.SYMBOL_UNLOADING_CPU_TIME, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(224, GcEventAttribute.REFERENCE_HANDLING_DURATION, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(225, GcEventAttribute.REFERENCE_HANDLING_CPU_TIME, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(226, GcEventAttribute.REFERENCE_ENQUEUEING_DURATION, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(227, GcEventAttribute.REFERENCE_ENQUEUEING_CPU_TIME, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(228, GcEventAttribute.SUCCESSFUL_STEALS, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(229, GcEventAttribute.FAILED_STEALS, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(230, GcEventAttribute.NR_OF_BYTES_SCANNED, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(231, GcEventAttribute.NR_OF_OBJECT_REFERENCES_REACHED, g1FinalMarking, g1FinalMarkingDetails);
        GcTimeSeriesMetaData.add(232, GcEventAttribute.CPU_TIME, g1FinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(233, GcEventAttribute.DURATION, g1FinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(234, GcEventAttribute.PAGE_FAULTS, g1FinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(235, GcEventAttribute.MAJOR_PAGE_FAULTS, g1FinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(236, GcEventAttribute.MINOR_PAGE_FAULTS, g1FinalMarking, new String[0]);
        GcTimeSeriesMetaData.add(237, GcEventAttribute.NR_OF_THREADS, g1InitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(238, GcEventAttribute.BYTES_IN_NON_PERM_AFTER, g1InitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(239, GcEventAttribute.COMMITTED_BYTES_IN_NON_PERM_AFTER, g1InitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(240, GcEventAttribute.CPU_TIME, g1InitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(241, GcEventAttribute.DURATION, g1InitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(242, GcEventAttribute.PAGE_FAULTS, g1InitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(243, GcEventAttribute.MAJOR_PAGE_FAULTS, g1InitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(244, GcEventAttribute.MINOR_PAGE_FAULTS, g1InitialMarking, new String[0]);
        GcTimeSeriesMetaData.add(245, GcEventAttribute.NR_OF_THREADS, g1Marking, new String[0]);
        GcTimeSeriesMetaData.add(246, GcEventAttribute.SUCCESSFUL_STEALS, g1Marking, new String[0]);
        GcTimeSeriesMetaData.add(247, GcEventAttribute.FAILED_STEALS, g1Marking, new String[0]);
        GcTimeSeriesMetaData.add(248, GcEventAttribute.CPU_TIME, g1Marking, new String[0]);
        GcTimeSeriesMetaData.add(249, GcEventAttribute.DURATION, g1Marking, new String[0]);
        GcTimeSeriesMetaData.add(250, GcEventAttribute.PAGE_FAULTS, g1Marking, new String[0]);
        GcTimeSeriesMetaData.add(251, GcEventAttribute.MAJOR_PAGE_FAULTS, g1Marking, new String[0]);
        GcTimeSeriesMetaData.add(252, GcEventAttribute.MINOR_PAGE_FAULTS, g1Marking, new String[0]);
        GcTimeSeriesMetaData.add(253, GcEventAttribute.NR_OF_THREADS, g1RootScanning, new String[0]);
        GcTimeSeriesMetaData.add(254, GcEventAttribute.SCANNED_ROOT_REGIONS, g1RootScanning, new String[0]);
        GcTimeSeriesMetaData.add(255, GcEventAttribute.CPU_TIME, g1RootScanning, new String[0]);
        GcTimeSeriesMetaData.add(256, GcEventAttribute.DURATION, g1RootScanning, new String[0]);
        GcTimeSeriesMetaData.add(257, GcEventAttribute.PAGE_FAULTS, g1RootScanning, new String[0]);
        GcTimeSeriesMetaData.add(258, GcEventAttribute.MAJOR_PAGE_FAULTS, g1RootScanning, new String[0]);
        GcTimeSeriesMetaData.add(259, GcEventAttribute.MINOR_PAGE_FAULTS, g1RootScanning, new String[0]);
        GcTimeSeriesMetaData.add(260, GcEventAttribute.NR_OF_THREADS, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(261, GcEventAttribute.REFERENCE_HANDLING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(262, GcEventAttribute.SUCCESSFUL_STEALS, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(263, GcEventAttribute.FAILED_STEALS, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(264, GcEventAttribute.FAILED_STEALS_WITH_YIELD, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(265, GcEventAttribute.YOUNG_PLABSIZE, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(266, GcEventAttribute.OLD_PLABSIZE, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(267, GcEventAttribute.CONCURRENT_MARKING_ROOT_SCAN_WAIT_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(268, GcEventAttribute.PARALLEL_ROOT_SCANNING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(269, GcEventAttribute.PARALLEL_SNAPSHOT_AT_THE_BEGINNING_FILTERING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(270, GcEventAttribute.PARALLEL_REMEMBERED_SET_UPDATING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(271, GcEventAttribute.BUFFERS_PROCESSED_DURING_PARALLEL_REMEMBERED_SET_UPDATING, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(272, GcEventAttribute.PARALLEL_REMEMBERED_SET_SCANNING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(273, GcEventAttribute.PARALLEL_OBJECT_COPYING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(274, GcEventAttribute.CARD_TABLE_CLEARING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(275, GcEventAttribute.COLLECTION_SET_CHOOSING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(276, GcEventAttribute.COLLECTION_SET_FREEING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(277, GcEventAttribute.REFERENCE_ENQUEUEING_DURATION, g1IncrementalGc, g1IncrementalGcDetails);
        GcTimeSeriesMetaData.add(289, GcEventAttribute.BYTES_IN_EDEN_AFTER, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(290, GcEventAttribute.BYTES_IN_EDEN_BEFORE, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(291, GcEventAttribute.BYTES_IN_FROM_AFTER, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(292, GcEventAttribute.BYTES_IN_FROM_BEFORE, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(293, GcEventAttribute.BYTES_IN_OLD_AFTER, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(294, GcEventAttribute.BYTES_IN_OLD_BEFORE, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(295, GcEventAttribute.BYTES_IN_PERM_AFTER, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(296, GcEventAttribute.BYTES_IN_PERM_BEFORE, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(297, GcEventAttribute.BYTES_IN_TO_AFTER, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(298, GcEventAttribute.BYTES_IN_TO_BEFORE, g1IncrementalGc, generational);
        GcTimeSeriesMetaData.add(299, GcEventAttribute.CPU_TIME, g1IncrementalGc, new String[0]);
        GcTimeSeriesMetaData.add(300, GcEventAttribute.DURATION, g1IncrementalGc, new String[0]);
        GcTimeSeriesMetaData.add(301, GcEventAttribute.PAGE_FAULTS, g1IncrementalGc, new String[0]);
        GcTimeSeriesMetaData.add(302, GcEventAttribute.MAJOR_PAGE_FAULTS, g1IncrementalGc, new String[0]);
        GcTimeSeriesMetaData.add(303, GcEventAttribute.MINOR_PAGE_FAULTS, g1IncrementalGc, new String[0]);
        GcTimeSeriesMetaData.add(304, GcEventAttribute.ALLOWED_NON_PERM_DEAD_SPACE, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(305, GcEventAttribute.ALLOWED_PERM_DEAD_SPACE, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(306, GcEventAttribute.NR_OF_UNLOADED_CLASSES, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(307, GcEventAttribute.USED_NON_PERM_DEAD_SPACE, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(308, GcEventAttribute.USED_PERM_DEAD_SPACE, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(309, GcEventAttribute.PHASE_1_DURATION, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(310, GcEventAttribute.PHASE_1_CPU_TIME, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(311, GcEventAttribute.PHASE_2_DURATION, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(312, GcEventAttribute.PHASE_2_CPU_TIME, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(313, GcEventAttribute.PHASE_3_DURATION, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(314, GcEventAttribute.PHASE_3_CPU_TIME, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(315, GcEventAttribute.PHASE_4_DURATION, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(316, GcEventAttribute.PHASE_4_CPU_TIME, g1MarkSweepGc, g1MarkSweepGcDetails);
        GcTimeSeriesMetaData.add(317, GcEventAttribute.BYTES_IN_EDEN_AFTER, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(318, GcEventAttribute.BYTES_IN_EDEN_BEFORE, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(319, GcEventAttribute.BYTES_IN_FROM_AFTER, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(320, GcEventAttribute.BYTES_IN_FROM_BEFORE, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(321, GcEventAttribute.BYTES_IN_OLD_AFTER, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(322, GcEventAttribute.BYTES_IN_OLD_BEFORE, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(323, GcEventAttribute.BYTES_IN_PERM_AFTER, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(324, GcEventAttribute.BYTES_IN_PERM_BEFORE, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(325, GcEventAttribute.BYTES_IN_TO_AFTER, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(326, GcEventAttribute.BYTES_IN_TO_BEFORE, g1MarkSweepGc, generational);
        GcTimeSeriesMetaData.add(327, GcEventAttribute.CPU_TIME, g1MarkSweepGc, new String[0]);
        GcTimeSeriesMetaData.add(328, GcEventAttribute.DURATION, g1MarkSweepGc, new String[0]);
        GcTimeSeriesMetaData.add(329, GcEventAttribute.PAGE_FAULTS, g1MarkSweepGc, new String[0]);
        GcTimeSeriesMetaData.add(330, GcEventAttribute.MAJOR_PAGE_FAULTS, g1MarkSweepGc, new String[0]);
        GcTimeSeriesMetaData.add(331, GcEventAttribute.MINOR_PAGE_FAULTS, g1MarkSweepGc, new String[0]);
        GcTimeSeriesMetaData.add(332, GcEventAttribute.NR_OF_THREADS, g1ParallelFullGc, g1ParallelFullGcDetails);
        GcTimeSeriesMetaData.add(333, GcEventAttribute.PHASE_1_DURATION, g1ParallelFullGc, g1ParallelFullGcDetails);
        GcTimeSeriesMetaData.add(334, GcEventAttribute.PHASE_1_CPU_TIME, g1ParallelFullGc, g1ParallelFullGcDetails);
        GcTimeSeriesMetaData.add(335, GcEventAttribute.PHASE_2_DURATION, g1ParallelFullGc, g1ParallelFullGcDetails);
        GcTimeSeriesMetaData.add(336, GcEventAttribute.PHASE_2_CPU_TIME, g1ParallelFullGc, g1ParallelFullGcDetails);
        GcTimeSeriesMetaData.add(337, GcEventAttribute.PHASE_3_DURATION, g1ParallelFullGc, g1ParallelFullGcDetails);
        GcTimeSeriesMetaData.add(338, GcEventAttribute.PHASE_3_CPU_TIME, g1ParallelFullGc, g1ParallelFullGcDetails);
        GcTimeSeriesMetaData.add(339, GcEventAttribute.PHASE_4_DURATION, g1ParallelFullGc, g1ParallelFullGcDetails);
        GcTimeSeriesMetaData.add(340, GcEventAttribute.PHASE_4_CPU_TIME, g1ParallelFullGc, g1ParallelFullGcDetails);
        GcTimeSeriesMetaData.add(341, GcEventAttribute.BYTES_IN_EDEN_AFTER, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(342, GcEventAttribute.BYTES_IN_EDEN_BEFORE, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(343, GcEventAttribute.BYTES_IN_FROM_AFTER, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(344, GcEventAttribute.BYTES_IN_FROM_BEFORE, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(345, GcEventAttribute.BYTES_IN_OLD_AFTER, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(346, GcEventAttribute.BYTES_IN_OLD_BEFORE, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(347, GcEventAttribute.BYTES_IN_PERM_AFTER, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(348, GcEventAttribute.BYTES_IN_PERM_BEFORE, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(349, GcEventAttribute.BYTES_IN_TO_AFTER, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(350, GcEventAttribute.BYTES_IN_TO_BEFORE, g1ParallelFullGc, generational);
        GcTimeSeriesMetaData.add(351, GcEventAttribute.CPU_TIME, g1ParallelFullGc, new String[0]);
        GcTimeSeriesMetaData.add(352, GcEventAttribute.DURATION, g1ParallelFullGc, new String[0]);
        GcTimeSeriesMetaData.add(353, GcEventAttribute.PAGE_FAULTS, g1ParallelFullGc, new String[0]);
        GcTimeSeriesMetaData.add(354, GcEventAttribute.MAJOR_PAGE_FAULTS, g1ParallelFullGc, new String[0]);
        GcTimeSeriesMetaData.add(355, GcEventAttribute.MINOR_PAGE_FAULTS, g1ParallelFullGc, new String[0]);
        GcTimeSeriesMetaData.add(356, GcEventAttribute.ALLOWED_NON_PERM_DEAD_SPACE, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(357, GcEventAttribute.ALLOWED_PERM_DEAD_SPACE, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(358, GcEventAttribute.NR_OF_UNLOADED_CLASSES, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(359, GcEventAttribute.USED_NON_PERM_DEAD_SPACE, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(360, GcEventAttribute.USED_PERM_DEAD_SPACE, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(361, GcEventAttribute.PHASE_1_DURATION, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(362, GcEventAttribute.PHASE_1_CPU_TIME, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(363, GcEventAttribute.PHASE_2_DURATION, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(364, GcEventAttribute.PHASE_2_CPU_TIME, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(365, GcEventAttribute.PHASE_3_DURATION, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(366, GcEventAttribute.PHASE_3_CPU_TIME, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(367, GcEventAttribute.PHASE_4_DURATION, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(368, GcEventAttribute.PHASE_4_CPU_TIME, parallelGcMarkSweep, parallelGcMarkSweepDetails);
        GcTimeSeriesMetaData.add(369, GcEventAttribute.BYTES_IN_EDEN_AFTER, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(370, GcEventAttribute.BYTES_IN_EDEN_BEFORE, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(371, GcEventAttribute.BYTES_IN_FROM_AFTER, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(372, GcEventAttribute.BYTES_IN_FROM_BEFORE, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(373, GcEventAttribute.BYTES_IN_OLD_AFTER, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(374, GcEventAttribute.BYTES_IN_OLD_BEFORE, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(375, GcEventAttribute.BYTES_IN_PERM_AFTER, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(376, GcEventAttribute.BYTES_IN_PERM_BEFORE, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(377, GcEventAttribute.BYTES_IN_TO_AFTER, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(378, GcEventAttribute.BYTES_IN_TO_BEFORE, parallelGcMarkSweep, generational);
        GcTimeSeriesMetaData.add(379, GcEventAttribute.CPU_TIME, parallelGcMarkSweep, new String[0]);
        GcTimeSeriesMetaData.add(380, GcEventAttribute.DURATION, parallelGcMarkSweep, new String[0]);
        GcTimeSeriesMetaData.add(381, GcEventAttribute.PAGE_FAULTS, parallelGcMarkSweep, new String[0]);
        GcTimeSeriesMetaData.add(382, GcEventAttribute.MAJOR_PAGE_FAULTS, parallelGcMarkSweep, new String[0]);
        GcTimeSeriesMetaData.add(383, GcEventAttribute.MINOR_PAGE_FAULTS, parallelGcMarkSweep, new String[0]);
        GcTimeSeriesMetaData.add(384, GcEventAttribute.SUCCESSFUL_STEALS, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(385, GcEventAttribute.FAILED_STEALS, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(386, GcEventAttribute.FAILED_STEALS_WITH_YIELD, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(387, GcEventAttribute.ALLOWED_NON_PERM_DEAD_SPACE, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(388, GcEventAttribute.ALLOWED_PERM_DEAD_SPACE, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(389, GcEventAttribute.NR_OF_UNLOADED_CLASSES, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(390, GcEventAttribute.USED_NON_PERM_DEAD_SPACE, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(391, GcEventAttribute.USED_PERM_DEAD_SPACE, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(392, GcEventAttribute.PHASE_1_DURATION, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(393, GcEventAttribute.PHASE_1_CPU_TIME, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(394, GcEventAttribute.PHASE_2_DURATION, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(395, GcEventAttribute.PHASE_2_CPU_TIME, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(396, GcEventAttribute.PHASE_3_DURATION, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(397, GcEventAttribute.PHASE_3_CPU_TIME, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(398, GcEventAttribute.PHASE_4_DURATION, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(399, GcEventAttribute.PHASE_4_CPU_TIME, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(400, GcEventAttribute.NR_OF_PARALLEL_COMPACT_THREADS, parallelGcParallelCompact, parallelGcParallelCompactDetails);
        GcTimeSeriesMetaData.add(401, GcEventAttribute.BYTES_IN_EDEN_AFTER, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(402, GcEventAttribute.BYTES_IN_EDEN_BEFORE, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(403, GcEventAttribute.BYTES_IN_FROM_AFTER, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(404, GcEventAttribute.BYTES_IN_FROM_BEFORE, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(405, GcEventAttribute.BYTES_IN_OLD_AFTER, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(406, GcEventAttribute.BYTES_IN_OLD_BEFORE, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(407, GcEventAttribute.BYTES_IN_PERM_AFTER, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(408, GcEventAttribute.BYTES_IN_PERM_BEFORE, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(409, GcEventAttribute.BYTES_IN_TO_AFTER, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(410, GcEventAttribute.BYTES_IN_TO_BEFORE, parallelGcParallelCompact, generational);
        GcTimeSeriesMetaData.add(411, GcEventAttribute.CPU_TIME, parallelGcParallelCompact, new String[0]);
        GcTimeSeriesMetaData.add(412, GcEventAttribute.DURATION, parallelGcParallelCompact, new String[0]);
        GcTimeSeriesMetaData.add(413, GcEventAttribute.PAGE_FAULTS, parallelGcParallelCompact, new String[0]);
        GcTimeSeriesMetaData.add(414, GcEventAttribute.MAJOR_PAGE_FAULTS, parallelGcParallelCompact, new String[0]);
        GcTimeSeriesMetaData.add(415, GcEventAttribute.MINOR_PAGE_FAULTS, parallelGcParallelCompact, new String[0]);
        GcTimeSeriesMetaData.add(416, GcEventAttribute.SUCCESSFUL_STEALS, parallelGcScavenge, parallelGcScavengeDetails);
        GcTimeSeriesMetaData.add(417, GcEventAttribute.FAILED_STEALS, parallelGcScavenge, parallelGcScavengeDetails);
        GcTimeSeriesMetaData.add(418, GcEventAttribute.FAILED_STEALS_WITH_YIELD, parallelGcScavenge, parallelGcScavengeDetails);
        GcTimeSeriesMetaData.add(419, GcEventAttribute.PLABSIZE, parallelGcScavenge, parallelGcScavengeDetails);
        GcTimeSeriesMetaData.add(420, GcEventAttribute.BYTES_IN_EDEN_AFTER, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(421, GcEventAttribute.BYTES_IN_EDEN_BEFORE, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(422, GcEventAttribute.BYTES_IN_FROM_AFTER, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(423, GcEventAttribute.BYTES_IN_FROM_BEFORE, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(424, GcEventAttribute.BYTES_IN_OLD_AFTER, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(425, GcEventAttribute.BYTES_IN_OLD_BEFORE, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(426, GcEventAttribute.BYTES_IN_PERM_AFTER, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(427, GcEventAttribute.BYTES_IN_PERM_BEFORE, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(428, GcEventAttribute.BYTES_IN_TO_AFTER, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(429, GcEventAttribute.BYTES_IN_TO_BEFORE, parallelGcScavenge, generational);
        GcTimeSeriesMetaData.add(430, GcEventAttribute.CPU_TIME, parallelGcScavenge, new String[0]);
        GcTimeSeriesMetaData.add(431, GcEventAttribute.DURATION, parallelGcScavenge, new String[0]);
        GcTimeSeriesMetaData.add(432, GcEventAttribute.PAGE_FAULTS, parallelGcScavenge, new String[0]);
        GcTimeSeriesMetaData.add(433, GcEventAttribute.MAJOR_PAGE_FAULTS, parallelGcScavenge, new String[0]);
        GcTimeSeriesMetaData.add(434, GcEventAttribute.MINOR_PAGE_FAULTS, parallelGcScavenge, new String[0]);
        GcTimeSeriesMetaData.add(435, GcEventAttribute.SUCCESSFUL_STEALS, parallelNewGc, parallelNewGcDetails);
        GcTimeSeriesMetaData.add(436, GcEventAttribute.FAILED_STEALS, parallelNewGc, parallelNewGcDetails);
        GcTimeSeriesMetaData.add(437, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILLS, parallelNewGc, parallelNewGcDetails);
        GcTimeSeriesMetaData.add(438, GcEventAttribute.SUCCESSFUL_OVERFLOW_REFILL_OBJECTS, parallelNewGc, parallelNewGcDetails);
        GcTimeSeriesMetaData.add(439, GcEventAttribute.FAILED_OVERFLOW_REFILLS, parallelNewGc, parallelNewGcDetails);
        GcTimeSeriesMetaData.add(440, GcEventAttribute.FAILED_STEALS_WITH_YIELD, parallelNewGc, parallelNewGcDetails);
        GcTimeSeriesMetaData.add(441, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, parallelNewGc, parallelNewGcDetails);
        GcTimeSeriesMetaData.add(442, GcEventAttribute.PLABSIZE, parallelNewGc, parallelNewGcDetails);
        GcTimeSeriesMetaData.add(443, GcEventAttribute.NR_OF_PARALLEL_GC_THREADS, parallelNewGc, parallelNewGcDetails);
        GcTimeSeriesMetaData.add(444, GcEventAttribute.BYTES_IN_EDEN_AFTER, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(445, GcEventAttribute.BYTES_IN_EDEN_BEFORE, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(446, GcEventAttribute.BYTES_IN_FROM_AFTER, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(447, GcEventAttribute.BYTES_IN_FROM_BEFORE, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(448, GcEventAttribute.BYTES_IN_OLD_AFTER, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(449, GcEventAttribute.BYTES_IN_OLD_BEFORE, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(450, GcEventAttribute.BYTES_IN_PERM_AFTER, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(451, GcEventAttribute.BYTES_IN_PERM_BEFORE, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(452, GcEventAttribute.BYTES_IN_TO_AFTER, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(453, GcEventAttribute.BYTES_IN_TO_BEFORE, parallelNewGc, generational);
        GcTimeSeriesMetaData.add(454, GcEventAttribute.CPU_TIME, parallelNewGc, new String[0]);
        GcTimeSeriesMetaData.add(455, GcEventAttribute.DURATION, parallelNewGc, new String[0]);
        GcTimeSeriesMetaData.add(456, GcEventAttribute.PAGE_FAULTS, parallelNewGc, new String[0]);
        GcTimeSeriesMetaData.add(457, GcEventAttribute.MAJOR_PAGE_FAULTS, parallelNewGc, new String[0]);
        GcTimeSeriesMetaData.add(458, GcEventAttribute.MINOR_PAGE_FAULTS, parallelNewGc, new String[0]);
        GcTimeSeriesMetaData.add(459, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(460, GcEventAttribute.BYTES_IN_EDEN_AFTER, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(461, GcEventAttribute.BYTES_IN_EDEN_BEFORE, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(462, GcEventAttribute.BYTES_IN_FROM_AFTER, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(463, GcEventAttribute.BYTES_IN_FROM_BEFORE, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(464, GcEventAttribute.BYTES_IN_OLD_AFTER, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(465, GcEventAttribute.BYTES_IN_OLD_BEFORE, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(466, GcEventAttribute.BYTES_IN_PERM_AFTER, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(467, GcEventAttribute.BYTES_IN_PERM_BEFORE, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(468, GcEventAttribute.BYTES_IN_TO_AFTER, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(469, GcEventAttribute.BYTES_IN_TO_BEFORE, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(470, GcEventAttribute.CPU_TIME, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(471, GcEventAttribute.DURATION, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(472, GcEventAttribute.PAGE_FAULTS, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(473, GcEventAttribute.MAJOR_PAGE_FAULTS, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(474, GcEventAttribute.MINOR_PAGE_FAULTS, serialNewGc, new String[0]);
        GcTimeSeriesMetaData.add(475, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(476, GcEventAttribute.ALLOWED_NON_PERM_DEAD_SPACE, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(477, GcEventAttribute.ALLOWED_PERM_DEAD_SPACE, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(478, GcEventAttribute.NR_OF_UNLOADED_CLASSES, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(479, GcEventAttribute.USED_NON_PERM_DEAD_SPACE, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(480, GcEventAttribute.USED_PERM_DEAD_SPACE, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(481, GcEventAttribute.PHASE_1_DURATION, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(482, GcEventAttribute.PHASE_1_CPU_TIME, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(483, GcEventAttribute.PHASE_2_DURATION, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(484, GcEventAttribute.PHASE_2_CPU_TIME, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(485, GcEventAttribute.PHASE_3_DURATION, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(486, GcEventAttribute.PHASE_3_CPU_TIME, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(487, GcEventAttribute.PHASE_4_DURATION, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(488, GcEventAttribute.PHASE_4_CPU_TIME, tenuredGc, tenuredGcDetails);
        GcTimeSeriesMetaData.add(489, GcEventAttribute.BYTES_IN_EDEN_AFTER, tenuredGc, generational);
        GcTimeSeriesMetaData.add(490, GcEventAttribute.BYTES_IN_EDEN_BEFORE, tenuredGc, generational);
        GcTimeSeriesMetaData.add(491, GcEventAttribute.BYTES_IN_FROM_AFTER, tenuredGc, generational);
        GcTimeSeriesMetaData.add(492, GcEventAttribute.BYTES_IN_FROM_BEFORE, tenuredGc, generational);
        GcTimeSeriesMetaData.add(493, GcEventAttribute.BYTES_IN_OLD_AFTER, tenuredGc, generational);
        GcTimeSeriesMetaData.add(494, GcEventAttribute.BYTES_IN_OLD_BEFORE, tenuredGc, generational);
        GcTimeSeriesMetaData.add(495, GcEventAttribute.BYTES_IN_PERM_AFTER, tenuredGc, generational);
        GcTimeSeriesMetaData.add(496, GcEventAttribute.BYTES_IN_PERM_BEFORE, tenuredGc, generational);
        GcTimeSeriesMetaData.add(497, GcEventAttribute.BYTES_IN_TO_AFTER, tenuredGc, generational);
        GcTimeSeriesMetaData.add(498, GcEventAttribute.BYTES_IN_TO_BEFORE, tenuredGc, generational);
        GcTimeSeriesMetaData.add(499, GcEventAttribute.CPU_TIME, tenuredGc, new String[0]);
        GcTimeSeriesMetaData.add(500, GcEventAttribute.DURATION, tenuredGc, new String[0]);
        GcTimeSeriesMetaData.add(501, GcEventAttribute.PAGE_FAULTS, tenuredGc, new String[0]);
        GcTimeSeriesMetaData.add(502, GcEventAttribute.MAJOR_PAGE_FAULTS, tenuredGc, new String[0]);
        GcTimeSeriesMetaData.add(503, GcEventAttribute.MINOR_PAGE_FAULTS, tenuredGc, new String[0]);
        GcTimeSeriesMetaData.add(504, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(505, GcEventAttribute.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(506, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(507, GcEventAttribute.FINAL_REFERENCES_ENQUEUED, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(508, GcEventAttribute.FINAL_REFERENCES_FOUND, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(509, GcEventAttribute.PHANTOM_REFERENCES_ENQUEUED, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(510, GcEventAttribute.PHANTOM_REFERENCES_FOUND, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(511, GcEventAttribute.SOFT_REFERENCES_CLEARED, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(512, GcEventAttribute.SOFT_REFERENCES_ENQUEUED, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(513, GcEventAttribute.SOFT_REFERENCES_FOUND, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(514, GcEventAttribute.SOFT_REFERENCES_NOT_CLEARED, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(515, GcEventAttribute.SOFT_REFERENCE_MAX_LAST_USED_TIME, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(516, GcEventAttribute.WEAK_REFERENCES_CLEARED, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(517, GcEventAttribute.WEAK_REFERENCES_ENQUEUED, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(518, GcEventAttribute.WEAK_REFERENCES_FOUND, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(519, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(520, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(521, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(522, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(523, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(524, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(525, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(526, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(527, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(528, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(529, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(530, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(531, GcEventAttribute.SOFT_REFERENCE_HANDLING_DURATION, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(532, GcEventAttribute.SOFT_REFERENCE_HANDLING_CPU_TIME, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(533, GcEventAttribute.WEAK_REFERENCE_HANDLING_DURATION, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(534, GcEventAttribute.WEAK_REFERENCE_HANDLING_CPU_TIME, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(535, GcEventAttribute.FINAL_REFERENCE_HANDLING_DURATION, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(536, GcEventAttribute.FINAL_REFERENCE_HANDLING_CPU_TIME, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(537, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_DURATION, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(538, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_CPU_TIME, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(539, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_DURATION, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(540, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_CPU_TIME, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(541, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_BY_POLICY, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(542, GcEventAttribute.JNIWEAK_REFS_ALIVE, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(543, GcEventAttribute.JNIWEAK_REFS_DEADS, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(544, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_DURATION, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(545, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_CPU_TIME, allGenRefHandling, allGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(546, GcEventAttribute.CPU_TIME, allGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(547, GcEventAttribute.DURATION, allGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(548, GcEventAttribute.PAGE_FAULTS, allGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(549, GcEventAttribute.MAJOR_PAGE_FAULTS, allGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(550, GcEventAttribute.MINOR_PAGE_FAULTS, allGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(551, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(552, GcEventAttribute.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(553, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(554, GcEventAttribute.FINAL_REFERENCES_ENQUEUED, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(555, GcEventAttribute.FINAL_REFERENCES_FOUND, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(556, GcEventAttribute.PHANTOM_REFERENCES_ENQUEUED, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(557, GcEventAttribute.PHANTOM_REFERENCES_FOUND, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(558, GcEventAttribute.SOFT_REFERENCES_CLEARED, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(559, GcEventAttribute.SOFT_REFERENCES_ENQUEUED, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(560, GcEventAttribute.SOFT_REFERENCES_FOUND, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(561, GcEventAttribute.SOFT_REFERENCES_NOT_CLEARED, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(562, GcEventAttribute.SOFT_REFERENCE_MAX_LAST_USED_TIME, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(563, GcEventAttribute.WEAK_REFERENCES_CLEARED, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(564, GcEventAttribute.WEAK_REFERENCES_ENQUEUED, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(565, GcEventAttribute.WEAK_REFERENCES_FOUND, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(566, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(567, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(568, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(569, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(570, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(571, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(572, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(573, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(574, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(575, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(576, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(577, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(578, GcEventAttribute.SOFT_REFERENCE_HANDLING_DURATION, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(579, GcEventAttribute.SOFT_REFERENCE_HANDLING_CPU_TIME, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(580, GcEventAttribute.WEAK_REFERENCE_HANDLING_DURATION, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(581, GcEventAttribute.WEAK_REFERENCE_HANDLING_CPU_TIME, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(582, GcEventAttribute.FINAL_REFERENCE_HANDLING_DURATION, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(583, GcEventAttribute.FINAL_REFERENCE_HANDLING_CPU_TIME, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(584, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_DURATION, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(585, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_CPU_TIME, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(586, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_DURATION, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(587, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_CPU_TIME, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(588, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_BY_POLICY, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(589, GcEventAttribute.JNIWEAK_REFS_ALIVE, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(590, GcEventAttribute.JNIWEAK_REFS_DEADS, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(591, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_DURATION, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(592, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_CPU_TIME, oldGenRefHandling, oldGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(593, GcEventAttribute.CPU_TIME, oldGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(594, GcEventAttribute.DURATION, oldGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(595, GcEventAttribute.PAGE_FAULTS, oldGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(596, GcEventAttribute.MAJOR_PAGE_FAULTS, oldGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(597, GcEventAttribute.MINOR_PAGE_FAULTS, oldGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(598, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(599, GcEventAttribute.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(600, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(601, GcEventAttribute.FINAL_REFERENCES_ENQUEUED, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(602, GcEventAttribute.FINAL_REFERENCES_FOUND, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(603, GcEventAttribute.PHANTOM_REFERENCES_ENQUEUED, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(604, GcEventAttribute.PHANTOM_REFERENCES_FOUND, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(605, GcEventAttribute.SOFT_REFERENCES_CLEARED, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(606, GcEventAttribute.SOFT_REFERENCES_ENQUEUED, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(607, GcEventAttribute.SOFT_REFERENCES_FOUND, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(608, GcEventAttribute.SOFT_REFERENCES_NOT_CLEARED, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(609, GcEventAttribute.SOFT_REFERENCE_MAX_LAST_USED_TIME, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(610, GcEventAttribute.WEAK_REFERENCES_CLEARED, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(611, GcEventAttribute.WEAK_REFERENCES_ENQUEUED, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(612, GcEventAttribute.WEAK_REFERENCES_FOUND, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(613, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(614, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(615, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(616, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(617, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(618, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(619, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(620, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(621, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(622, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(623, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(624, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(625, GcEventAttribute.SOFT_REFERENCE_HANDLING_DURATION, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(626, GcEventAttribute.SOFT_REFERENCE_HANDLING_CPU_TIME, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(627, GcEventAttribute.WEAK_REFERENCE_HANDLING_DURATION, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(628, GcEventAttribute.WEAK_REFERENCE_HANDLING_CPU_TIME, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(629, GcEventAttribute.FINAL_REFERENCE_HANDLING_DURATION, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(630, GcEventAttribute.FINAL_REFERENCE_HANDLING_CPU_TIME, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(631, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_DURATION, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(632, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_CPU_TIME, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(633, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_DURATION, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(634, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_CPU_TIME, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(635, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_BY_POLICY, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(636, GcEventAttribute.JNIWEAK_REFS_ALIVE, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(637, GcEventAttribute.JNIWEAK_REFS_DEADS, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(638, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_DURATION, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(639, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_CPU_TIME, youngGenRefHandling, youngGenRefHandlingDetails);
        GcTimeSeriesMetaData.add(640, GcEventAttribute.CPU_TIME, youngGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(641, GcEventAttribute.DURATION, youngGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(642, GcEventAttribute.PAGE_FAULTS, youngGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(643, GcEventAttribute.MAJOR_PAGE_FAULTS, youngGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(644, GcEventAttribute.MINOR_PAGE_FAULTS, youngGenRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(645, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PREPROCESSING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(646, GcEventAttribute.DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(647, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(648, GcEventAttribute.FINAL_REFERENCES_ENQUEUED, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(649, GcEventAttribute.FINAL_REFERENCES_FOUND, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(650, GcEventAttribute.PHANTOM_REFERENCES_ENQUEUED, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(651, GcEventAttribute.PHANTOM_REFERENCES_FOUND, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(652, GcEventAttribute.SOFT_REFERENCES_CLEARED, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(653, GcEventAttribute.SOFT_REFERENCES_ENQUEUED, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(654, GcEventAttribute.SOFT_REFERENCES_FOUND, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(655, GcEventAttribute.SOFT_REFERENCES_NOT_CLEARED, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(656, GcEventAttribute.SOFT_REFERENCE_MAX_LAST_USED_TIME, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(657, GcEventAttribute.WEAK_REFERENCES_CLEARED, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(658, GcEventAttribute.WEAK_REFERENCES_ENQUEUED, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(659, GcEventAttribute.WEAK_REFERENCES_FOUND, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(660, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(661, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(662, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(663, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(664, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(665, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(666, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(667, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(668, GcEventAttribute.SOFT_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(669, GcEventAttribute.WEAK_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(670, GcEventAttribute.FINAL_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(671, GcEventAttribute.PHANTOM_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(672, GcEventAttribute.SOFT_REFERENCE_HANDLING_DURATION, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(673, GcEventAttribute.SOFT_REFERENCE_HANDLING_CPU_TIME, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(674, GcEventAttribute.WEAK_REFERENCE_HANDLING_DURATION, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(675, GcEventAttribute.WEAK_REFERENCE_HANDLING_CPU_TIME, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(676, GcEventAttribute.FINAL_REFERENCE_HANDLING_DURATION, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(677, GcEventAttribute.FINAL_REFERENCE_HANDLING_CPU_TIME, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(678, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_DURATION, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(679, GcEventAttribute.PHANTOM_REFERENCE_HANDLING_CPU_TIME, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(680, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_DURATION, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(681, GcEventAttribute.JNIWEAK_REFERENCE_HANDLING_CPU_TIME, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(682, GcEventAttribute.SOFT_REFERENCES_RESURRECTED_BY_POLICY, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(683, GcEventAttribute.JNIWEAK_REFS_ALIVE, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(684, GcEventAttribute.JNIWEAK_REFS_DEADS, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(685, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_DURATION, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(686, GcEventAttribute.TRANSITION_TO_SINGLE_THREADING_CPU_TIME, partialRefHandling, partialRefHandlingDetails);
        GcTimeSeriesMetaData.add(687, GcEventAttribute.CPU_TIME, partialRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(688, GcEventAttribute.DURATION, partialRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(689, GcEventAttribute.PAGE_FAULTS, partialRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(690, GcEventAttribute.MAJOR_PAGE_FAULTS, partialRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(691, GcEventAttribute.MINOR_PAGE_FAULTS, partialRefHandling, new String[0]);
        GcTimeSeriesMetaData.add(692, GcEventAttribute.FULL_GCS_SINCE_CONC_GC, cmsAborted, new String[0]);
        GcTimeSeriesMetaData.add(693, GcEventAttribute.FULL_GCS_BEFORE_COMPACTION, cmsAborted, new String[0]);
        GcTimeSeriesMetaData.add(694, GcEventAttribute.AVERAGE_PROMOTED, parallelSmallGcForcedFullGc, new String[0]);
        GcTimeSeriesMetaData.add(695, GcEventAttribute.LARGEST_CONTIGUOUS_BLOCK_IN_OLD, youngGenPromotionFailure, new String[0]);
        GcTimeSeriesMetaData.add(696, GcEventAttribute.CAUSING_OBJECT_SIZE, youngGenPromotionFailure, new String[0]);
        GcTimeSeriesMetaData.add(697, GcEventAttribute.FAILED_PROMOTIONS_COUNT, youngGenPromotionFailure, new String[0]);
        GcTimeSeriesMetaData.add(702, GcStatisticAttribute.PROMOTIONS_TO_OLD);
        GcTimeSeriesMetaData.add(703, GcStatisticAttribute.SURVIVING_YOUNG);
        GcTimeSeriesMetaData.add(704, GcEventAttribute.SYSTEM_LOAD_1MIN_AVERAGE, other, new String[0]);
        GcTimeSeriesMetaData.add(705, GcEventAttribute.SYSTEM_LOAD_5MIN_AVERAGE, other, new String[0]);
        GcTimeSeriesMetaData.add(706, GcEventAttribute.SYSTEM_LOAD_15MIN_AVERAGE, other, new String[0]);
        GcTimeSeriesMetaData.add(707, GcEventAttribute.VIRTUAL_CPU_UTILIZATION, other, new String[0]);
        GcTimeSeriesMetaData.add(708, GcStatisticAttribute.BYTES_IN_YOUNG_DIFFERENCE);
        GcTimeSeriesMetaData.add(709, GcStatisticAttribute.BYTES_IN_TO_DIFFERENCE);
        GcTimeSeriesMetaData.add(710, GcStatisticAttribute.BYTES_IN_FROM_DIFFERENCE);
        GcTimeSeriesMetaData.add(711, GcStatisticAttribute.BYTES_IN_EDEN_DIFFERENCE);
        GcTimeSeriesMetaData.add(712, GcStatisticAttribute.BYTES_IN_OLD_DIFFERENCE);
        GcTimeSeriesMetaData.add(713, GcStatisticAttribute.BYTES_IN_NON_PERM_DIFFERENCE);
        GcTimeSeriesMetaData.add(714, GcStatisticAttribute.BYTES_IN_PERM_DIFFERENCE);
        GcTimeSeriesMetaData.add(716, GcStatisticAttribute.TIME_SINCE_LAST_CONC_GC);
    }

    public static class Group {
        private final String groupName;
        private ArrayList<Integer> members;
        private ArrayList<Group> subGroups;

        private Group(String groupName) {
            this.groupName = groupName;
            this.members = new ArrayList();
            this.subGroups = new ArrayList();
        }

        private Group(String name, ArrayList<Integer> applMembers, ArrayList<Group> applSubGroups) {
            this.groupName = name;
            this.members = applMembers;
            this.subGroups = applSubGroups;
        }

        public Group applicableTo(ProfilingSession session, GcType type) {
            ArrayList<Integer> applMembers = new ArrayList<Integer>(this.members.stream().filter(m -> ATTRIBUTE_FOR_TIMESERIES[m].isApplicable(session, type, null)).collect(Collectors.toList()));
            ArrayList<Group> applSubGroups = new ArrayList<Group>(this.subGroups.stream().map(g -> g.applicableTo(session, type)).collect(Collectors.toList()));
            return new Group(this.groupName, applMembers, applSubGroups);
        }

        private void addMember(int timeSeriesIndex) {
            this.members.add(timeSeriesIndex);
        }

        private void addGroupIfMissing(Group subGroup) {
            if (!this.subGroups.contains(subGroup)) {
                this.subGroups.add(subGroup);
            }
        }

        private Group addSubGroupIfMissing(String subGroupName) {
            for (Group subGroup : this.subGroups) {
                if (!subGroup.groupName.equals(subGroupName)) continue;
                return subGroup;
            }
            Group result = new Group(subGroupName);
            this.subGroups.add(result);
            return result;
        }

        public String getName() {
            return this.groupName;
        }

        public List<Integer> getMembers() {
            return Collections.unmodifiableList(this.members);
        }

        public List<Group> getSubGroups() {
            return Collections.unmodifiableList(this.subGroups);
        }

        public boolean isEmpty() {
            return this.members.isEmpty() && this.subGroups.isEmpty();
        }
    }
}

