/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.gc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.presentation.typed.gc.GcStatisticAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GcTimeSeriesSelection {
    private ArrayList<Area> selectionAreas = new ArrayList();

    public void addArea(String title, int[] timeSeries) {
        Area newArea = new Area(title, timeSeries);
        this.addArea(newArea);
    }

    public void addArea(Area group) {
        group.idx = this.selectionAreas.size();
        this.selectionAreas.add(group);
    }

    public List<Area> getAreas() {
        return this.selectionAreas;
    }

    public List<Integer> getTimeSeriesFlat() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Area group : this.selectionAreas) {
            int[] nArray = group.getTimeSeries();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer index = nArray[i];
                result.add(index);
            }
        }
        return result;
    }

    public int hashCode() {
        return this.selectionAreas.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GcTimeSeriesSelection) {
            return this.selectionAreas.equals(((GcTimeSeriesSelection)obj).selectionAreas);
        }
        return false;
    }

    public static GcTimeSeriesSelection getDefault() {
        GcTimeSeriesSelection result = new GcTimeSeriesSelection();
        Area durationArea = new Area(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Durations"), I18n._s((String)"Shows duration related GC statistic attributes"), new int[]{GcStatisticAttribute.MAX_PAUSE_TIME.getTimeSeriesIndex(), GcStatisticAttribute.CPU_TIME.getTimeSeriesIndex(), 701}, new boolean[3]);
        result.addArea(durationArea);
        Area heapArea = new Area(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Heap"), I18n._s((String)"Shows heap memory usage information"), new int[]{GcStatisticAttribute.BYTES_IN_YOUNG_AFTER_GC.getTimeSeriesIndex(), GcStatisticAttribute.BYTES_IN_OLD_AFTER_GC.getTimeSeriesIndex()}, new boolean[]{false, true});
        result.addArea(heapArea);
        Area promotionArea = new Area(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Bytes Promoted"), I18n._s((String)"Shows the amounts of memory that survived young GCs and got promoted to old generation"), new int[]{703, 702}, new boolean[2]);
        result.addArea(promotionArea);
        Area pageFaultsArea = new Area(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"Page faults"), I18n._s((String)"Shows page fault information"), new int[]{GcStatisticAttribute.MAJOR_PAGE_FAULTS.getTimeSeriesIndex(), GcStatisticAttribute.MINOR_PAGE_FAULTS.getTimeSeriesIndex()}, new boolean[2]);
        result.addArea(pageFaultsArea);
        Area loadArea = new Area(I18n._ts((I18n.TextType)I18n.TextType.XTBS, (String)"System Load"), I18n._s((String)"Shows the system load average before the GC events "), new int[]{704, 705, 706, 707}, new boolean[4]);
        result.addArea(loadArea);
        return result;
    }

    public static class Area {
        private final String groupTitle;
        private final String description;
        private final int[] timeSeries;
        private final boolean[] secondary;
        public int idx;

        public Area(String title, int[] timeSeries) {
            this(title, null, timeSeries, new boolean[timeSeries.length]);
        }

        public Area(String title, String description, int[] timeSeries, boolean[] secondary) {
            this.groupTitle = title;
            this.description = description;
            this.timeSeries = (int[])timeSeries.clone();
            this.secondary = (boolean[])secondary.clone();
        }

        public String getTitle() {
            return this.groupTitle;
        }

        public String getDescription() {
            return this.description != null ? this.description : this.groupTitle;
        }

        public int[] getTimeSeries() {
            return this.timeSeries;
        }

        public boolean[] getSecondary() {
            return this.secondary;
        }

        public String getTag() {
            return "gc/group_" + this.idx;
        }

        public int hashCode() {
            return this.groupTitle.hashCode() ^ Arrays.hashCode(this.timeSeries);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Area) {
                Area other = (Area)obj;
                return this.groupTitle.equals(other.groupTitle) && Arrays.equals(this.timeSeries, other.timeSeries);
            }
            return false;
        }
    }
}

