/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.presentation.typed.gc.elements;

import com.sap.jvm.profiling.presentation.typed.gc.GcTimeSeriesSelection;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

public final class SelectTimeSeriesElement
implements ResourceNameElement {
    private static final int VERSION = 0;
    private static final String tag = "select gc time series";
    private GcTimeSeriesSelection selection;

    public SelectTimeSeriesElement(GcTimeSeriesSelection selection) {
        this.selection = selection;
    }

    public SelectTimeSeriesElement(ResourceReader reader) throws IOException {
        reader.readVersion(0);
        this.selection = new GcTimeSeriesSelection();
        int areasCount = reader.readInt32();
        for (int i = 0; i < areasCount; ++i) {
            String areaTitle = reader.readString();
            int[] indices = this.readTimeSeries(reader);
            this.selection.addArea(areaTitle, indices);
        }
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        List<GcTimeSeriesSelection.Area> areas = this.selection.getAreas();
        writer.writeInt32(areas.size());
        for (GcTimeSeriesSelection.Area area : areas) {
            writer.writeString(area.getTitle());
            this.writeTimeSeries(writer, area.getTimeSeries());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SelectTimeSeriesElement) {
            SelectTimeSeriesElement other = (SelectTimeSeriesElement)obj;
            return this.selection.equals(other.selection);
        }
        return false;
    }

    public GcTimeSeriesSelection getSelection() {
        return this.selection;
    }

    public int hashCode() {
        return tag.hashCode() ^ this.selection.hashCode();
    }

    public String toString() {
        return tag;
    }

    public String getTag() {
        return tag;
    }

    private int[] readTimeSeries(ResourceReader reader) throws EOFException {
        int size = reader.readInt32();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = reader.readInt32();
        }
        return result;
    }

    private void writeTimeSeries(ResourceWriter writer, int[] indices) throws IOException {
        writer.writeInt32(indices.length);
        for (int i = 0; i < indices.length; ++i) {
            writer.writeInt32(indices[i]);
        }
    }
}

