/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.proxy;

import com.sap.jvm.profiling.DebuggingConnection;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.proxy.JdwpPacket;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;

public class DebuggingProfilingProxy {
    private int proxyDebuggingPort;
    private int proxyProfilingPort;
    private String debugHost;
    private int debugPort;
    private DebuggingConnection connection;

    public static void main(String[] args) {
        int proxyDebuggingPort = -1;
        int proxyProfilingPort = -1;
        String debugHost = null;
        int debugPort = -1;
        try {
            proxyDebuggingPort = Integer.parseInt(args[0]);
            proxyProfilingPort = Integer.parseInt(args[1]);
            debugHost = args[2];
            debugPort = Integer.parseInt(args[3]);
        }
        catch (Exception ex) {
            System.out.println("The syntax for starting the debugging/profiling proxy is:");
            System.out.println("DebuggingProfilingProxy <proxyDebuggingPort> <proxyProfilingPort> <debugHost> <debugPort>");
        }
        try {
            DebuggingProfilingProxy debuggingProfilingProxy = new DebuggingProfilingProxy(proxyDebuggingPort, proxyProfilingPort, debugHost, debugPort);
            debuggingProfilingProxy.start();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public DebuggingProfilingProxy(int proxyDebuggingPort, int proxyProfilingPort, String debugHost, int debugPort) {
        this.proxyDebuggingPort = proxyDebuggingPort;
        this.proxyProfilingPort = proxyProfilingPort;
        this.debugHost = debugHost;
        this.debugPort = debugPort;
    }

    public void start() throws IOException {
        this.connection = ProfilingFactory.createDebuggingConnection((String)this.debugHost, (int)this.debugPort, (boolean)false);
        AttachThread debuggingThread = new AttachThread(false);
        debuggingThread.start();
        AttachThread profilingThread = new AttachThread(true);
        profilingThread.start();
        try {
            debuggingThread.join();
            profilingThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private byte[] readPacket(DataInputStream inputStream) throws IOException {
        int packetLength = inputStream.readInt();
        if (packetLength < 11) {
            throw new IOException("JDWP Packet under 11 bytes");
        }
        byte[] packet = new byte[packetLength];
        packet[0] = (byte)(packetLength >>> 24 & 0xFF);
        packet[1] = (byte)(packetLength >>> 16 & 0xFF);
        packet[2] = (byte)(packetLength >>> 8 & 0xFF);
        packet[3] = (byte)(packetLength >>> 0 & 0xFF);
        inputStream.readFully(packet, 4, packetLength - 4);
        return packet;
    }

    private class BackendReaderThread
    extends Thread {
        private boolean isProfiling;
        private OutputStream outputStream;

        public BackendReaderThread(boolean isProfiling, OutputStream outputStream) {
            this.isProfiling = isProfiling;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    byte[] packet = this.isProfiling ? DebuggingProfilingProxy.this.connection.readProfilingPacket() : DebuggingProfilingProxy.this.connection.readDebuggingPacket();
                    this.outputStream.write(packet);
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private class AttachThread
    extends Thread {
        private boolean isProfiling;

        public AttachThread(boolean isProfiling) {
            this.isProfiling = isProfiling;
        }

        @Override
        public void run() {
            try {
                int bytesRead;
                int port = this.isProfiling ? DebuggingProfilingProxy.this.proxyProfilingPort : DebuggingProfilingProxy.this.proxyDebuggingPort;
                ServerSocket serverSocket = new ServerSocket(port);
                Socket socket = serverSocket.accept();
                serverSocket.close();
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                byte[] handshakeFromBackend = new byte[JdwpPacket.JDWP_HANDSHAKE.length];
                for (int offset = 0; offset < handshakeFromBackend.length; offset += bytesRead) {
                    bytesRead = inputStream.read(handshakeFromBackend);
                    if (bytesRead >= 0) continue;
                    throw new IOException("Error during reading JDWP handshake.");
                }
                if (!Arrays.equals(handshakeFromBackend, JdwpPacket.JDWP_HANDSHAKE)) {
                    outputStream.close();
                    inputStream.close();
                    throw new IOException("Illegal handshake received.");
                }
                outputStream.write(JdwpPacket.JDWP_HANDSHAKE);
                outputStream.flush();
                BackendReaderThread backendReaderThread = new BackendReaderThread(this.isProfiling, outputStream);
                backendReaderThread.start();
                this.read(new DataInputStream(inputStream));
                backendReaderThread.join();
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }

        private void read(DataInputStream inputStream) {
            try {
                while (true) {
                    byte[] packet = DebuggingProfilingProxy.this.readPacket(inputStream);
                    DebuggingProfilingProxy.this.connection.write(packet);
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }
}

