/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.proxy;

import com.sap.jvm.profiling.DebuggingConnection;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.proxy.JdwpPacket;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class LatencyJdwpProxy {
    private int proxyDebuggingPort;
    private String debugHost;
    private int debugPort;
    private int latency;
    private DebuggingConnection connection;
    private boolean isSuspended;
    private boolean useFastSuspendedCalls;
    private boolean dumpSlowCommands;
    private Map<Integer, Integer> idToSet = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> idToCommand = new HashMap<Integer, Integer>();

    public static void main(String[] args) throws Exception {
        int proxyDebuggingPort = -1;
        String debugHost = null;
        int debugPort = -1;
        int latency = 0;
        try {
            proxyDebuggingPort = Integer.parseInt(args[0]);
            debugHost = args[1];
            debugPort = Integer.parseInt(args[2]);
            latency = Integer.parseInt(args[3]);
        }
        catch (Exception ex) {
            System.out.println("The syntax for starting the debugging/profiling proxy is:");
            System.out.println("DebuggingProfilingProxy <proxyDebuggingPort> <debugHost> <debugPort> <latency in ms> [<debug>] [<fast_suspend>]");
        }
        LatencyJdwpProxy proxy = new LatencyJdwpProxy(proxyDebuggingPort, debugHost, debugPort, latency);
        for (String arg : args) {
            if ("debug".equals(arg)) {
                proxy.dumpSlowCommands = true;
                continue;
            }
            if (!"fast_suspend".equals(arg)) continue;
            proxy.useFastSuspendedCalls = true;
            proxy.isSuspended = true;
        }
        proxy.start();
    }

    public LatencyJdwpProxy(int proxyDebuggingPort, String debugHost, int debugPort, int latency) {
        this.proxyDebuggingPort = proxyDebuggingPort;
        this.debugHost = debugHost;
        this.debugPort = debugPort;
        this.latency = latency;
    }

    public void start() throws Exception {
        this.connection = ProfilingFactory.createDebuggingConnection((String)this.debugHost, (int)this.debugPort, (boolean)false);
        AttachThread debuggingThread = new AttachThread();
        debuggingThread.run();
        debuggingThread.join();
    }

    private byte[] readPacket(DataInputStream inputStream) throws IOException {
        int packetLength = inputStream.readInt();
        if (packetLength < 11) {
            throw new IOException("JDWP Packet under 11 bytes");
        }
        byte[] packet = new byte[packetLength];
        packet[0] = (byte)(packetLength >>> 24 & 0xFF);
        packet[1] = (byte)(packetLength >>> 16 & 0xFF);
        packet[2] = (byte)(packetLength >>> 8 & 0xFF);
        packet[3] = (byte)(packetLength >>> 0 & 0xFF);
        inputStream.readFully(packet, 4, packetLength - 4);
        return packet;
    }

    private int getSendLatency(int set, int command) {
        if (this.isSuspended && this.isFastSuspendCommand(set, command)) {
            return 0;
        }
        if (set == 1 && command == 9) {
            this.isSuspended = false;
        }
        if (set == 11 && command == 3) {
            this.isSuspended = false;
        }
        if (this.dumpSlowCommands) {
            System.out.println(set + " " + command);
        }
        return this.latency;
    }

    private int getReceiveLatency(int set, int command) {
        if (this.useFastSuspendedCalls && set == 1 && command == 8) {
            this.isSuspended = true;
            return 0;
        }
        if (this.isSuspended && this.isFastSuspendCommand(set, command)) {
            return 0;
        }
        if (this.dumpSlowCommands) {
            System.out.println(set + " " + command);
        }
        return this.latency;
    }

    private boolean isFastSuspendCommand(int set, int command) {
        if (set == 11) {
            return command == 1 || command == 4 || command == 5;
        }
        if (set == 12) {
            return command == 1 || command == 2;
        }
        if (set == 2) {
            return command == 10 || command == 14;
        }
        if (set == 3) {
            return command == 1;
        }
        if (set == 6) {
            return command == 1;
        }
        if (set == 9) {
            return command == 1;
        }
        return false;
    }

    private class BackendReaderThread
    extends Thread {
        private OutputStream outputStream;

        public BackendReaderThread(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    byte[] packet = LatencyJdwpProxy.this.connection.readDebuggingPacket();
                    int id = packet[4] & 0xFF;
                    id += (packet[5] & 0xFF) << 8;
                    id += (packet[6] & 0xFF) << 16;
                    int realLatency = LatencyJdwpProxy.this.getReceiveLatency((Integer)LatencyJdwpProxy.this.idToSet.get(id += (packet[7] & 0xFF) << 24), (Integer)LatencyJdwpProxy.this.idToCommand.get(id));
                    if (realLatency > 0) {
                        try {
                            Thread.sleep(realLatency);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.outputStream.write(packet);
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private class AttachThread
    extends Thread {
        private AttachThread() {
        }

        @Override
        public void run() {
            try {
                int bytesRead;
                ServerSocket serverSocket = new ServerSocket(LatencyJdwpProxy.this.proxyDebuggingPort);
                Socket socket = serverSocket.accept();
                serverSocket.close();
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                byte[] handshakeFromBackend = new byte[JdwpPacket.JDWP_HANDSHAKE.length];
                for (int offset = 0; offset < handshakeFromBackend.length; offset += bytesRead) {
                    bytesRead = inputStream.read(handshakeFromBackend);
                    if (bytesRead >= 0) continue;
                    throw new IOException("Error during reading JDWP handshake.");
                }
                if (!Arrays.equals(handshakeFromBackend, JdwpPacket.JDWP_HANDSHAKE)) {
                    outputStream.close();
                    inputStream.close();
                    throw new IOException("Illegal handshake received.");
                }
                outputStream.write(JdwpPacket.JDWP_HANDSHAKE);
                outputStream.flush();
                BackendReaderThread backendReaderThread = new BackendReaderThread(outputStream);
                backendReaderThread.start();
                this.read(new DataInputStream(inputStream));
                backendReaderThread.join();
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void read(DataInputStream inputStream) {
            try {
                while (true) {
                    byte[] packet = LatencyJdwpProxy.this.readPacket(inputStream);
                    int id = packet[4] & 0xFF;
                    id += (packet[5] & 0xFF) << 8;
                    id += (packet[6] & 0xFF) << 16;
                    LatencyJdwpProxy.this.idToSet.put(id += (packet[7] & 0xFF) << 24, Integer.valueOf(packet[9]));
                    LatencyJdwpProxy.this.idToCommand.put(id, Integer.valueOf(packet[10]));
                    int realLatency = LatencyJdwpProxy.this.getSendLatency(packet[9], packet[10]);
                    if (realLatency > 0) {
                        try {
                            Thread.sleep(realLatency);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    LatencyJdwpProxy.this.connection.write(packet);
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }
}

