/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot;

import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.i18n.I18n;

public enum SnapshotType {
    ALLOCATION_SNAPSHOT(I18n._s((String)"Allocation Snapshot"), 0, true, ProfilingTraceType.ALLOCATION_TRACE),
    PERFORMANCE_HOTSPOT_SNAPSHOT(I18n._s((String)"Performance Hotspot Snapshot"), 1, true, ProfilingTraceType.PERFORMANCE_HOTSPOT_TRACE),
    CLASS_STATISTIC_SNAPSHOT(I18n._s((String)"Class Statistic Snapshot"), 2, false, ProfilingTraceType.CLASS_STATISTIC_TRACE),
    METHOD_PARAMETER_SNAPSHOT(I18n._s((String)"Method Parameter Snapshot"), 3, true, ProfilingTraceType.METHOD_PARAMETER_TRACE),
    THREAD_HOTSPOT_SNAPSHOT(I18n._s((String)"Thread Hotspot Snapshot"), 4, true, ProfilingTraceType.THREAD_HOTSPOT_TRACE),
    IO_SNAPSHOT(I18n._s((String)"File I/O Snapshot"), 5, true, ProfilingTraceType.IO_TRACE),
    METHOD_SNAPSHOT(I18n._s((String)"Method Snapshot"), 6, true, ProfilingTraceType.METHOD_TRACE),
    SYNCHRONIZATION_SNAPSHOT(I18n._s((String)"Synchronization Snapshot"), 7, true, ProfilingTraceType.SYNCHRONIZATION_TRACE),
    NETWORK_SNAPSHOT(I18n._s((String)"Network I/O Snapshot"), 8, true, ProfilingTraceType.NETWORK_TRACE),
    HPROF_DUMP_SNAPSHOT(I18n._s((String)"Heap Dump"), 9, false, ProfilingTraceType.HPROF_DUMP),
    GC_SNAPSHOT(I18n._s((String)"GC Snapshot"), 10, true, ProfilingTraceType.GC_TRACE),
    THREAD_DUMP_SNAPSHOT(I18n._s((String)"Thread Dump Snapshot"), 11, true, ProfilingTraceType.THREAD_DUMP_TRACE),
    GC_HISTORY_FILE_DUMP_SNAPSHOT(I18n._s((String)"GC History File Snapshot"), 12, false, ProfilingTraceType.GC_HISTORY_FILE_DUMP);

    private final String description;
    private final int index;
    private final boolean hasExplicitStartAndStop;
    private final ProfilingTraceType traceType;

    private SnapshotType(String description, int index, boolean hasExplicitStartAndStop, ProfilingTraceType traceType) {
        this.description = description;
        this.index = index;
        this.hasExplicitStartAndStop = hasExplicitStartAndStop;
        this.traceType = traceType;
    }

    public String getDescription() {
        return this.description;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasExplicitStartAndStop() {
        return this.hasExplicitStartAndStop;
    }

    public ProfilingTraceType getTraceType() {
        return this.traceType;
    }
}

