/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.alloc;

import com.sap.jvm.profiling.snapshot.util.Value;

public final class BytesAndObjects
implements Value<BytesAndObjects> {
    public static final BytesAndObjects EMPTY = new BytesAndObjects(0L, 0L, 0L, 0L);
    private final long heapBytes;
    private final long heapObjects;
    private final long stackBytes;
    private final long stackObjects;

    public BytesAndObjects(long heapBytes, long heapObjects, long stackBytes, long stackObjects) {
        this.heapBytes = heapBytes;
        this.heapObjects = heapObjects;
        this.stackBytes = stackBytes;
        this.stackObjects = stackObjects;
    }

    public long getBytes() {
        return this.heapBytes + this.stackBytes;
    }

    public long getObjects() {
        return this.heapObjects + this.stackObjects;
    }

    public long getHeapBytes() {
        return this.heapBytes;
    }

    public long getHeapObjects() {
        return this.heapObjects;
    }

    public long getStackBytes() {
        return this.stackBytes;
    }

    public long getStackObjects() {
        return this.stackObjects;
    }

    @Override
    public BytesAndObjects getSum(BytesAndObjects toAdd) {
        return new BytesAndObjects(this.heapBytes + toAdd.heapBytes, this.heapObjects + toAdd.heapObjects, this.stackBytes + toAdd.stackBytes, this.stackObjects + toAdd.stackObjects);
    }

    public BytesAndObjects getSum(long heapBytesToAdd, long heapObjectsToAdd, long stackBytesToAdd, long stackObjectsToAdd) {
        return new BytesAndObjects(this.heapBytes + heapBytesToAdd, this.heapObjects + heapObjectsToAdd, this.stackBytes + stackBytesToAdd, this.stackObjects + stackObjectsToAdd);
    }

    public String toString() {
        return this.heapBytes + " heap bytes, " + this.heapObjects + " heap objects, " + this.stackBytes + " stack bytes, " + this.stackObjects + " stack objects";
    }
}

