/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.alloc.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotDefiningElement;
import com.sap.jvm.profiling.snapshot.alloc.elements.ArrayLengthFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public final class FilterAllocatedArraysByLength
implements SnapshotDefiningElement,
ArrayLengthFilter {
    private static final String TAG = "filter allocated arrays by length for the allocation trace";
    private static final int VERSION = 0;
    private final int[] lengths;
    private int hashCode;

    public FilterAllocatedArraysByLength() {
        this(new int[0]);
    }

    public FilterAllocatedArraysByLength(int[] lengths) {
        this.lengths = lengths;
        Arrays.sort(lengths);
    }

    public FilterAllocatedArraysByLength(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.lengths = new int[reader.readInt32()];
        for (int i = 0; i < this.lengths.length; ++i) {
            this.lengths[i] = reader.readInt32();
        }
        Arrays.sort(this.lengths);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterAllocatedArraysByLength) {
            FilterAllocatedArraysByLength other = (FilterAllocatedArraysByLength)obj;
            return Arrays.equals(this.lengths, other.lengths);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.lengths);
            this.hashCode = this.hashCode == 0 ? 1 : this.hashCode;
        }
        return this.hashCode;
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        ps.println("an array length filter  for the allocation trace with the following lengths: ");
        for (int l : this.lengths) {
            ps.println(l);
        }
        ps.close();
        return new String(bos.toByteArray());
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.lengths.length);
        for (int l : this.lengths) {
            writer.writeInt32(l);
        }
    }

    @Override
    public boolean include(int length) {
        return Arrays.binarySearch(this.lengths, length) >= 0;
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public String getTag() {
        return TAG;
    }
}

