/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.alloc.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotDefiningElement;
import com.sap.jvm.profiling.snapshot.alloc.elements.ArrayLengthFilter;
import com.sap.jvm.util.pair.IntPair;
import java.io.IOException;
import java.util.Arrays;

public final class FilterAllocatedArraysByRange
implements SnapshotDefiningElement,
ArrayLengthFilter {
    private static final String TAG = "filter allocated arrays by range";
    private static final int VERSION = 0;
    private final IntPair[] ranges;

    public FilterAllocatedArraysByRange() {
        this(new IntPair[0]);
    }

    public FilterAllocatedArraysByRange(IntPair[] ranges) {
        this.ranges = ranges;
    }

    public FilterAllocatedArraysByRange(ResourceReader reader) throws IOException {
        reader.readVersion(0);
        this.ranges = new IntPair[reader.readInt32()];
        for (int i = 0; i < this.ranges.length; ++i) {
            this.ranges[i] = new IntPair(reader.readInt32(), reader.readInt32());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterAllocatedArraysByRange) {
            FilterAllocatedArraysByRange other = (FilterAllocatedArraysByRange)obj;
            return Arrays.equals(this.ranges, other.ranges);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.ranges);
    }

    public String toString() {
        String result = "Filter by array lengths in the following ranges: ";
        for (int i = 0; i < this.ranges.length; ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + "[" + this.ranges[i].getFirst() + "-" + this.ranges[i].getSecond() + "]";
        }
        return result;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.ranges.length);
        for (IntPair range : this.ranges) {
            writer.writeInt32(range.getFirst());
            writer.writeInt32(range.getSecond());
        }
    }

    @Override
    public boolean include(int length) {
        for (IntPair range : this.ranges) {
            if (range.getFirst() > length || range.getSecond() <= length) continue;
            return true;
        }
        return false;
    }

    public IntPair[] getRanges() {
        return (IntPair[])this.ranges.clone();
    }

    public String getTag() {
        return TAG;
    }
}

