/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.alloc.elements;

import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.AllocationAreaFilter;
import java.io.IOException;

public class FilterAllocatedObjectByArea
implements ResourceNameElement {
    private static final String TAG = "filter allocated object by allocation area for the allocation trace";
    private static final int VERSION = 0;
    private final AllocationAreaFilter filter;

    public FilterAllocatedObjectByArea() {
        this(new AllocationAreaFilter(true, true));
    }

    public FilterAllocatedObjectByArea(AllocationAreaFilter filter) {
        if (filter == null) {
            throw new NullPointerException("filter not specified");
        }
        this.filter = filter;
    }

    public FilterAllocatedObjectByArea(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.filter = new AllocationAreaFilter(reader);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterAllocatedObjectByArea) {
            FilterAllocatedObjectByArea other = (FilterAllocatedObjectByArea)obj;
            return this.filter.equals(other.filter);
        }
        return false;
    }

    public int hashCode() {
        return this.filter.hashCode();
    }

    public String toString() {
        return this.filter.toString();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        this.filter.write(writer);
    }

    public AllocationAreaFilter getFilter() {
        return this.filter;
    }

    public String getTag() {
        return TAG;
    }

    public static boolean isFilteredByHeapAllocations(ResourceName name) {
        FilterAllocatedObjectByArea element = FilterAllocatedObjectByArea.getElement(name);
        return element != null && element.getFilter().matchesHeapAllocations();
    }

    public static boolean isFilteredByStackAllocations(ResourceName name) {
        FilterAllocatedObjectByArea element = FilterAllocatedObjectByArea.getElement(name);
        return element != null && element.getFilter().matchesStackAllocations();
    }

    private static FilterAllocatedObjectByArea getElement(ResourceName name) {
        int index = name.indexOf(FilterAllocatedObjectByArea.class);
        if (index < 0) {
            return null;
        }
        return (FilterAllocatedObjectByArea)name.getElements()[index];
    }
}

