/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.alloc.elements;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.elements.util.ArrayReadStoreUtlis;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import java.io.IOException;

public final class FilterAllocatedObjectByClass
implements ResourceNameElement {
    private static final String TAG = "filter allocated object by class for the allocation trace";
    private static final int VERSION = 0;
    private final ClassObject[] classes;
    private final ClassFilter filter;

    public FilterAllocatedObjectByClass() {
        this(null, new ClassObject[0]);
    }

    public FilterAllocatedObjectByClass(ProfilingSession session, ClassObject[] classes) {
        this.classes = classes;
        this.filter = ClassFilter.createForClasses(session, "<selected classes>", classes);
    }

    public FilterAllocatedObjectByClass(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.classes = ArrayReadStoreUtlis.readClasses(reader);
        this.filter = ClassFilter.createForClasses(reader.getSession(), "<selected classes>", this.classes);
    }

    public ClassFilter getFilter() {
        return this.filter;
    }

    public ClassObject[] getClasses() {
        return this.classes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterAllocatedObjectByClass) {
            FilterAllocatedObjectByClass other = (FilterAllocatedObjectByClass)obj;
            return this.filter.equals(other.filter);
        }
        return false;
    }

    public int hashCode() {
        return 0x2876837 ^ this.filter.hashCode();
    }

    public String toString() {
        return "a class filter for allocated objects for the allocation trace: " + this.filter.asString();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        ArrayReadStoreUtlis.writeClasses(writer, this.classes);
    }

    public String getTag() {
        return TAG;
    }
}

