/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.alloc.elements;

import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public class FilterAllocatedObjectByFilter
implements ResourceNameElement {
    private static final String TAG = "filter allocated object by filter for the allocation trace";
    private static final int VERSION = 0;
    private final ClassFilter[] filters;

    public FilterAllocatedObjectByFilter() {
        this(new ClassFilter[0]);
    }

    public FilterAllocatedObjectByFilter(ClassFilter[] filters) {
        this.filters = filters;
    }

    public FilterAllocatedObjectByFilter(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        int nrOfEntries = reader.readInt32();
        ClassFilter[] readFilters = new ClassFilter[nrOfEntries];
        for (int i = 0; i < nrOfEntries; ++i) {
            readFilters[i] = new ClassFilter(reader);
        }
        this.filters = readFilters;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterAllocatedObjectByFilter) {
            FilterAllocatedObjectByFilter other = (FilterAllocatedObjectByFilter)obj;
            return Arrays.equals(this.filters, other.filters);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.filters);
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        ps.println("a class filter for allocated objects for the allocation trace using the following " + this.filters.length + " filters:");
        for (int i = 0; i < this.filters.length; ++i) {
            ps.println(this.filters[i].toString());
        }
        ps.close();
        return new String(bos.toByteArray());
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.filters.length);
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].write(writer);
        }
    }

    public ClassFilter[] getFilters() {
        return this.filters;
    }

    public String getTag() {
        return TAG;
    }
}

