/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.alloc.elements;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotDefiningElement;
import com.sap.jvm.profiling.snapshot.util.IdHashSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class FilterAllocationById
implements SnapshotDefiningElement {
    private static final String TAG = "filter allocated object by id";
    private static final int VERSION = 0;
    private final IdHashSet ids;

    public FilterAllocationById() {
        this((IdHashSet)null);
    }

    public FilterAllocationById(IdHashSet ids) {
        this.ids = ids;
    }

    public FilterAllocationById(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.ids = new IdHashSet(reader);
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilterAllocationById) {
            FilterAllocationById other = (FilterAllocationById)obj;
            return this.ids.equals(other.ids);
        }
        return false;
    }

    public int hashCode() {
        return this.ids.hashCode();
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        ps.println("a class filter for allocated objects for the allocation trace using the following  ids:");
        ps.println(this.ids);
        ps.close();
        return new String(bos.toByteArray());
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        this.ids.write(writer);
    }

    public IdHashSet getIds() {
        return this.ids;
    }

    public String getTag() {
        return TAG;
    }
}

